/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.network.message.receive.GunsDataMessage;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="superbwarfare")
public class GunsTool {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MinecraftServer server = player2.getServer();
            if (server != null && server.isSingleplayerOwner(player2.getGameProfile())) {
                return;
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)GunsDataMessage.create(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        MinecraftServer server = event.getPlayerList().getServer();
        GunsDataMessage message = GunsDataMessage.create();
        for (ServerPlayer player : event.getRelevantPlayers().toList()) {
            if (server.isSingleplayerOwner(player.getGameProfile())) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void setGunIntTag(CompoundTag tag, String name, int num) {
        CompoundTag data = tag.getCompound("GunData");
        data.putInt(name, num);
        tag.put("GunData", (Tag)data);
    }

    public static int getGunIntTag(CompoundTag tag, String name) {
        return GunsTool.getGunIntTag(tag, name, 0);
    }

    public static int getGunIntTag(CompoundTag tag, String name, int defaultValue) {
        CompoundTag data = tag.getCompound("GunData");
        if (!data.contains(name)) {
            return defaultValue;
        }
        return data.getInt(name);
    }

    public static double getGunDoubleTag(CompoundTag tag, String name) {
        return GunsTool.getGunDoubleTag(tag, name, 0.0);
    }

    public static double getGunDoubleTag(CompoundTag tag, String name, double defaultValue) {
        CompoundTag data = tag.getCompound("GunData");
        if (!data.contains(name)) {
            return defaultValue;
        }
        return data.getDouble(name);
    }

    @Nullable
    public static UUID getGunUUID(CompoundTag tag) {
        if (!tag.contains("GunData")) {
            return null;
        }
        CompoundTag data = tag.getCompound("GunData");
        if (!data.hasUUID("UUID")) {
            return null;
        }
        return data.getUUID("UUID");
    }
}

