/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ProjectileTool {
    public static void causeCustomExplode(ThrowableItemProjectile projectile, @Nullable DamageSource source, Entity target, float damage, float radius, float damageMultiplier) {
        ParticleTool.ParticleType particleType = radius <= 4.0f ? ParticleTool.ParticleType.SMALL : (radius > 4.0f && radius < 10.0f ? ParticleTool.ParticleType.MEDIUM : (radius >= 10.0f && radius < 16.0f ? ParticleTool.ParticleType.HUGE : ParticleTool.ParticleType.GIANT));
        new CustomExplosion.Builder((Entity)projectile).damageSource(source).damage(damage).radius(radius).position(new Vec3(target.getX(), target.getY() + 0.5 * (double)target.getBbHeight(), target.getZ())).damageMultiplier(damageMultiplier).withParticleType(particleType).particlePosition(projectile.position().add(projectile.getDeltaMovement().scale(0.5))).explode();
        Vec3 pos = projectile.position().add(projectile.getDeltaMovement().scale(0.5));
        if (projectile.level() instanceof ServerLevel) {
            projectile.level().explode(source == null ? null : source.getEntity(), pos.x, pos.y, pos.z, 0.5f * radius, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
        }
        projectile.discard();
    }

    public static void causeCustomExplode(ThrowableItemProjectile projectile, @Nullable DamageSource source, Entity target, float damage, float radius) {
        ProjectileTool.causeCustomExplode(projectile, source, target, damage, radius, 0.0f);
    }

    public static void causeCustomExplode(ThrowableItemProjectile projectile, Entity target, float damage, float radius) {
        ProjectileTool.causeCustomExplode(projectile, target, damage, radius, 0.0f);
    }

    public static void causeCustomExplode(ThrowableItemProjectile projectile, Entity target, float damage, float radius, float damageMultiplier) {
        ProjectileTool.causeCustomExplode(projectile, ModDamageTypes.causeCustomExplosionDamage(projectile.level().registryAccess(), (Entity)projectile, projectile.getOwner()), target, damage, radius, damageMultiplier);
    }

    public static void causeCustomExplode(ThrowableItemProjectile projectile, float damage, float radius, float damageMultiplier) {
        ProjectileTool.causeCustomExplode(projectile, (Entity)projectile, damage, radius, damageMultiplier);
    }

    public static void causeCustomExplode(ThrowableItemProjectile projectile, float damage, float radius) {
        ProjectileTool.causeCustomExplode(projectile, damage, radius, 0.0f);
    }
}

