/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.mojang.math.Axis;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class VectorTool {
    public static double calculateAngle(Vec3 start, Vec3 end) {
        double startLength = start.length();
        double endLength = end.length();
        if (startLength > 0.0 && endLength > 0.0) {
            return Math.toDegrees(Math.acos(Mth.clamp((double)(start.dot(end) / (startLength * endLength)), (double)-1.0, (double)1.0)));
        }
        return 0.0;
    }

    public static float calculateY(float x) {
        if (x < -90.0f) {
            return -(x + 180.0f) / 90.0f;
        }
        if (x <= 90.0f) {
            return x / 90.0f;
        }
        return (180.0f - x) / 90.0f;
    }

    public static Quaterniond combineRotations(float partialTicks, VehicleEntity entity) {
        Quaternionf yawRot = Axis.YP.rotationDegrees(-Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()));
        Quaternionf pitchRot = Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot()));
        Quaternionf rollRot = Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.prevRoll, (float)entity.getRoll()));
        Quaterniond combined = new Quaterniond((Quaternionfc)yawRot);
        combined.mul((Quaterniondc)new Quaterniond((Quaternionfc)pitchRot));
        combined.mul((Quaterniondc)new Quaterniond((Quaternionfc)rollRot));
        return combined;
    }

    public static Quaterniond combineRotationsYaw(float partialTicks, VehicleEntity entity) {
        Quaternionf yawRot = Axis.YP.rotationDegrees(-Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()));
        return new Quaterniond((Quaternionfc)yawRot);
    }

    public static Quaterniond combineRotationsTurret(float partialTicks, VehicleEntity entity) {
        Quaternionf turretYawRot = Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.turretYRotO, (float)entity.getTurretYRot()));
        Quaterniond combined = VectorTool.combineRotations(partialTicks, entity);
        combined.mul((Quaterniondc)new Quaterniond((Quaternionfc)turretYawRot));
        return combined;
    }

    public static Quaterniond combineRotationsBarrel(float partialTicks, VehicleEntity entity) {
        Quaternionf turretPitchRot = Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.turretXRotO, (float)entity.getTurretXRot()));
        Quaterniond combined = VectorTool.combineRotationsTurret(partialTicks, entity);
        combined.mul((Quaterniondc)new Quaterniond((Quaternionfc)turretPitchRot));
        return combined;
    }

    public static Vec3 randomPos(Vec3 originPos, int radius) {
        return originPos.add(new Vec3(Math.random() * (double)radius, 0.0, 0.0).yRot((float)(360.0 * Math.random()) * ((float)Math.PI / 180)));
    }

    public static boolean isInLiquid(Level level, Vec3 position) {
        BlockPos blockPos = BlockPos.containing((Position)position);
        FluidState fluidState = level.getFluidState(blockPos);
        if (!fluidState.isEmpty()) {
            float fluidHeight = fluidState.getHeight((BlockGetter)level, blockPos);
            double yOffset = position.y - (double)blockPos.getY();
            return yOffset < (double)fluidHeight;
        }
        return false;
    }

    public static Vec3 calculateReflection(Vec3 v1, Vec3 v0) {
        double dot = v1.dot(v0);
        return v1.subtract(v0.scale(2.0 * dot));
    }

    public static Vec3 lerpGetEntityBoundingBoxCenter(Entity entity, float partialTick) {
        return new Vec3(Mth.lerp((double)partialTick, (double)entity.xo, (double)entity.getX()), Mth.lerp((double)partialTick, (double)(entity.yo + (double)(entity.getBbHeight() / 2.0f)), (double)(entity.getY() + (double)(entity.getBbHeight() / 2.0f))), Mth.lerp((double)partialTick, (double)entity.zo, (double)entity.getZ()));
    }

    public static boolean checkNoClip(Vec3 pos1, Vec3 pos2, Level level) {
        return level.clip(new ClipContext(pos1, pos2, ClipContext.Block.VISUAL, ClipContext.Fluid.ANY, CollisionContext.empty())).getType() != HitResult.Type.BLOCK;
    }
}

