/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.block.entity.VehicleAssemblingTableBlockEntity;
import com.atsuishio.superbwarfare.block.property.BlockPart;
import com.atsuishio.superbwarfare.entity.vehicle.VehicleAssemblingTableVehicleEntity;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.VehicleAssemblingTableBlockItem;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="superbwarfare")
public class VehicleAssemblingTableBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<BlockPart> BLOCK_PART = EnumProperty.create((String)"block_part", BlockPart.class);

    public VehicleAssemblingTableBlock() {
        super(BlockBehaviour.Properties.of().strength(2.0f).requiresCorrectToolForDrops().noOcclusion().pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(BLOCK_PART, (Comparable)((Object)BlockPart.FLB)));
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.vehicle_assembly_table").withStyle(ChatFormatting.GRAY));
    }

    @ParametersAreNonnullByDefault
    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.getValue(BLOCK_PART) == BlockPart.FLU || pState.getValue(BLOCK_PART) == BlockPart.FRU || pState.getValue(BLOCK_PART) == BlockPart.BLU || pState.getValue(BLOCK_PART) == BlockPart.BRU) {
            return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
        }
        return super.getShape(pState, pLevel, pPos, pContext);
    }

    @ParametersAreNonnullByDefault
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos blockPos;
        super.setPlacedBy(level, pos, state, placer, stack);
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos initialPos = null;
        for (BlockPart part : BlockPart.values()) {
            blockPos = part.relativeNegative(pos, facing);
            if (!VehicleAssemblingTableBlockItem.canPlace(level, blockPos, facing, pos)) continue;
            initialPos = blockPos;
            break;
        }
        if (initialPos == null) {
            Mod.LOGGER.error("Unable to find valid position for vehicle assembling table at {}", (Object)pos);
            return;
        }
        for (BlockPart part : BlockPart.values()) {
            blockPos = part.relative(initialPos, facing);
            level.setBlock(blockPos, (BlockState)state.setValue(BLOCK_PART, (Comparable)((Object)part)), 3);
            level.blockUpdated(initialPos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, initialPos, 3);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos originalPos = ((BlockPart)((Object)state.getValue(BLOCK_PART))).relativeNegative(pos, facing);
        for (BlockPart part : BlockPart.values()) {
            BlockPos relativePos = part.relative(originalPos, facing);
            if (!relativePos.equals((Object)neighborPos) || neighborState.getBlock() == this && neighborState.getValue(BLOCK_PART) == part) continue;
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && player.isCreative()) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            BlockPart part = (BlockPart)((Object)state.getValue(BLOCK_PART));
            BlockPos originalPos = part.relativeNegative(pos, facing);
            for (BlockPart blockPart : BlockPart.values()) {
                BlockPos blockPos = blockPart.relative(originalPos, facing);
                BlockState blockState = level.getBlockState(blockPos);
                level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
                level.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @SubscribeEvent
    public static void interact(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            BlockPos pos;
            BlockState state;
            ServerLevel server = (ServerLevel)level;
            if (event.getEntity().getMainHandItem().is(ModTags.Items.TOOLS_CROWBAR) && (state = server.getBlockState(pos = event.getHitVec().getBlockPos())).getBlock() instanceof VehicleAssemblingTableBlock) {
                Direction facing = (Direction)state.getValue((Property)FACING);
                BlockPart part = (BlockPart)((Object)state.getValue(BLOCK_PART));
                BlockPos originalPos = part.relativeNegative(pos, facing);
                VehicleAssemblingTableVehicleEntity vehicle = VehicleAssemblingTableBlock.createVehicle(server, facing, originalPos);
                server.addFreshEntity((Entity)vehicle);
                for (BlockPart p : BlockPart.values()) {
                    server.destroyBlock(p.relative(originalPos, facing), false);
                }
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @NotNull
    private static VehicleAssemblingTableVehicleEntity createVehicle(ServerLevel server, Direction facing, BlockPos originalPos) {
        float deg;
        VehicleAssemblingTableVehicleEntity vehicle = new VehicleAssemblingTableVehicleEntity((Level)server);
        int xOffset = switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.WEST, Direction.UP, Direction.DOWN, Direction.SOUTH -> 1;
            case Direction.NORTH, Direction.EAST -> 0;
        };
        int zOffset = switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN, Direction.SOUTH, Direction.EAST -> 0;
            case Direction.WEST, Direction.NORTH -> 1;
        };
        vehicle.setPos(originalPos.getX() + xOffset, originalPos.getY(), originalPos.getZ() + zOffset);
        vehicle.yRotO = deg = vehicle.rotate(switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN, Direction.SOUTH -> Rotation.NONE;
            case Direction.WEST -> Rotation.CLOCKWISE_90;
            case Direction.NORTH -> Rotation.CLOCKWISE_180;
            case Direction.EAST -> Rotation.COUNTERCLOCKWISE_90;
        });
        vehicle.setYRot(deg);
        return vehicle;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof VehicleAssemblingTableBlockEntity) {
            VehicleAssemblingTableBlockEntity blockEntity2 = (VehicleAssemblingTableBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blockEntity2);
        }
        return InteractionResult.CONSUME;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING}).add(new Property[]{BLOCK_PART});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new VehicleAssemblingTableBlockEntity(pPos, pState);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return VehicleAssemblingTableBlock.simpleCodec(prop -> new VehicleAssemblingTableBlock());
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

