/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.SuperbItemInterfaceBlock;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.menu.SuperbItemInterfaceMenu;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class SuperbItemInterfaceBlockEntity
extends BaseContainerBlockEntity {
    public static final int TRANSFER_COOLDOWN = 20;
    public static final int CONTAINER_SIZE = 5;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    private int cooldownTime = -1;

    public SuperbItemInterfaceBlockEntity(BlockEntityType<?> type, BlockPos pPos, BlockState pBlockState) {
        super(type, pPos, pBlockState);
    }

    public SuperbItemInterfaceBlockEntity(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)ModBlockEntities.SUPERB_ITEM_INTERFACE.get(), pPos, pBlockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SuperbItemInterfaceBlockEntity blockEntity) {
        int z;
        int y;
        --blockEntity.cooldownTime;
        if (blockEntity.isOnCooldown()) {
            return;
        }
        blockEntity.setCooldown(20);
        if (blockEntity.isEmpty()) {
            return;
        }
        if (!((Boolean)state.getValue((Property)SuperbItemInterfaceBlock.ENABLED)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)SuperbItemInterfaceBlock.FACING);
        int x = pos.getX() + facing.getStepX();
        List list = level.getEntities((Entity)null, new AABB((double)x - 0.5, (double)(y = pos.getY() + facing.getStepY()) - 0.5, (double)(z = pos.getZ() + facing.getStepZ()) - 0.5, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5), entity -> entity.getCapability(Capabilities.ItemHandler.ENTITY, null) != null);
        if (list.isEmpty()) {
            return;
        }
        Entity target = (Entity)list.get(level.random.nextInt(list.size()));
        for (int i = 0; i < blockEntity.items.size(); ++i) {
            ItemStack stack = (ItemStack)blockEntity.items.get(i);
            if (stack.isEmpty()) continue;
            ItemStack originalStack = stack.copy();
            IItemHandler itemHandler = (IItemHandler)target.getCapability(Capabilities.ItemHandler.ENTITY, null);
            assert (itemHandler != null);
            int totalInserted = 0;
            for (int ii = 0; ii < itemHandler.getSlots(); ++ii) {
                ItemStack insertedStack;
                int inserted;
                for (inserted = stack.getCount(); inserted > 0 && (insertedStack = itemHandler.insertItem(ii, stack.copyWithCount(inserted), true)).getCount() == inserted && ItemStack.isSameItemSameComponents((ItemStack)insertedStack, (ItemStack)stack); --inserted) {
                }
                if (inserted <= 0) continue;
                itemHandler.insertItem(ii, stack.copyWithCount(inserted), false);
                stack.shrink(inserted);
                totalInserted += inserted;
            }
            if (!blockEntity.isCreative()) {
                blockEntity.items.set(i, (Object)stack);
                blockEntity.setChanged();
            } else {
                blockEntity.items.set(i, (Object)originalStack);
            }
            if (totalInserted > 0) break;
        }
    }

    protected boolean isCreative() {
        return false;
    }

    @ParametersAreNonnullByDefault
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.cooldownTime = tag.getInt("TransferCooldown");
    }

    @ParametersAreNonnullByDefault
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putInt("TransferCooldown", this.cooldownTime);
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"container.superbwarfare.superb_item_interface");
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pInventory) {
        return new SuperbItemInterfaceMenu(pContainerId, pInventory, (Container)this);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int pSlot, int pAmount) {
        return ContainerHelper.removeItem(this.items, (int)pSlot, (int)pAmount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int pSlot) {
        return ContainerHelper.takeItem(this.items, (int)pSlot);
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)pPlayer);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void setCooldown(int pCooldownTime) {
        this.cooldownTime = pCooldownTime;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> items) {
        this.items = items;
    }
}

