/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.property;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum BlockPart implements StringRepresentable
{
    FLB("flb", 0, 0, 0),
    FRB("frb", 0, 0, 1),
    FLU("flu", 0, 1, 0),
    FRU("fru", 0, 1, 1),
    BLB("blb", 1, 0, 0),
    BRB("brb", 1, 0, 1),
    BLU("blu", 1, 1, 0),
    BRU("bru", 1, 1, 1);

    private final String name;
    final int x;
    final int y;
    final int z;

    private BlockPart(String name, int x, int y, int z) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPos relative(BlockPos pos, Direction direction) {
        return new BlockPos((Vec3i)(switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.WEST, Direction.DOWN, Direction.UP -> pos.offset(this.x, this.y, this.z);
            case Direction.NORTH -> pos.offset(-this.z, this.y, this.x);
            case Direction.EAST -> pos.offset(-this.x, this.y, -this.z);
            case Direction.SOUTH -> pos.offset(this.z, this.y, -this.x);
        }));
    }

    public BlockPos relativeNegative(BlockPos pos, Direction direction) {
        return new BlockPos((Vec3i)(switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.WEST, Direction.DOWN, Direction.UP -> pos.offset(-this.x, -this.y, -this.z);
            case Direction.NORTH -> pos.offset(this.z, -this.y, -this.x);
            case Direction.EAST -> pos.offset(this.x, -this.y, this.z);
            case Direction.SOUTH -> pos.offset(-this.z, -this.y, this.x);
        }));
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }
}

