/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.capability.energy;

import com.atsuishio.superbwarfare.capability.energy.DynamicEnergyStorage;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;

public class ItemEnergyStorage
extends DynamicEnergyStorage {
    private final ItemStack stack;

    public ItemEnergyStorage(ItemStack stack, int capacity) {
        this(stack, capacity, capacity, capacity);
    }

    public ItemEnergyStorage(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
        this(stack, s -> capacity, s -> maxReceive, s -> maxExtract);
    }

    public ItemEnergyStorage(ItemStack stack, Function<ItemStack, Integer> capacityGetter, Function<ItemStack, Integer> maxReceiveGetter, Function<ItemStack, Integer> maxExtractGetter) {
        super(() -> (Integer)capacityGetter.apply(stack), () -> (Integer)maxReceiveGetter.apply(stack), () -> (Integer)maxExtractGetter.apply(stack));
        this.stack = stack;
        Integer component = (Integer)stack.get(ModDataComponents.ENERGY);
        this.energy = component == null ? 0 : component;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = super.receiveEnergy(maxReceive, simulate);
        if (received > 0 && !simulate) {
            this.stack.set(ModDataComponents.ENERGY, (Object)this.getEnergyStored());
        }
        return received;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = super.extractEnergy(maxExtract, simulate);
        if (extracted > 0 && !simulate) {
            this.stack.set(ModDataComponents.ENERGY, (Object)this.getEnergyStored());
        }
        return extracted;
    }
}

