/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.capability.energy;

import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.neoforged.neoforge.energy.EnergyStorage;
import org.jetbrains.annotations.NotNull;

public class SyncedEntityEnergyStorage
extends EnergyStorage {
    protected SynchedEntityData entityData;
    protected EntityDataAccessor<Integer> energyDataAccessor;

    public SyncedEntityEnergyStorage(int capacity, SynchedEntityData data, EntityDataAccessor<Integer> energyDataAccessor) {
        this(capacity, capacity, capacity, data, energyDataAccessor);
    }

    public SyncedEntityEnergyStorage(int capacity, int maxReceive, int maxExtract, SynchedEntityData data, EntityDataAccessor<Integer> energyDataAccessor) {
        super(capacity, maxReceive, maxExtract, 0);
        this.entityData = data;
        this.energyDataAccessor = energyDataAccessor;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        this.entityData.set(this.energyDataAccessor, (Object)energy);
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = super.receiveEnergy(maxReceive, simulate);
        if (!simulate) {
            this.entityData.set(this.energyDataAccessor, (Object)this.energy);
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = super.extractEnergy(maxExtract, simulate);
        if (!simulate) {
            this.entityData.set(this.energyDataAccessor, (Object)this.energy);
        }
        return extracted;
    }

    public int getEnergyStored() {
        return (Integer)this.entityData.get(this.energyDataAccessor);
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull Tag nbt) {
        super.deserializeNBT(provider, nbt);
        this.entityData.set(this.energyDataAccessor, (Object)this.energy);
    }
}

