/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.capability.energy;

import com.atsuishio.superbwarfare.capability.energy.SyncedEntityEnergyStorage;
import com.atsuishio.superbwarfare.data.vehicle.VehicleData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;

public class VehicleEnergyStorage
extends SyncedEntityEnergyStorage {
    protected VehicleEntity vehicle;

    public VehicleEnergyStorage(VehicleEntity vehicle) {
        super(Integer.MAX_VALUE, vehicle.getEntityData(), vehicle.getEnergyDataAccessor());
        this.vehicle = vehicle;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (VehicleData.getDefault((VehicleEntity)this.vehicle).isDefaultData) {
            return 0;
        }
        this.capacity = this.getMaxEnergyStored();
        this.maxExtract = this.getMaxEnergyStored();
        return super.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (VehicleData.getDefault((VehicleEntity)this.vehicle).isDefaultData) {
            return 0;
        }
        this.capacity = this.getMaxEnergyStored();
        this.maxReceive = this.getMaxEnergyStored();
        return super.receiveEnergy(maxReceive, simulate);
    }

    public boolean canReceive() {
        return !VehicleData.getDefault((VehicleEntity)this.vehicle).isDefaultData && super.canReceive() && this.vehicle.computed().maxEnergy > 0;
    }

    public boolean canExtract() {
        return !VehicleData.getDefault((VehicleEntity)this.vehicle).isDefaultData && super.canExtract();
    }

    public int getMaxEnergyStored() {
        return VehicleData.compute((VehicleEntity)this.vehicle).maxEnergy;
    }
}

