/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client;

import com.atsuishio.superbwarfare.client.animation.AnimationCurves;
import com.atsuishio.superbwarfare.client.decorator.ContainerItemDecorator;
import com.atsuishio.superbwarfare.client.decorator.LuckyContainerItemDecorator;
import com.atsuishio.superbwarfare.client.model.curio.ParachuteModel;
import com.atsuishio.superbwarfare.client.overlay.AmmoBarOverlay;
import com.atsuishio.superbwarfare.client.overlay.AmmoCountOverlay;
import com.atsuishio.superbwarfare.client.overlay.ArmorPlateOverlay;
import com.atsuishio.superbwarfare.client.overlay.CrossHairOverlay;
import com.atsuishio.superbwarfare.client.overlay.DroneHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.HandsomeFrameOverlay;
import com.atsuishio.superbwarfare.client.overlay.HeatBarOverlay;
import com.atsuishio.superbwarfare.client.overlay.IFFOverlay;
import com.atsuishio.superbwarfare.client.overlay.IglaHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.ItemRendererFixOverlay;
import com.atsuishio.superbwarfare.client.overlay.JavelinHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.KillMessageOverlay;
import com.atsuishio.superbwarfare.client.overlay.MortarInfoOverlay;
import com.atsuishio.superbwarfare.client.overlay.RedTriangleOverlay;
import com.atsuishio.superbwarfare.client.overlay.SpyglassRangeOverlay;
import com.atsuishio.superbwarfare.client.overlay.StaminaOverlay;
import com.atsuishio.superbwarfare.client.overlay.TowOverlay;
import com.atsuishio.superbwarfare.client.overlay.Type63InfoOverlay;
import com.atsuishio.superbwarfare.client.overlay.VehicleCrosshairOverlay;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.VehicleMainWeaponHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.VehicleTeamOverlay;
import com.atsuishio.superbwarfare.client.renderer.block.ChargingStationBlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.block.ContainerBlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.block.FuMO25BlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.block.LuckyContainerBlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.block.SmallContainerBlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.block.VehicleAssemblingTableBlockEntityRenderer;
import com.atsuishio.superbwarfare.client.renderer.curio.ParachuteRenderer;
import com.atsuishio.superbwarfare.client.tooltip.ClientBocekImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.ClientCellImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.ClientChargingStationImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.ClientDogTagImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.ClientGunImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.ClientSentinelImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.component.BocekImageComponent;
import com.atsuishio.superbwarfare.client.tooltip.component.CellImageComponent;
import com.atsuishio.superbwarfare.client.tooltip.component.ChargingStationImageComponent;
import com.atsuishio.superbwarfare.client.tooltip.component.DogTagImageComponent;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.client.tooltip.component.SentinelImageComponent;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientRenderHandler {
    public static Vec3 bulletRenderOffset = null;

    public static void transformVirtualRenderPosition(PoseStack stack, Projectile projectile, float partialTick) {
        if (bulletRenderOffset == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || projectile.getOwner() == null || !player.getUUID().equals(projectile.getOwner().getUUID())) {
            return;
        }
        double rate = 1.0 - AnimationCurves.EASE_OUT_CIRC.apply(Math.min(1.0, (double)((float)projectile.tickCount + partialTick) / 5.0));
        Vec3 offset = bulletRenderOffset.subtract(projectile.position()).multiply(rate, rate, rate);
        stack.translate(offset.x, offset.y, offset.z);
    }

    @SubscribeEvent
    public static void registerTooltip(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(GunImageComponent.class, ClientGunImageTooltip::new);
        event.register(BocekImageComponent.class, ClientBocekImageTooltip::new);
        event.register(CellImageComponent.class, ClientCellImageTooltip::new);
        event.register(SentinelImageComponent.class, ClientSentinelImageTooltip::new);
        event.register(ChargingStationImageComponent.class, ClientChargingStationImageTooltip::new);
        event.register(DogTagImageComponent.class, ClientDogTagImageTooltip::new);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.CONTAINER.get(), context -> new ContainerBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.FUMO_25.get(), context -> new FuMO25BlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.CHARGING_STATION.get(), context -> new ChargingStationBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SMALL_CONTAINER.get(), context -> new SmallContainerBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.LUCKY_CONTAINER.get(), context -> new LuckyContainerBlockEntityRenderer());
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.VEHICLE_ASSEMBLING_TABLE.get(), context -> new VehicleAssemblingTableBlockEntityRenderer());
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiLayersEvent event) {
        event.registerBelowAll(KillMessageOverlay.ID, (LayeredDraw.Layer)new KillMessageOverlay());
        event.registerBelow(KillMessageOverlay.ID, ArmorPlateOverlay.ID, (LayeredDraw.Layer)new ArmorPlateOverlay());
        event.registerBelow(ArmorPlateOverlay.ID, AmmoBarOverlay.ID, (LayeredDraw.Layer)new AmmoBarOverlay());
        event.registerBelow(AmmoBarOverlay.ID, IFFOverlay.ID, (LayeredDraw.Layer)new IFFOverlay());
        event.registerBelow(IFFOverlay.ID, VehicleTeamOverlay.ID, (LayeredDraw.Layer)new VehicleTeamOverlay());
        event.registerBelow(VehicleTeamOverlay.ID, JavelinHudOverlay.ID, (LayeredDraw.Layer)new JavelinHudOverlay());
        event.registerBelow(JavelinHudOverlay.ID, IglaHudOverlay.ID, (LayeredDraw.Layer)new IglaHudOverlay());
        event.registerBelow(IglaHudOverlay.ID, VehicleHudOverlay.ID, (LayeredDraw.Layer)new VehicleHudOverlay());
        event.registerBelow(VehicleHudOverlay.ID, VehicleMainWeaponHudOverlay.ID, (LayeredDraw.Layer)new VehicleMainWeaponHudOverlay());
        event.registerBelow(VehicleMainWeaponHudOverlay.ID, VehicleCrosshairOverlay.ID, (LayeredDraw.Layer)new VehicleCrosshairOverlay());
        event.registerBelowAll(StaminaOverlay.ID, (LayeredDraw.Layer)new StaminaOverlay());
        event.registerBelowAll(AmmoCountOverlay.ID, (LayeredDraw.Layer)new AmmoCountOverlay());
        event.registerBelowAll(ItemRendererFixOverlay.ID, (LayeredDraw.Layer)new ItemRendererFixOverlay());
        event.registerBelowAll(CrossHairOverlay.ID, (LayeredDraw.Layer)new CrossHairOverlay());
        event.registerBelowAll(HeatBarOverlay.ID, (LayeredDraw.Layer)new HeatBarOverlay());
        event.registerBelowAll(DroneHudOverlay.ID, (LayeredDraw.Layer)new DroneHudOverlay());
        event.registerBelowAll(RedTriangleOverlay.ID, (LayeredDraw.Layer)new RedTriangleOverlay());
        event.registerBelowAll(HandsomeFrameOverlay.ID, (LayeredDraw.Layer)new HandsomeFrameOverlay());
        event.registerBelowAll(SpyglassRangeOverlay.ID, (LayeredDraw.Layer)new SpyglassRangeOverlay());
        event.registerBelowAll(TowOverlay.ID, (LayeredDraw.Layer)new TowOverlay());
        event.registerBelowAll(MortarInfoOverlay.ID, (LayeredDraw.Layer)new MortarInfoOverlay());
        event.registerBelowAll(Type63InfoOverlay.ID, (LayeredDraw.Layer)new Type63InfoOverlay());
    }

    @SubscribeEvent
    public static void registerItemDecorations(RegisterItemDecorationsEvent event) {
        event.register((ItemLike)ModItems.CONTAINER.get(), (IItemDecorator)new ContainerItemDecorator());
        event.register((ItemLike)ModItems.LUCKY_CONTAINER.get(), (IItemDecorator)new LuckyContainerItemDecorator());
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        CuriosRendererRegistry.register((Item)((Item)ModItems.PARACHUTE.get()), ParachuteRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ParachuteModel.LAYER_LOCATION, ParachuteModel::createBodyLayer);
    }
}

