/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.decorator;

import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.item.common.container.LuckyContainerBlockItem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.IItemDecorator;

@OnlyIn(value=Dist.CLIENT)
public class LuckyContainerItemDecorator
implements IItemDecorator {
    @ParametersAreNonnullByDefault
    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        if (!(stack.getItem() instanceof LuckyContainerBlockItem)) {
            return false;
        }
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data == null) {
            return false;
        }
        CompoundTag tag = data.copyTag();
        if (!tag.contains("Icon")) {
            return false;
        }
        String iconTag = tag.getString("Icon");
        ResourceLocation icon = ResourceLocation.tryParse((String)iconTag);
        if (icon == null) {
            return false;
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        RenderHelper.preciseBlit(guiGraphics, icon, xOffset, yOffset, 200.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
        pose.popPose();
        return true;
    }
}

