/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.model.entity;

import com.atsuishio.superbwarfare.client.model.entity.VehicleModel;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.A10Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class A10Model
extends VehicleModel<A10Entity> {
    @Override
    @Nullable
    public VehicleModel.TransformContext<A10Entity> collectTransform(String boneName) {
        return switch (boneName) {
            case "root" -> (bone, vehicle, state) -> bone.setHidden(this.hideForTurretControllerWhileZooming && vehicle.getWeaponIndex(0) == 2);
            case "wingLR" -> (bone, vehicle, state) -> bone.setRotX(1.5f * Mth.lerp((float)state.getPartialTick(), (float)vehicle.flap1LRotO, (float)vehicle.getFlap1LRot()) * ((float)Math.PI / 180));
            case "wingRR" -> (bone, vehicle, state) -> bone.setRotX(1.5f * Mth.lerp((float)state.getPartialTick(), (float)vehicle.flap1RRotO, (float)vehicle.getFlap1RRot()) * ((float)Math.PI / 180));
            case "wingLR2" -> (bone, vehicle, state) -> bone.setRotX(1.5f * Mth.lerp((float)state.getPartialTick(), (float)vehicle.flap1L2RotO, (float)vehicle.getFlap1L2Rot()) * ((float)Math.PI / 180));
            case "wingRR2" -> (bone, vehicle, state) -> bone.setRotX(1.5f * Mth.lerp((float)state.getPartialTick(), (float)vehicle.flap1R2RotO, (float)vehicle.getFlap1R2Rot()) * ((float)Math.PI / 180));
            case "wingLB" -> (bone, vehicle, state) -> bone.setRotX(Mth.lerp((float)state.getPartialTick(), (float)vehicle.flap2LRotO, (float)vehicle.getFlap2LRot()) * ((float)Math.PI / 180));
            case "wingRB" -> (bone, vehicle, state) -> bone.setRotX(Mth.lerp((float)state.getPartialTick(), (float)vehicle.flap2RRotO, (float)vehicle.getFlap2RRot()) * ((float)Math.PI / 180));
            case "weiyiL", "weiyiR" -> (bone, vehicle, state) -> bone.setRotY(Mth.clamp((float)Mth.lerp((float)state.getPartialTick(), (float)vehicle.flap3RotO, (float)vehicle.getFlap3Rot()), (float)-20.0f, (float)20.0f) * ((float)Math.PI / 180));
            case "gear", "gear2", "gear3" -> (bone, vehicle, state) -> bone.setRotX(vehicle.gearRot(state.getPartialTick()) * ((float)Math.PI / 180));
            case "qianzhou", "qianzhou2" -> (bone, vehicle, state) -> bone.setRotZ(Mth.lerp((float)state.getPartialTick(), (float)vehicle.propellerRotO, (float)vehicle.getPropellerRot()));
            case "bomb1" -> (bone, vehicle, state) -> bone.setHidden(this.shouldHideBomb(vehicle, 3));
            case "bomb2" -> (bone, vehicle, state) -> bone.setHidden(this.shouldHideBomb(vehicle, 2));
            case "bomb3" -> (bone, vehicle, state) -> bone.setHidden(this.shouldHideBomb(vehicle, 1));
            case "missile1" -> (bone, vehicle, state) -> bone.setHidden(this.shouldHideMissile(vehicle, 4));
            case "missile2" -> (bone, vehicle, state) -> bone.setHidden(this.shouldHideMissile(vehicle, 3));
            case "missile3" -> (bone, vehicle, state) -> bone.setHidden(this.shouldHideMissile(vehicle, 2));
            case "missile4" -> (bone, vehicle, state) -> bone.setHidden(this.shouldHideMissile(vehicle, 1));
            default -> null;
        };
    }

    public boolean shouldHideBomb(VehicleEntity vehicle, int ammo) {
        GunData gunData = vehicle.getGunData("Bomb");
        if (gunData == null) {
            return false;
        }
        return gunData.ammo.get() < ammo;
    }

    public boolean shouldHideMissile(VehicleEntity vehicle, int ammo) {
        GunData gunData = vehicle.getGunData("Missile");
        if (gunData == null) {
            return false;
        }
        return gunData.ammo.get() < ammo;
    }
}

