/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.model.entity;

import com.atsuishio.superbwarfare.client.model.entity.VehicleModel;
import com.atsuishio.superbwarfare.entity.vehicle.AnnihilatorEntity;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class AnnihilatorModel
extends VehicleModel<AnnihilatorEntity> {
    private final Pattern LED_PATTERN = Pattern.compile("led(?<type>green|red)(?<id>\\d+)");

    @Override
    @Nullable
    public VehicleModel.TransformContext<AnnihilatorEntity> collectTransform(String boneName) {
        return switch (boneName) {
            case "laser1" -> (bone, vehicle, state) -> bone.setScaleZ(((Float)vehicle.getEntityData().get(AnnihilatorEntity.LASER_LEFT_LENGTH)).floatValue());
            case "laser2" -> (bone, vehicle, state) -> bone.setScaleZ(((Float)vehicle.getEntityData().get(AnnihilatorEntity.LASER_MIDDLE_LENGTH)).floatValue());
            case "laser3" -> (bone, vehicle, state) -> bone.setScaleZ(((Float)vehicle.getEntityData().get(AnnihilatorEntity.LASER_RIGHT_LENGTH)).floatValue());
            default -> {
                Matcher matcher = this.LED_PATTERN.matcher(boneName);
                if (matcher.matches()) {
                    boolean isGreen = matcher.group("type").equals("green");
                    int id = Integer.parseInt(matcher.group("id"));
                    yield (bone, vehicle, state) -> {
                        float charge = ((Float)vehicle.getEntityData().get(AnnihilatorEntity.CHARGE_PROGRESS)).floatValue();
                        boolean cantShoot = charge > 1.0f;
                        boolean hideGreen = 5.0f * charge < (float)id || cantShoot;
                        bone.setHidden(isGreen == hideGreen);
                    };
                }
                yield super.collectTransform(boneName);
            }
        };
    }
}

