/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.model.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.resource.ModelResource;
import com.atsuishio.superbwarfare.resource.vehicle.DefaultVehicleResource;
import com.atsuishio.superbwarfare.resource.vehicle.VehicleResource;
import com.atsuishio.superbwarfare.tools.ResourceOnceLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

public class VehicleModel<T extends VehicleEntity>
extends GeoModel<T> {
    protected float pitch;
    protected float yaw;
    protected float roll;
    protected float leftWheelRot;
    protected float rightWheelRot;
    protected float leftTrack;
    protected float rightTrack;
    protected float turretYRot;
    protected float turretXRot;
    protected float turretYaw;
    protected float recoilShake;
    protected boolean hideForTurretControllerWhileZooming;
    protected boolean hideForPassengerWeaponStationControllerWhileZooming;
    private final ResourceOnceLogger LOGGER = new ResourceOnceLogger();
    protected ResourceLocation modelCache = null;
    protected ResourceLocation textureCache = null;
    public static final Pattern TRACK_PATTERN = Pattern.compile("^track(?<type>Mov|Rot)(?<direction>[LR])(?<id>\\d+)$");
    public static final Pattern WHEEL_PATTERN = Pattern.compile("^wheel(?<direction>[LR]).*$");
    protected boolean init = false;
    protected final List<Pair<String, TransformContext<T>>> TRANSFORMS = new ArrayList<Pair<String, TransformContext<T>>>();

    public ResourceLocation getAnimationResource(T vehicle) {
        return VehicleModel.getDefault(vehicle).getModel().animation;
    }

    public ResourceLocation getModelResource(T vehicle) {
        if (RenderHelper.isInGui()) {
            return VehicleModel.getDefault(vehicle).getModel().model;
        }
        int lodLevel = this.getLODLevel(vehicle);
        ResourceLocation lodModel = VehicleModel.getDefault(vehicle).getModel().getLODModel(lodLevel);
        if (lodModel == null) {
            ResourceLocation loc;
            if (this.modelCache != null) {
                return this.modelCache;
            }
            this.LOGGER.log(vehicle, logger -> logger.error("failed to load model for {}!", vehicle));
            this.modelCache = loc = Mod.loc("geo/" + EntityType.getKey((EntityType)vehicle.getType()).getPath() + ".geo.json");
            return loc;
        }
        this.modelCache = lodModel;
        return lodModel;
    }

    public ResourceLocation getTextureResource(T vehicle) {
        if (RenderHelper.isInGui()) {
            return VehicleModel.getDefault(vehicle).getModel().texture;
        }
        int lodLevel = this.getLODLevel(vehicle);
        ResourceLocation lodTexture = VehicleModel.getDefault(vehicle).getModel().getLODTexture(lodLevel);
        if (lodTexture == null) {
            ResourceLocation loc;
            if (this.textureCache != null) {
                return this.textureCache;
            }
            this.LOGGER.log(vehicle, logger -> logger.error("failed to load texture for {}!", vehicle));
            this.textureCache = loc = Mod.loc("textures/entity/" + EntityType.getKey((EntityType)vehicle.getType()).getPath() + ".png");
            return loc;
        }
        this.textureCache = lodTexture;
        return lodTexture;
    }

    public int getLODLevel(T vehicle) {
        DefaultVehicleResource defaultData = VehicleModel.getDefault(vehicle);
        ModelResource model = defaultData.getModel();
        if (defaultData.lodDistance == null || defaultData.lodDistance.list.isEmpty() || !model.hasLOD()) {
            return 0;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isScoping()) {
            return 0;
        }
        double distance = player.position().distanceTo(vehicle.position());
        for (int i = 0; i < defaultData.lodDistance.list.size(); ++i) {
            if (!(distance <= (Double)defaultData.lodDistance.list.get(i))) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private static <T extends VehicleEntity> DefaultVehicleResource getDefault(T vehicle) {
        return VehicleResource.getDefault(vehicle);
    }

    @Nullable
    public TransformContext<T> collectTransform(String boneName) {
        if (boneName.equals("root") && this.hideForTurretControllerWhileZooming()) {
            return (bone, vehicle, state) -> bone.setHidden(this.hideForTurretControllerWhileZooming);
        }
        if (boneName.equals("passengerWeaponStation") && this.hideForTurretControllerWhileZooming()) {
            return (bone, vehicle, state) -> bone.setHidden(this.hideForPassengerWeaponStationControllerWhileZooming);
        }
        if (boneName.equals("laser")) {
            return (bone, vehicle, state) -> {
                bone.setScaleZ(10.0f * ((Float)vehicle.getEntityData().get(VehicleEntity.LASER_LENGTH)).floatValue());
                float scale = Math.min(Mth.lerp((float)state.getPartialTick(), (float)((Float)vehicle.getEntityData().get(VehicleEntity.LASER_SCALE_O)).floatValue(), (float)((Float)vehicle.getEntityData().get(VehicleEntity.LASER_SCALE)).floatValue()), 1.2f);
                bone.setScaleX(scale);
                bone.setScaleY(scale);
            };
        }
        switch (boneName) {
            case "base": {
                return (bone, vehicle, state) -> {
                    float a = ((Float)vehicle.getEntityData().get(VehicleEntity.YAW_WHILE_SHOOT)).floatValue();
                    float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
                    float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
                    bone.setPosX(r2 * this.recoilShake * 0.5f);
                    bone.setPosZ(r * this.recoilShake * 1.0f);
                    bone.setRotX(r * this.recoilShake * ((float)Math.PI / 180));
                    bone.setRotZ(r2 * this.recoilShake * ((float)Math.PI / 180));
                };
            }
            case "turret": {
                return (bone, vehicle, state) -> {
                    bone.setRotY(this.turretYRot * ((float)Math.PI / 180));
                    GeoBone turretLaser = this.getAnimationProcessor().getBone("turretLaser");
                    if (turretLaser != null) {
                        turretLaser.setRotY(bone.getRotY());
                    }
                };
            }
            case "barrel": {
                return (bone, vehicle, state) -> {
                    float a = this.turretYaw;
                    float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
                    float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
                    bone.setRotX(Mth.clamp((float)(-this.turretXRot - r * this.pitch - r2 * this.roll), (float)vehicle.getTurretMinPitch(), (float)vehicle.getTurretMaxPitch()) * ((float)Math.PI / 180));
                    GeoBone barrelLaser = this.getAnimationProcessor().getBone("barrelLaser");
                    if (barrelLaser != null) {
                        barrelLaser.setRotX(bone.getRotX());
                    }
                };
            }
            case "passengerWeaponStationYaw": {
                return (bone, vehicle, state) -> bone.setRotY(Mth.lerp((float)state.getPartialTick(), (float)vehicle.gunYRotO, (float)vehicle.getGunYRot()) * ((float)Math.PI / 180) - this.turretYRot * ((float)Math.PI / 180));
            }
            case "passengerWeaponStationPitch": {
                return (bone, vehicle, state) -> {
                    float a = vehicle.getTurretYaw(state.getPartialTick());
                    float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
                    float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
                    bone.setRotX(Mth.clamp((float)(-Mth.lerp((float)state.getPartialTick(), (float)vehicle.gunXRotO, (float)vehicle.getGunXRot()) * ((float)Math.PI / 180) - r * this.pitch * ((float)Math.PI / 180) - r2 * this.roll * ((float)Math.PI / 180)), (float)-0.17453292f, (float)1.0471976f));
                };
            }
        }
        Matcher trackMatcher = TRACK_PATTERN.matcher(boneName);
        if (trackMatcher.matches()) {
            boolean isRot = trackMatcher.group("type").equals("Rot");
            boolean isL = trackMatcher.group("direction").equals("L");
            int index = Integer.parseInt(trackMatcher.group("id"));
            if (isRot) {
                if (isL) {
                    return (bone, vehicle, state) -> {
                        float t = this.wrap(this.leftTrack + (float)(2 * index), vehicle);
                        bone.setRotX(-this.getBoneRotX(t) * ((float)Math.PI / 180));
                    };
                }
                return (bone, vehicle, state) -> {
                    float t2 = this.wrap(this.rightTrack + (float)(2 * index), vehicle);
                    bone.setRotX(-this.getBoneRotX(t2) * ((float)Math.PI / 180));
                };
            }
            if (isL) {
                return (bone, vehicle, state) -> {
                    float t = this.wrap(this.leftTrack + (float)(2 * index), vehicle);
                    bone.setPosY(this.getBoneMoveY(t));
                    bone.setPosZ(this.getBoneMoveZ(t));
                };
            }
            return (bone, vehicle, state) -> {
                float t2 = this.wrap(this.rightTrack + (float)(2 * index), vehicle);
                bone.setPosY(this.getBoneMoveY(t2));
                bone.setPosZ(this.getBoneMoveZ(t2));
            };
        }
        Matcher wheelMatcher = WHEEL_PATTERN.matcher(boneName);
        if (wheelMatcher.matches()) {
            boolean isL = wheelMatcher.group("direction").equals("L");
            if (boneName.endsWith("Turn")) {
                return (bone, vehicle, state) -> {
                    bone.setRotX(1.5f * (isL ? this.leftWheelRot : this.rightWheelRot));
                    bone.setRotY(Mth.lerp((float)state.getPartialTick(), (float)vehicle.rudderRotO, (float)vehicle.getRudderRot()));
                };
            }
            return (bone, vehicle, state) -> bone.setRotX(1.5f * (isL ? this.leftWheelRot : this.rightWheelRot));
        }
        return null;
    }

    public void setCustomAnimations(T vehicle, long instanceId, AnimationState<T> animationState) {
        if (!this.init) {
            this.getAnimationProcessor().getRegisteredBones().forEach(bone -> {
                String name = bone.getName();
                try {
                    TransformContext<T> transform = this.collectTransform(name);
                    if (transform != null) {
                        this.TRANSFORMS.add(new Pair((Object)name, transform));
                    }
                }
                catch (Exception exception) {
                    Mod.LOGGER.error("failed to collect transform for vehicle {} bone {}:", (Object)vehicle, (Object)name, (Object)exception);
                }
            });
            this.init = true;
        }
        float partialTick = animationState.getPartialTick();
        this.pitch = ((VehicleEntity)vehicle).getPitch(partialTick);
        this.yaw = ((VehicleEntity)vehicle).getYaw(partialTick);
        this.roll = ((VehicleEntity)vehicle).getRoll(partialTick);
        this.leftWheelRot = Mth.lerp((float)partialTick, (float)((VehicleEntity)vehicle).leftWheelRotO, (float)((VehicleEntity)vehicle).getLeftWheelRot());
        this.rightWheelRot = Mth.lerp((float)partialTick, (float)((VehicleEntity)vehicle).rightWheelRotO, (float)((VehicleEntity)vehicle).getRightWheelRot());
        this.leftTrack = Mth.lerp((float)partialTick, (float)((VehicleEntity)vehicle).leftTrackO, (float)((VehicleEntity)vehicle).getLeftTrack());
        this.rightTrack = Mth.lerp((float)partialTick, (float)((VehicleEntity)vehicle).rightTrackO, (float)((VehicleEntity)vehicle).getRightTrack());
        this.turretYRot = Mth.lerp((float)partialTick, (float)((VehicleEntity)vehicle).turretYRotO, (float)((VehicleEntity)vehicle).getTurretYRot());
        this.turretXRot = Mth.lerp((float)partialTick, (float)((VehicleEntity)vehicle).turretXRotO, (float)((VehicleEntity)vehicle).getTurretXRot());
        this.turretYaw = ((VehicleEntity)vehicle).getTurretYaw(partialTick);
        this.recoilShake = Mth.lerp((float)partialTick, (float)((float)((VehicleEntity)vehicle).recoilShakeO), (float)((float)((VehicleEntity)vehicle).getRecoilShake()));
        this.hideForTurretControllerWhileZooming = ClientEventHandler.zoomVehicle && ((VehicleEntity)vehicle).getNthEntity(((VehicleEntity)vehicle).getTurretControllerIndex()) == Minecraft.getInstance().player;
        this.hideForPassengerWeaponStationControllerWhileZooming = ClientEventHandler.zoomVehicle && ((VehicleEntity)vehicle).getNthEntity(((VehicleEntity)vehicle).getPassengerWeaponStationControllerIndex()) == Minecraft.getInstance().player;
        this.TRANSFORMS.forEach(pair -> {
            String name = (String)pair.getA();
            GeoBone bone = this.getAnimationProcessor().getBone(name);
            if (bone != null) {
                ((TransformContext)pair.getB()).transform(bone, vehicle, animationState);
            }
        });
    }

    public boolean hideForTurretControllerWhileZooming() {
        return false;
    }

    public float getBoneRotX(float t) {
        return t;
    }

    public float getBoneMoveY(float t) {
        return t;
    }

    public float getBoneMoveZ(float t) {
        return t;
    }

    protected float wrap(float value, int range) {
        return (value % (float)range + (float)range) % (float)range;
    }

    protected float wrap(float value, VehicleEntity vehicle) {
        return this.wrap(value, this.getDefaultWrapRange(vehicle));
    }

    public int getDefaultWrapRange(VehicleEntity vehicle) {
        return vehicle.getTrackAnimationLength();
    }

    @FunctionalInterface
    public static interface TransformContext<T extends VehicleEntity> {
        public void transform(GeoBone var1, T var2, AnimationState<T> var3);
    }
}

