/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class IglaHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("igla_9k38_hud");
    private static final ResourceLocation FRAME = Mod.loc("textures/overlay/frame/frame_diamond.png");
    private static final ResourceLocation PART_1 = Mod.loc("textures/overlay/igla_9k38/part_1.png");
    private static final ResourceLocation PART_2 = Mod.loc("textures/overlay/igla_9k38/part_2.png");
    private static final ResourceLocation PART_3 = Mod.loc("textures/overlay/igla_9k38/part_3.png");
    private static final ResourceLocation PART_4 = Mod.loc("textures/overlay/igla_9k38/part_4.png");
    private static final ResourceLocation HOLD = Mod.loc("textures/overlay/igla_9k38/hold.png");
    private static final ResourceLocation SHOOT = Mod.loc("textures/overlay/igla_9k38/shoot.png");
    private static final ResourceLocation IGLA_SCOPE = Mod.loc("textures/overlay/igla_9k38/igla_scope.png");
    private static float scopeScale = 1.0f;
    private static float lerpSeeking = 1.0f;

    public void render(GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        VehicleEntity vehicle;
        LocalPlayer player = Minecraft.getInstance().player;
        PoseStack poseStack = guiGraphics.pose();
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (ClientEventHandler.isEditing) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).banHand((LivingEntity)player)) {
            return;
        }
        if (stack.getItem() == ModItems.IGLA_9K38.get() && ClientEventHandler.zoomPos > 0.83 && Minecraft.getInstance().options.getCameraType().isFirstPerson() && ClientEventHandler.zoom) {
            GunData data = GunData.from(stack);
            poseStack.pushPose();
            float deltaFrame = deltaTracker.getGameTimeDeltaPartialTick(true);
            float moveX = (float)(-32.0 * ClientEventHandler.turnRot[1] - (double)(player.isSprinting() ? 100 : 67) * ClientEventHandler.movePosX + 3.0 * ClientEventHandler.cameraRot[2]);
            float moveY = (float)(-32.0 * ClientEventHandler.turnRot[0] + (double)(100.0f * (float)ClientEventHandler.velocityY) - (double)(player.isSprinting() ? 100 : 67) * ClientEventHandler.movePosY - 12.0 * ClientEventHandler.firePos + 3.0 * ClientEventHandler.cameraRot[1]);
            scopeScale = (float)Mth.lerp((double)(0.5f * deltaFrame), (double)scopeScale, (double)((double)1.35f + (double)0.2f * ClientEventHandler.firePos));
            float f = Math.min(screenWidth, screenHeight);
            float f1 = Math.min((float)screenWidth / f, (float)screenHeight / f) * scopeScale;
            float i = Mth.floor((float)(f * f1));
            float j = Mth.floor((float)(f * f1));
            Vec3 pCross = VectorUtil.worldToScreen(camera.getPosition().add(new Vec3(camera.getLookVector())));
            float x0 = (float)pCross.x + 4.0f * moveX;
            float y0 = (float)pCross.y + 4.0f * moveY;
            BlockPos blockPos = player.blockPosition();
            int combinedLightLevel = player.level().getMaxLocalRawBrightness(blockPos);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)((float)combinedLightLevel / 15.0f), (float)((float)combinedLightLevel / 15.0f), (float)((float)combinedLightLevel / 15.0f), (float)1.0f);
            RenderHelper.preciseBlit(guiGraphics, IGLA_SCOPE, x0 - 1.5f * i, y0 - 1.5f * j, 0.0f, 0.0f, 3.0f * i, 3.0f * j, 3.0f * i, 3.0f * j);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Vec3 cameraPos = camera.getPosition();
            Entity decoy = TraceTool.findLookDecoy((Player)player, cameraPos, player.getViewVector(deltaFrame), 512.0);
            if (decoy == null) {
                Entity targetEntity = ClientEventHandler.lockOn ? ClientEventHandler.lockingEntity : ClientEventHandler.seekingEntity;
                int seekingTime = ClientEventHandler.seekingTime;
                lerpSeeking = Mth.lerp((float)deltaFrame, (float)lerpSeeking, (float)((float)Mth.clamp((int)(data.compute().seekTime - seekingTime), (int)0, (int)data.compute().seekTime) * 0.6f));
                if (targetEntity != null) {
                    Vec3 pos = VectorTool.lerpGetEntityBoundingBoxCenter(targetEntity, deltaFrame);
                    Vec3 point = VectorUtil.worldToScreen(pos);
                    float x = (float)point.x;
                    float y = (float)point.y;
                    poseStack.pushPose();
                    poseStack.translate(x, y, 0.0f);
                    RenderHelper.preciseBlit(guiGraphics, FRAME, -12.0f, -12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1.0f);
                    RenderHelper.preciseBlit(guiGraphics, PART_1, -12.0f - lerpSeeking, -12.0f - lerpSeeking, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1.0f);
                    RenderHelper.preciseBlit(guiGraphics, PART_2, -12.0f + lerpSeeking, -12.0f - lerpSeeking, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1.0f);
                    RenderHelper.preciseBlit(guiGraphics, PART_3, -12.0f - lerpSeeking, -12.0f + lerpSeeking, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1.0f);
                    RenderHelper.preciseBlit(guiGraphics, PART_4, -12.0f + lerpSeeking, -12.0f + lerpSeeking, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1.0f);
                    if (seekingTime >= data.compute().seekTime && data.ammo.get() > 0) {
                        RenderHelper.preciseBlit(guiGraphics, SHOOT, -12.0f, -26.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1.0f);
                    } else {
                        RenderHelper.preciseBlit(guiGraphics, HOLD, -12.0f, -26.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, -1.0f);
                    }
                    poseStack.pushPose();
                    String range = FormatTool.format0D(player.distanceTo(targetEntity));
                    int width = Minecraft.getInstance().font.width(range);
                    poseStack.scale(0.8f, 0.8f, 1.0f);
                    poseStack.translate(0.1f, 0.0f, 0.0f);
                    guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)range), (int)(-((float)width) / 2.0f), 14, 16766646, false);
                    poseStack.popPose();
                    poseStack.popPose();
                }
            }
            poseStack.popPose();
        } else {
            scopeScale = 1.0f;
        }
    }
}

