/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.SmokeDecoyEntity;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AutoAimableEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VehicleTeamOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("vehicle_team");

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        boolean outOfRange;
        Entity decoy;
        if (!((Boolean)DisplayConfig.VEHICLE_INFO.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        Vec3 viewVec = new Vec3(camera.getLookVector());
        PoseStack poseStack = guiGraphics.pose();
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        ItemStack stack = player.getMainHandItem();
        boolean lookAtEntity = false;
        double entityRange = 0.0;
        Entity lookingEntity = TraceTool.camerafFindLookingEntity((Player)player, cameraPos, viewVec, ((Integer)VehicleConfig.VEHICLE_INFO_DISPLAY_DISTANCE.get()).intValue());
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            lookingEntity = vehicle.getPlayerLookAtEntityOnVehicle((Entity)player, 512.0, partialTick);
            viewVec = vehicle.getViewVec((Entity)player, partialTick);
        }
        if ((decoy = TraceTool.findLookDecoy((Player)player, cameraPos, viewVec, 512.0)) != null && decoy.getType().is(ModTags.EntityTypes.DECOY)) {
            return;
        }
        if (lookingEntity instanceof SmokeDecoyEntity) {
            return;
        }
        if (lookingEntity != null) {
            lookAtEntity = true;
            entityRange = player.distanceTo(lookingEntity);
        }
        CompoundTag tag = NBTTool.getTag(stack);
        boolean usingDrone = stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked");
        boolean bl = outOfRange = entityRange > (double)((Integer)VehicleConfig.VEHICLE_INFO_DISPLAY_DISTANCE.get()).intValue();
        if (lookAtEntity && lookingEntity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)lookingEntity;
            if (!usingDrone && !outOfRange) {
                Font font;
                if (entityRange > (double)((Integer)VehicleConfig.VEHICLE_INFO_DISPLAY_DISTANCE.get()).intValue()) {
                    return;
                }
                Vec3 pos = VectorTool.lerpGetEntityBoundingBoxCenter(lookingEntity, partialTick).add(new Vec3(0.0, (double)(lookingEntity.getBbHeight() / 2.0f) + 0.5, 0.0));
                Vec3 centerPos = VectorTool.lerpGetEntityBoundingBoxCenter(lookingEntity, partialTick);
                if (VectorUtil.canSee(pos)) {
                    Object info;
                    Vec3 point = VectorUtil.worldToScreen(pos);
                    float x = (float)point.x;
                    float y = (float)point.y;
                    poseStack.pushPose();
                    poseStack.translate(x, y - 12.0f, 0.0f);
                    float size = (float)Mth.clamp((double)(50.0 / VectorUtil.fov * (double)0.9f * Math.max((512.0 - entityRange) / 512.0, 0.1)), (double)0.4, (double)1.0);
                    poseStack.scale(size, size, size);
                    font = Minecraft.getInstance().font;
                    int color = -1;
                    if (vehicle instanceof DroneEntity) {
                        DroneEntity drone = (DroneEntity)vehicle;
                        Player controller = EntityFindUtil.findPlayer(drone.level(), (String)drone.getEntityData().get(DroneEntity.CONTROLLER));
                        if (controller != null) {
                            color = controller.getTeamColor();
                            team = player.getTeam();
                            if (team instanceof PlayerTeam) {
                                playerTeam = team;
                                String info2 = vehicle.getDisplayName().getString() + " " + controller.getDisplayName().getString() + (String)(controller.getTeam() == null ? "" : " <" + playerTeam.getDisplayName().getString() + ">");
                                guiGraphics.drawString(font, (Component)Component.literal((String)info2), -font.width(info2) / 2, -13, color, false);
                            }
                        } else {
                            info = lookingEntity.getDisplayName().getString();
                            guiGraphics.drawString(font, (Component)Component.literal((String)info), -font.width((String)info) / 2, -13, color, false);
                        }
                    } else if (vehicle instanceof OwnableEntity) {
                        OwnableEntity ownableEntity = (OwnableEntity)vehicle;
                        info = ownableEntity.getOwner();
                        if (info instanceof Player) {
                            player1 = (Player)info;
                            color = player1.getTeamColor();
                            team = player.getTeam();
                            if (team instanceof PlayerTeam) {
                                playerTeam = team;
                                String info3 = vehicle.getDisplayName().getString() + " " + player1.getDisplayName().getString() + (String)(player1.getTeam() == null ? "" : " <" + playerTeam.getDisplayName().getString() + ">");
                                guiGraphics.drawString(font, (Component)Component.literal((String)info3), -font.width(info3) / 2, -13, color, false);
                            }
                        } else {
                            info = lookingEntity.getDisplayName().getString();
                            guiGraphics.drawString(font, (Component)Component.literal((String)info), -font.width((String)info) / 2, -13, color, false);
                        }
                    } else if (vehicle.getMaxPassengers() > 0 && (info = vehicle.getFirstPassenger()) instanceof Player) {
                        player1 = (Player)info;
                        color = player1.getTeamColor();
                        team = player.getTeam();
                        if (team instanceof PlayerTeam) {
                            playerTeam = team;
                            String info4 = vehicle.getDisplayName().getString() + " " + player1.getDisplayName().getString() + (String)(player1.getTeam() == null ? "" : " <" + playerTeam.getDisplayName().getString() + ">");
                            guiGraphics.drawString(font, (Component)Component.literal((String)info4), -font.width(info4) / 2, -13, color, false);
                        }
                    } else {
                        info = vehicle.getDisplayName().getString();
                        guiGraphics.drawString(font, (Component)Component.literal((String)info), -font.width((String)info) / 2, -13, color, false);
                    }
                    String range = FormatTool.format1D(entityRange, "M");
                    int argb = 0xFF000000 | color;
                    guiGraphics.drawString(font, (Component)Component.literal((String)range), -font.width(range) / 2, 7, color, false);
                    RenderHelper.fill(guiGraphics, RenderType.guiOverlay(), -40.5f, -2.0f, 40.5f, 2.0f, 0.0f, Integer.MIN_VALUE);
                    RenderHelper.fill(guiGraphics, RenderType.guiOverlay(), -41.5f, -3.0f, -40.5f, 3.0f, 0.0f, argb);
                    RenderHelper.fill(guiGraphics, RenderType.guiOverlay(), -40.5f, -3.0f, 40.5f, -2.0f, 0.0f, argb);
                    RenderHelper.fill(guiGraphics, RenderType.guiOverlay(), -40.5f, 2.0f, 40.5f, 3.0f, 0.0f, argb);
                    RenderHelper.fill(guiGraphics, RenderType.guiOverlay(), 40.5f, -3.0f, 41.5f, 3.0f, 0.0f, argb);
                    RenderHelper.fill(guiGraphics, RenderType.guiOverlay(), -40.0f, -1.5f, -40.0f + 80.0f * (vehicle.getHealth() / vehicle.getMaxHealth()), 1.5f, 0.0f, argb);
                    poseStack.popPose();
                }
                if (vehicle instanceof AutoAimableEntity) {
                    AutoAimableEntity autoAimableEntity = (AutoAimableEntity)vehicle;
                    if (VectorUtil.canSee(centerPos) && player.distanceTo((Entity)autoAimableEntity) < 4.0f) {
                        Vec3 point = VectorUtil.worldToScreen(centerPos);
                        float x = (float)point.x;
                        float y = (float)point.y;
                        poseStack.pushPose();
                        poseStack.translate(x, y - 12.0f, 0.0f);
                        font = Minecraft.getInstance().font;
                        LivingEntity entity2 = autoAimableEntity.getOwner();
                        if (entity2 != null) {
                            int color = autoAimableEntity.getOwner().getTeamColor();
                            boolean active = (Boolean)autoAimableEntity.getEntityData().get(AutoAimableEntity.ACTIVE);
                            String info = active ? "tips.superbwarfare.auto_aimable_entity.active" : "tips.superbwarfare.auto_aimable_entity.inactive";
                            MutableComponent component = Component.translatable((String)info);
                            guiGraphics.drawString(font, (Component)component, -font.width((FormattedText)component) / 2, -5, color, false);
                            MutableComponent ownerInfo = Component.literal((String)("[" + entity2.getDisplayName().getString() + "]"));
                            guiGraphics.drawString(font, (Component)ownerInfo, -font.width((FormattedText)ownerInfo) / 2, 5, color, false);
                        }
                        poseStack.popPose();
                    }
                }
            }
        }
    }
}

