/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay.weapon;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.AnnihilatorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArtilleryHud {
    public static final String ID = "@Artillery";
    private static final ResourceLocation COMPASS = Mod.loc("textures/overlay/vehicle/base/compass.png");
    private static final ResourceLocation ROLL_IND_WHITE = Mod.loc("textures/overlay/vehicle/cannon/roll_ind_white.png");
    private static final ResourceLocation CANNON_PITCH = Mod.loc("textures/overlay/vehicle/cannon/cannon_pitch.png");
    private static final ResourceLocation CANNON_PITCH_IND = Mod.loc("textures/overlay/vehicle/cannon/cannon_pitch_ind.png");

    public static void render(VehicleEntity vehicle, Player player, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.getInstance();
        if (vehicle.getSeatIndex((Entity)player) != vehicle.computed().turretControllerIndex) {
            return;
        }
        int index = vehicle.getSeatIndex((Entity)player);
        GunData data = vehicle.getGunData(index);
        if (data == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        Vec3 viewVec = new Vec3(camera.getLookVector());
        poseStack.pushPose();
        double yaw = -VehicleVecUtils.getYRotFromVector(vehicle.getBarrelVector(partialTick));
        double pitch = -VehicleVecUtils.getXRotFromVector(vehicle.getBarrelVector(partialTick));
        RenderHelper.preciseBlit(guiGraphics, COMPASS, (float)screenWidth / 2.0f - 128.0f, 10.0f, 128.0f + 1.4222223f * (float)yaw, 0.0f, 256.0f, 16.0f, 512.0f, 16.0f);
        RenderHelper.preciseBlit(guiGraphics, ROLL_IND_WHITE, (float)screenWidth / 2.0f - 4.0f, 27.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
        int width = Minecraft.getInstance().font.width(FormatTool.DECIMAL_FORMAT_1ZZ.format(yaw));
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.DECIMAL_FORMAT_1ZZ.format(yaw)), screenWidth / 2 - width / 2, 40, -1, false);
        RenderHelper.preciseBlit(guiGraphics, CANNON_PITCH, (float)screenWidth / 2.0f + 166.0f, (float)screenHeight / 2.0f - 64.0f, 0.0f, 0.0f, 8.0f, 128.0f, 8.0f, 128.0f);
        int widthP = Minecraft.getInstance().font.width(FormatTool.DECIMAL_FORMAT_1ZZ.format(pitch));
        poseStack.pushPose();
        guiGraphics.pose().translate(0.0, pitch * 0.7, 0.0);
        RenderHelper.preciseBlit(guiGraphics, CANNON_PITCH_IND, (float)screenWidth / 2.0f + 158.0f, (float)screenHeight / 2.0f - 4.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.DECIMAL_FORMAT_1ZZ.format(pitch)), screenWidth / 2 + 157 - widthP, screenHeight / 2 - 4, -1, false);
        poseStack.popPose();
        Vec3 shootPos = player.getEyePosition(partialTick);
        if (!(vehicle instanceof AnnihilatorEntity)) {
            shootPos = vehicle.getZoomPos((Entity)player, partialTick);
        }
        Entity lookingEntity = TraceTool.camerafFindLookingEntity(player, cameraPos, viewVec, 512.0);
        boolean lookAtEntity = false;
        BlockHitResult result = player.level().clip(new ClipContext(shootPos, shootPos.add(player.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 hitPos = result.getLocation();
        double blockRange = player.getEyePosition(1.0f).distanceTo(hitPos);
        double entityRange = 0.0;
        if (lookingEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)lookingEntity;
            lookAtEntity = true;
            entityRange = player.distanceTo((Entity)living);
        }
        if (lookAtEntity) {
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)(FormatTool.format1D(entityRange, "m ") + lookingEntity.getDisplayName().getString()))), screenWidth / 2 + 14, screenHeight / 2 - 20, -1, false);
        } else if (blockRange > 511.0) {
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)"---m")), screenWidth / 2 + 14, screenHeight / 2 - 20, -1, false);
        } else {
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)FormatTool.format1D(blockRange, "m"))), screenWidth / 2 + 14, screenHeight / 2 - 20, -1, false);
        }
        poseStack.popPose();
    }
}

