/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay.weapon;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleMainWeaponHudOverlay;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class LandVehicleHud {
    public static final String ID = "@Land";
    private static final ResourceLocation COMPASS = Mod.loc("textures/overlay/vehicle/base/compass.png");
    private static final ResourceLocation ROLL_IND = Mod.loc("textures/overlay/vehicle/helicopter/roll_ind.png");
    private static final ResourceLocation FRAME = Mod.loc("textures/overlay/vehicle/land/tv_frame.png");
    private static final ResourceLocation LINE = Mod.loc("textures/overlay/vehicle/land/line.png");
    private static final ResourceLocation BARREL = Mod.loc("textures/overlay/vehicle/land/line.png");
    private static final ResourceLocation BODY = Mod.loc("textures/overlay/vehicle/land/body.png");
    private static final ResourceLocation LEFT_WHEEL = Mod.loc("textures/overlay/vehicle/land/left_wheel.png");
    private static final ResourceLocation RIGHT_WHEEL = Mod.loc("textures/overlay/vehicle/land/right_wheel.png");
    private static final ResourceLocation ENGINE = Mod.loc("textures/overlay/vehicle/land/engine.png");
    public static float lerpRecoil;

    public static void render(VehicleEntity vehicle, LocalPlayer player, GuiGraphics gui, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.getInstance();
        if (vehicle.getSeatIndex((Entity)player) != vehicle.computed().turretControllerIndex) {
            return;
        }
        PoseStack poseStack = gui.pose();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        Vec3 viewVec = new Vec3(camera.getLookVector());
        int color = vehicle.getHudColor();
        poseStack.pushPose();
        float recoil = Mth.lerp((float)partialTick, (float)((float)vehicle.recoilShakeO), (float)((float)vehicle.getRecoilShake()));
        lerpRecoil = Mth.lerp((float)(0.1f * partialTick), (float)lerpRecoil, (float)(recoil * (float)(2.0 * (Math.random() - 0.5))));
        poseStack.translate(lerpRecoil * 6.0f + (float)screenWidth * 0.025f * recoil, recoil * 3.0f + (float)screenHeight * 0.025f * recoil, 0.0f);
        poseStack.scale(1.0f - recoil * 0.05f, 1.0f - recoil * 0.05f, 1.0f);
        poseStack.rotateAround(Axis.ZP.rotationDegrees(-0.3f * ClientEventHandler.cameraRoll + 2.5f * lerpRecoil), (float)screenWidth / 2.0f, (float)screenHeight / 2.0f, 0.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle) {
            int addW = screenWidth / screenHeight * 48;
            int addH = screenWidth / screenHeight * 27;
            RenderHelper.preciseBlit(gui, FRAME, (float)(-addW) / 2.0f, (float)(-addH) / 2.0f, 10.0f, 0.0f, 0.0f, screenWidth + addW, screenHeight + addH, screenWidth + addW, screenHeight + addH);
            RenderHelper.preciseBlitWithColor(gui, LINE, (float)screenWidth / 2.0f - 64.0f, screenHeight - 56, 0.0f, 0.0f, 128.0f, 1.0f, 128.0f, 1.0f, color);
            RenderHelper.preciseBlitWithColor(gui, COMPASS, (float)screenWidth / 2.0f - 128.0f, 10.0f, 128.0f + 1.4222223f * player.getYRot(), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f, color);
            RenderHelper.preciseBlitWithColor(gui, ROLL_IND, (float)screenWidth / 2.0f - 8.0f, 30.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, color);
            int turretHeal = (int)(100.0f - 100.0f * ((Float)vehicle.getEntityData().get(VehicleEntity.TURRET_HEALTH)).floatValue() / vehicle.getTurretMaxHealth());
            RenderHelper.preciseBlitWithColor(gui, BARREL, (float)screenWidth / 2.0f + 112.0f, screenHeight - 71, 0.0f, 0.0f, 1.0f, 16.0f, 1.0f, 16.0f, MathTool.getGradientColor(color, 0xFF0000, turretHeal, 2));
            poseStack.pushPose();
            poseStack.rotateAround(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTick, (float)vehicle.turretYRotO, (float)vehicle.getTurretYRot())), (float)screenWidth / 2.0f + 112.0f, (float)(screenHeight - 56), 0.0f);
            int bodyHeal = (int)(100.0f - 100.0f * vehicle.getHealth() / vehicle.getMaxHealth());
            RenderHelper.preciseBlitWithColor(gui, BODY, (float)screenWidth / 2.0f + 96.0f, screenHeight - 72, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, MathTool.getGradientColor(color, 0xFF0000, bodyHeal, 2));
            int leftWheelHeal = (int)(100.0f - 100.0f * ((Float)vehicle.getEntityData().get(VehicleEntity.L_WHEEL_HEALTH)).floatValue() / vehicle.getWheelMaxHealth());
            RenderHelper.preciseBlitWithColor(gui, LEFT_WHEEL, (float)screenWidth / 2.0f + 96.0f, screenHeight - 72, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, MathTool.getGradientColor(color, 0xFF0000, leftWheelHeal, 2));
            int rightWheelHeal = (int)(100.0f - 100.0f * ((Float)vehicle.getEntityData().get(VehicleEntity.R_WHEEL_HEALTH)).floatValue() / vehicle.getWheelMaxHealth());
            RenderHelper.preciseBlitWithColor(gui, RIGHT_WHEEL, (float)screenWidth / 2.0f + 96.0f, screenHeight - 72, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, MathTool.getGradientColor(color, 0xFF0000, rightWheelHeal, 2));
            int engineHeal = (int)(100.0f - 100.0f * ((Float)vehicle.getEntityData().get(VehicleEntity.MAIN_ENGINE_HEALTH)).floatValue() / vehicle.getEngineMaxHealth());
            RenderHelper.preciseBlitWithColor(gui, ENGINE, (float)screenWidth / 2.0f + 96.0f, screenHeight - 72, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f, MathTool.getGradientColor(color, 0xFF0000, engineHeal, 2));
            poseStack.popPose();
            gui.drawString(mc.font, (Component)Component.literal((String)FormatTool.format0D(vehicle.getDeltaMovement().dot(vehicle.getViewVector(partialTick)) * 72.0, " km/h")), screenWidth / 2 + 160, screenHeight / 2 - 48, color, false);
            VehicleMainWeaponHudOverlay.renderEnergyInfo(vehicle, gui, screenWidth, screenHeight, mc.font);
            boolean lookAtEntity = false;
            BlockHitResult result = player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(player.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            Vec3 hitPos = result.getLocation();
            double blockRange = player.getEyePosition(1.0f).distanceTo(hitPos);
            double entityRange = 0.0;
            Entity lookingEntity = TraceTool.camerafFindLookingEntity((Player)player, cameraPos, viewVec, 512.0);
            if (lookingEntity != null) {
                lookAtEntity = true;
                entityRange = player.distanceTo(lookingEntity);
            }
            if (lookAtEntity) {
                width = Minecraft.getInstance().font.width(FormatTool.format0D(entityRange, " m"));
                gui.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(entityRange, " m")), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
            } else if (blockRange > 500.0) {
                width = Minecraft.getInstance().font.width("---m");
                gui.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"---m"), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
            } else {
                width = Minecraft.getInstance().font.width(FormatTool.format0D(blockRange, " m"));
                gui.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(blockRange, " m")), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
            }
            int heal = (int)(100.0f - 100.0f * vehicle.getHealth() / vehicle.getMaxHealth());
            gui.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(100 - heal)), screenWidth / 2 - 165, screenHeight / 2 - 46, MathTool.getGradientColor(color, 0xFF0000, bodyHeal, 2), false);
            if (vehicle.hasDecoy() && player == vehicle.getFirstPassenger()) {
                if (vehicle.getDecoyState().equals("READY")) {
                    gui.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.smoke.ready").append((Component)Component.literal((String)(" [" + ModKeyMappings.RELEASE_DECOY.getKey().getDisplayName().getString() + "]"))), screenWidth / 2 - 165, screenHeight / 2 - 36, color, false);
                } else {
                    gui.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.smoke.reloading"), screenWidth / 2 - 165, screenHeight / 2 - 36, 0xFF0000, false);
                }
            }
            VehicleMainWeaponHudOverlay.renderWeaponInfoFirst(gui, vehicle, (Player)player, vehicle.getGunData((Entity)player), mc.font, screenWidth, screenHeight, color);
        }
        poseStack.popPose();
    }
}

