/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.particle;

import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public class CustomCloudOption
implements ParticleOptions {
    public static final MapCodec<CustomCloudOption> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("color").forGetter(option -> option.color), (App)Codec.INT.fieldOf("life").forGetter(option -> option.life), (App)Codec.FLOAT.fieldOf("size").forGetter(option -> Float.valueOf(option.size)), (App)Codec.FLOAT.fieldOf("gravity").forGetter(option -> Float.valueOf(option.gravity)), (App)Codec.BOOL.fieldOf("cooldown").forGetter(option -> option.cooldown), (App)Codec.BOOL.fieldOf("light").forGetter(option -> option.light)).apply((Applicative)builder, CustomCloudOption::new));
    public static final StreamCodec<ByteBuf, CustomCloudOption> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CustomCloudOption::getColor, (StreamCodec)ByteBufCodecs.INT, CustomCloudOption::getLife, (StreamCodec)ByteBufCodecs.FLOAT, CustomCloudOption::getSize, (StreamCodec)ByteBufCodecs.FLOAT, CustomCloudOption::getGravity, (StreamCodec)ByteBufCodecs.BOOL, CustomCloudOption::getCooldown, (StreamCodec)ByteBufCodecs.BOOL, CustomCloudOption::getLight, CustomCloudOption::new);
    private final int color;
    private final int life;
    private final float size;
    private final float gravity;
    private final boolean cooldown;
    private final boolean light;

    public CustomCloudOption(float r, float g, float b, int life, float size, float gravity, boolean cooldown, boolean light) {
        this(Math.round(r * 255.0f) << 16 | Math.round(g * 255.0f) << 8 | Math.round(b * 255.0f), life, size, gravity, cooldown, light);
    }

    public CustomCloudOption(int color, int life, float size, float gravity, boolean cooldown, boolean light) {
        this.color = color;
        this.life = life;
        this.size = size;
        this.gravity = gravity;
        this.cooldown = cooldown;
        this.light = light;
    }

    public int getColor() {
        return this.color;
    }

    public float getRed() {
        return (float)(this.color >> 16 & 0xFF) / 255.0f;
    }

    public float getGreen() {
        return (float)(this.color >> 8 & 0xFF) / 255.0f;
    }

    public float getBlue() {
        return (float)(this.color & 0xFF) / 255.0f;
    }

    public int getLife() {
        return this.life;
    }

    public float getSize() {
        return this.size;
    }

    public float getGravity() {
        return this.gravity;
    }

    public boolean getCooldown() {
        return this.cooldown;
    }

    public boolean getLight() {
        return this.light;
    }

    @NotNull
    public ParticleType<?> getType() {
        return (ParticleType)ModParticleTypes.CUSTOM_CLOUD.get();
    }
}

