/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.block;

import com.atsuishio.superbwarfare.block.CreativeChargingStationBlock;
import com.atsuishio.superbwarfare.block.entity.CreativeChargingStationBlockEntity;
import com.atsuishio.superbwarfare.client.renderer.ModRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class CreativeChargingStationBlockEntityRenderer
implements BlockEntityRenderer<CreativeChargingStationBlockEntity> {
    public void render(CreativeChargingStationBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (!blockEntity.getBlockState().hasProperty((Property)CreativeChargingStationBlock.SHOW_RANGE) || !((Boolean)blockEntity.getBlockState().getValue((Property)CreativeChargingStationBlock.SHOW_RANGE)).booleanValue()) {
            return;
        }
        poseStack.pushPose();
        BlockPos pos = blockEntity.getBlockPos();
        poseStack.translate((float)(-pos.getX()), (float)(-pos.getY()), (float)(-pos.getZ()));
        AABB aabb = new AABB(pos).inflate(8.0);
        float startX = (float)aabb.minX - 0.001f;
        float startY = (float)aabb.minY - 0.001f;
        float startZ = (float)aabb.minZ - 0.001f;
        float endX = (float)aabb.maxX + 0.001f;
        float endY = (float)aabb.maxY + 0.001f;
        float endZ = (float)aabb.maxZ + 0.001f;
        float red = 0.0f;
        float green = 1.0f;
        float blue = 0.0f;
        float alpha = 0.2f;
        VertexConsumer builder = bufferSource.getBuffer(ModRenderTypes.BLOCK_OVERLAY);
        Matrix4f m4f = poseStack.last().pose();
        builder.addVertex(m4f, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, endY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, startZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, endX, startY, endZ).setColor(red, green, blue, alpha);
        builder.addVertex(m4f, startX, startY, endZ).setColor(red, green, blue, alpha);
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(@NotNull CreativeChargingStationBlockEntity blockEntity) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean shouldRender(CreativeChargingStationBlockEntity blockEntity, Vec3 pCameraPos) {
        return true;
    }
}

