/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.gun;

import com.atsuishio.superbwarfare.client.ItemModelHelper;
import com.atsuishio.superbwarfare.client.animation.AnimationHelper;
import com.atsuishio.superbwarfare.client.model.item.Ql1031ItemModel;
import com.atsuishio.superbwarfare.client.renderer.CustomGunRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.item.gun.sniper.Ql1031Item;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.object.GeoBone;

public class Ql1031ItemRenderer
extends CustomGunRenderer<Ql1031Item> {
    public static float progress;

    public Ql1031ItemRenderer() {
        super(new Ql1031ItemModel());
    }

    public void renderRecursively(PoseStack stack, Ql1031Item animatable, GeoBone bone, RenderType type, MultiBufferSource buffer, VertexConsumer bufferIn, boolean isReRender, float partialTick, int packedLightIn, int packedOverlayIn, int color) {
        Minecraft mc = Minecraft.getInstance();
        String name = bone.getName();
        boolean renderingArms = false;
        if (name.equals("Lefthand") || name.equals("Righthand")) {
            bone.setHidden(true);
            renderingArms = true;
        } else {
            bone.setHidden(false);
        }
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.getMainHandItem();
        if (itemStack.getItem() instanceof GunItem && GeoItem.getId((ItemStack)itemStack) == this.getInstanceId(animatable)) {
            GunData data = GunData.from(itemStack);
            CompoundTag tag = data.tag;
            if (this.renderPerspective == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || this.renderPerspective == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                int energy;
                if (name.equals("Sight")) {
                    bone.setHidden(data.attachment.get(AttachmentType.SCOPE) == 3);
                }
                AnimationHelper.handleShootFlare(name, stack, itemStack, bone, buffer, packedLightIn);
                ItemModelHelper.handleGunAttachments(bone, itemStack, name);
                IEnergyStorage cap = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
                int n = energy = cap != null ? cap.getEnergyStored() : 0;
                if (name.equals("energy2_illuminated") || name.equals("energy3_illuminated") || name.equals("energy4_illuminated")) {
                    bone.setScaleX((float)energy / (float)data.compute().maxEnergy);
                    bone.setHidden(ClientEventHandler.zoomPos < 0.7);
                }
                if (name.equals("energy_illuminated")) {
                    bone.setScaleX((float)energy / (float)data.compute().maxEnergy);
                }
                if (name.equals("kuang_illuminated") || name.equals("kuang2_illuminated") || name.equals("kuang3_illuminated")) {
                    bone.setHidden(ClientEventHandler.zoomPos < 0.7);
                }
                if (this.renderPerspective == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                    if (data.attachment.get(AttachmentType.SCOPE) == 2 && !tag.getBoolean("ScopeAlt") && (name.equals("hidden") || name.equals("qianzhunxingzu"))) {
                        bone.setHidden(ClientEventHandler.zoomPos > 0.7 && ClientEventHandler.zoom);
                    }
                    if (data.attachment.get(AttachmentType.SCOPE) == 3 && (bone.getName().endsWith("_hide3") || name.equals("qianzhunxingzu") || name.equals("Barrel"))) {
                        bone.setHidden(ClientEventHandler.zoomPos > 0.7 && ClientEventHandler.zoom);
                    }
                    int scopeType = GunData.from((ItemStack)itemStack).attachment.get(AttachmentType.SCOPE);
                    progress = Mth.lerp((float)partialTick, (float)progress, (float)ClientEventHandler.holdingFireKeyTicks);
                    switch (scopeType) {
                        case 0: {
                            AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, 0.0, 0.264, 0.85, 0.06f, 255, 0, 0, 255, "dot", false);
                            AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, 0.0, 0.264, 0.85, 0.05f, 255, 255, 255, 255, "ql_front", false);
                            stack.pushPose();
                            float spread = (float)(ClientEventHandler.gunSpread + 1.0 * ClientEventHandler.firePos);
                            int gb = 255 - (int)(data.heat.get() * 2.55);
                            stack.rotateAround(Axis.ZP.rotationDegrees(45.0f), 0.0f, 0.264f, 0.0f);
                            AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, 0.0, 0.264, -0.2, 0.025f + 0.003f * spread, 255, gb, gb, 255, "ql_back", false);
                            stack.popPose();
                            this.renderHoldProgress(stack, name, bone, buffer, 0.0, 0.264f, -0.2, 0.04f);
                            break;
                        }
                        case 1: {
                            AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, 0.0, 0.32, 30.0, 1.2f, 255, 0, 0, 255, "dot", false);
                            this.renderHoldProgress(stack, name, bone, buffer, 0.0, 0.307f, -0.12, 0.051f);
                            break;
                        }
                        case 2: {
                            if (tag.getBoolean("ScopeAlt")) {
                                AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, 0.0, 0.34, 30.0, 0.25f, 255, 0, 0, 255, "delta", false);
                                this.renderHoldProgress(stack, name, bone, buffer, 0.0, 0.353f, -0.12, 0.015f);
                                break;
                            }
                            AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, 0.0, 0.278, 13.0, 0.87f, 255, 0, 0, 255, "hamr", true);
                            this.renderHoldProgress(stack, name, bone, buffer, 0.0, 0.281f, -0.12, 0.048f);
                            break;
                        }
                        case 3: {
                            AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, 0.0, 0.283, 27.0, 2.0f, 255, 0, 0, 255, "sniper", true);
                            this.renderHoldProgress(stack, name, bone, buffer, 0.0, 0.29, 27.0, 1.6f);
                        }
                    }
                }
            } else {
                ItemModelHelper.hideAllAttachments(bone, name);
            }
        } else {
            ItemModelHelper.hideAllAttachments(bone, name);
        }
        if (renderingArms) {
            AnimationHelper.renderArms(player, this.renderPerspective, stack, name, bone, buffer, type, packedLightIn, false);
        }
        super.renderRecursively(stack, (Item)animatable, bone, type, buffer, bufferIn, isReRender, partialTick, packedLightIn, packedOverlayIn, color);
    }

    public void renderHoldProgress(PoseStack stack, String name, GeoBone bone, MultiBufferSource buffer, double x, double y, double z, float size) {
        int c = 255 - (int)((double)progress * 12.75);
        int i = 0;
        while ((float)i < 4.5f * progress) {
            stack.pushPose();
            stack.rotateAround(Axis.ZP.rotationDegrees((float)(-i)), 0.0f, (float)y, 0.0f);
            AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, x, y, z, size, 255, c, c, 255, "ql_hold_progress", false);
            stack.popPose();
            i += 3;
        }
        i = 3;
        while ((float)i < 4.5f * progress) {
            stack.pushPose();
            stack.rotateAround(Axis.ZP.rotationDegrees((float)i), 0.0f, (float)y, 0.0f);
            AnimationHelper.handleZoomCrossHair(this.currentBuffer, this.renderType, name, stack, bone, buffer, x, y, z, size, 255, c, c, 255, "ql_hold_progress", false);
            stack.popPose();
            i += 3;
        }
    }
}

