/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.block.ContainerBlock;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.animation.AnimationCurves;
import com.atsuishio.superbwarfare.client.animation.ValueAnimator;
import com.atsuishio.superbwarfare.client.screens.component.AssembleButton;
import com.atsuishio.superbwarfare.client.screens.component.CategoryButton;
import com.atsuishio.superbwarfare.client.screens.component.PageButton;
import com.atsuishio.superbwarfare.client.screens.component.RecipeButton;
import com.atsuishio.superbwarfare.client.screens.component.ScaleButton;
import com.atsuishio.superbwarfare.compat.jei.JeiCompatHolder;
import com.atsuishio.superbwarfare.compat.jei.SbwJEIPlugin;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.menu.VehicleAssemblingMenu;
import com.atsuishio.superbwarfare.network.message.send.AssembleVehicleMessage;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingIngredient;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingRecipe;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class VehicleAssemblingScreen
extends AbstractContainerScreen<VehicleAssemblingMenu> {
    public static final ResourceLocation TEXTURE = Mod.loc("textures/gui/vehicle_assembling_table.png");
    public static final int IMAGE_SIZE = 356;
    public static final int PAGE_SIZE = 9;
    public static final float DEFAULT_MODEL_SCALE = 50.0f;
    public static final float MIN_MODEL_SCALE = 10.0f;
    public static final float MAX_MODEL_SCALE = 200.0f;
    public static final int DEFAULT_MODEL_X = 234;
    public static final int DEFAULT_MODEL_Y = 80;
    private final Map<VehicleAssemblingRecipe.Category, List<ResourceLocation>> recipes = Maps.newLinkedHashMap();
    private VehicleAssemblingRecipe.Category currentCategory = VehicleAssemblingRecipe.Category.LAND;
    @Nullable
    private List<ResourceLocation> currentRecipes = new ArrayList<ResourceLocation>();
    @Nullable
    private RecipeHolder<VehicleAssemblingRecipe> currentRecipe = null;
    @Nullable
    private Int2IntArrayMap materialCount;
    private int pageIndex = 0;
    private String entityNameCache = "";
    private Entity entityCache = null;
    private final ValueAnimator<Float> scaleAnimator = (ValueAnimator)new ValueAnimator<Float>(300L, Float.valueOf(50.0f)).animation(AnimationCurves.EASE_OUT_EXPO);
    private final ValueAnimator<Vec2> modelPosAnimator = (ValueAnimator)new ValueAnimator<Vec2>(300L, new Vec2(234.0f, 80.0f)).animation(AnimationCurves.EASE_OUT_EXPO);

    public VehicleAssemblingScreen(VehicleAssemblingMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 356;
        this.imageHeight = 181;
        this.initRecipes();
        this.pageIndex = 0;
        this.currentRecipe = this.getRecipeById(this.currentRecipes == null || this.currentRecipes.isEmpty() ? null : this.currentRecipes.getFirst());
        this.calculateMaterialCount(this.currentRecipe);
    }

    protected void init() {
        super.init();
        this.initRecipes();
        this.clearWidgets();
        int posX = (this.width - this.imageWidth) / 2;
        int posY = (this.height - this.imageHeight) / 2;
        this.addCategoryButtons(posX, posY);
        this.addRecipeButtons(posX, posY);
        this.addPageButtons(posX, posY);
        this.addAssembleButton(posX, posY);
        this.addScaleButtons(posX, posY);
    }

    public void initRecipes() {
        this.recipes.clear();
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List recipeList = recipeManager.getAllRecipesFor((RecipeType)ModRecipes.VEHICLE_ASSEMBLING_TYPE.get());
        for (RecipeHolder recipe : recipeList) {
            this.recipes.computeIfAbsent(((VehicleAssemblingRecipe)recipe.value()).getCategory(), k -> Lists.newArrayList()).add(recipe.id());
        }
        this.currentRecipes = this.recipes.get((Object)this.currentCategory);
    }

    public void addCategoryButtons(int posX, int posY) {
        int i = 0;
        for (VehicleAssemblingRecipe.Category category : VehicleAssemblingRecipe.Category.values()) {
            CategoryButton button = new CategoryButton(posX, posY + 21 + i * 23, category, b -> {
                this.currentCategory = category;
                this.currentRecipes = this.recipes.get((Object)category);
                this.currentRecipe = this.getRecipeById(this.currentRecipes == null || this.currentRecipes.isEmpty() ? null : this.currentRecipes.getFirst());
                this.pageIndex = 0;
                this.calculateMaterialCount(this.currentRecipe);
                this.init();
            });
            if (this.currentCategory.equals((Object)category)) {
                button.setSelected(true);
            }
            this.addRenderableWidget((GuiEventListener)button);
            ++i;
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.currentRecipe != null) {
            this.renderModel(this.currentRecipe, guiGraphics);
            this.renderRecipeInfo(this.currentRecipe, guiGraphics, mouseX, mouseY);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"container.superbwarfare.vehicle_assembling_table.count", (Object[])new Object[]{((VehicleAssemblingRecipe)this.currentRecipe.value()).getResult().getResult().getCount()}), this.leftPos + 214, this.topPos + 164, 0x555555, false);
        }
        if (this.currentRecipes != null && !this.currentRecipes.isEmpty()) {
            this.renderIngredients(guiGraphics, mouseX, mouseY);
        }
        this.renderables.stream().filter(w -> w instanceof RecipeButton || w instanceof CategoryButton).forEach(w -> {
            if (w instanceof RecipeButton) {
                RecipeButton recipeButton = (RecipeButton)((Object)w);
                recipeButton.renderTooltips(guiGraphics, mouseX, mouseY);
            }
            if (w instanceof CategoryButton) {
                CategoryButton categoryButton = (CategoryButton)((Object)w);
                categoryButton.renderTooltips(guiGraphics, mouseX, mouseY);
            }
        });
    }

    protected void renderBg(@NotNull GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(TEXTURE, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 356, 356);
    }

    protected void renderLabels(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    @Nullable
    private RecipeHolder<VehicleAssemblingRecipe> getRecipeById(ResourceLocation recipeId) {
        if (recipeId == null) {
            return null;
        }
        if (Minecraft.getInstance().level != null) {
            RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
            RecipeHolder recipe = recipeManager.byKey(recipeId).orElse(null);
            if (recipe == null) {
                return null;
            }
            if (recipe.value() instanceof VehicleAssemblingRecipe) {
                return recipe;
            }
        }
        return null;
    }

    public void calculateMaterialCount(@Nullable RecipeHolder<VehicleAssemblingRecipe> holder) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || holder == null) {
            return;
        }
        VehicleAssemblingRecipe recipe = (VehicleAssemblingRecipe)holder.value();
        List<VehicleAssemblingIngredient> ingredients = recipe.getInputs();
        int size = ingredients.size();
        this.materialCount = new Int2IntArrayMap(size);
        for (int i = 0; i < size; ++i) {
            VehicleAssemblingIngredient ingredient = ingredients.get(i);
            int count = 0;
            for (ItemStack stack : player.getInventory().items) {
                if (stack.isEmpty() || !ingredient.getIngredient().test(stack)) continue;
                count += stack.getCount();
            }
            this.materialCount.put(i, count);
        }
    }

    public void addRecipeButtons(int posX, int posY) {
        if (this.currentRecipes != null && !this.currentRecipes.isEmpty()) {
            ResourceLocation id;
            RecipeHolder<VehicleAssemblingRecipe> recipe;
            int index;
            for (int i = 0; i < 9 && (index = i + this.pageIndex * 9) < this.currentRecipes.size() && (recipe = this.getRecipeById(id = this.currentRecipes.get(index))) != null; ++i) {
                RecipeButton button = (RecipeButton)this.addRenderableWidget((GuiEventListener)new RecipeButton(posX + 26, posY + 21 + i * 17, ((VehicleAssemblingRecipe)recipe.value()).getResult().getResult(), b -> {
                    this.currentRecipe = recipe;
                    this.calculateMaterialCount(recipe);
                    this.init();
                }));
                if (!recipe.equals(this.currentRecipe)) continue;
                button.setSelected(true);
            }
        }
    }

    private void renderIngredients(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.currentRecipe == null) {
            return;
        }
        List<VehicleAssemblingIngredient> inputs = ((VehicleAssemblingRecipe)this.currentRecipe.value()).getInputs();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                int index = i * 4 + j;
                if (index >= inputs.size()) {
                    return;
                }
                int posX = x + 215 + j * 34;
                int posY = y + 118 + i * 14;
                VehicleAssemblingIngredient input = inputs.get(index);
                Ingredient ingredient = input.getIngredient();
                ItemStack[] items = ingredient.getItems();
                if (items.length == 0) continue;
                int itemIndex = (int)(System.currentTimeMillis() / 1000L) % items.length;
                ItemStack itemStack = items[itemIndex];
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                pose.scale(0.8f, 0.8f, 1.0f);
                guiGraphics.renderFakeItem(itemStack, (int)((float)posX * 1.25f), (int)((float)posY * 1.25f));
                pose.popPose();
                if (mouseX >= posX && mouseY >= posY && (float)mouseX < (float)posX + 12.8f && (float)mouseY < (float)posY + 12.8f) {
                    guiGraphics.renderTooltip(this.font, itemStack, mouseX, mouseY);
                }
                pose.pushPose();
                pose.scale(0.5f, 0.5f, 1.0f);
                pose.translate(0.0f, 0.0f, 200.0f);
                int count = input.getCount();
                if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.isCreative()) {
                    MutableComponent text = Component.literal((String)(count + "/\u221e"));
                    guiGraphics.drawString(this.font, (Component)text, (posX + 14) * 2, (posY + 8) * 2, 2896193, false);
                } else {
                    int hasCount = 0;
                    if (this.materialCount != null && index < this.materialCount.size()) {
                        hasCount = this.materialCount.get(index);
                    }
                    int color = hasCount >= count ? 2896193 : 16010593;
                    MutableComponent text = Component.literal((String)(count + "/" + hasCount));
                    guiGraphics.drawString(this.font, (Component)text, (posX + 14) * 2, (posY + 8) * 2, color, false);
                }
                pose.popPose();
            }
        }
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pMouseX >= (double)(this.leftPos + 114) && pMouseX <= (double)(this.leftPos + 354) && pMouseY >= (double)this.topPos && pMouseY <= (double)(this.topPos + 99)) {
            Vec2 newVec = this.modelPosAnimator.newValue();
            double posX = Mth.clamp((double)((double)newVec.x + pDragX), (double)34.0, (double)434.0);
            double posY = Mth.clamp((double)((double)newVec.y + pDragY), (double)-70.0, (double)230.0);
            this.modelPosAnimator.update(new Vec2((float)posX, (float)posY));
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double scrollX, double scrollY) {
        if (pMouseX >= (double)(this.leftPos + 26) && pMouseX <= (double)(this.leftPos + 106) && pMouseY >= (double)(this.topPos + 21) && pMouseY <= (double)(this.topPos + 175)) {
            if (scrollY > 0.0) {
                this.pageIndex = Math.max(0, this.pageIndex - 1);
            } else if (this.currentRecipes != null && !this.currentRecipes.isEmpty()) {
                this.pageIndex = Math.min((this.currentRecipes.size() - 1) / 9, this.pageIndex + 1);
            }
            this.init();
            return true;
        }
        if (pMouseX >= (double)(this.leftPos + 114) && pMouseX <= (double)(this.leftPos + 354) && pMouseY >= (double)this.topPos && pMouseY <= (double)(this.topPos + 99)) {
            float targetScale = scrollY > 0.0 ? Math.min(this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis()) + 20.0f, 200.0f) : Math.max(this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis()) - 20.0f, 10.0f);
            this.scaleAnimator.update(Float.valueOf(targetScale));
            this.scaleAnimator.beginForward(System.currentTimeMillis());
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        Optional<IngredientArea> ingredientArea;
        List<IngredientArea> list = this.getIngredientAreas();
        if (!list.isEmpty() && pMouseX >= (double)(this.leftPos + 214) && pMouseY >= (double)(this.topPos + 117) && pMouseX <= (double)(this.leftPos + 350) && pMouseY <= (double)(this.topPos + 160) && JeiCompatHolder.hasJEI() && (ingredientArea = list.stream().filter(area -> area.contains(pMouseX, pMouseY)).findFirst()).isPresent()) {
            ItemStack[] items = ingredientArea.get().ingredient.getItems();
            int itemIndex = (int)(System.currentTimeMillis() / 1000L) % items.length;
            SbwJEIPlugin.showRecipes(items[itemIndex]);
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void addPageButtons(int posX, int posY) {
        PageButton left = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(posX + 95, posY - 1, true, b -> {
            this.pageIndex = Math.max(0, this.pageIndex - 1);
            this.init();
        }));
        PageButton right = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(posX + 103, posY - 1, false, b -> {
            if (this.currentRecipes != null && !this.currentRecipes.isEmpty()) {
                this.pageIndex = Math.min((this.currentRecipes.size() - 1) / 9, this.pageIndex + 1);
                this.init();
            }
        }));
        if (this.currentRecipes != null && !this.currentRecipes.isEmpty()) {
            left.active = this.pageIndex > 0;
            right.active = this.pageIndex < (this.currentRecipes.size() - 1) / 9;
        } else {
            left.active = false;
            right.active = false;
        }
    }

    public void addAssembleButton(int posX, int posY) {
        this.addRenderableWidget((GuiEventListener)new AssembleButton(posX + 295, posY + 163, b -> {
            if (this.currentRecipe == null || this.materialCount == null) {
                return;
            }
            List<VehicleAssemblingIngredient> inputs = ((VehicleAssemblingRecipe)this.currentRecipe.value()).getInputs();
            int size = inputs.size();
            for (int i = 0; i < size; ++i) {
                boolean isCreative;
                if (i >= this.materialCount.size()) {
                    return;
                }
                int hasCount = this.materialCount.get(i);
                int needCount = inputs.get(i).getCount();
                boolean bl = isCreative = Minecraft.getInstance().player != null && Minecraft.getInstance().player.isCreative();
                if (hasCount >= needCount || isCreative) continue;
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new AssembleVehicleMessage(this.currentRecipe.id(), ((VehicleAssemblingMenu)this.menu).containerId), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
    }

    public void finishAssembling() {
        if (this.currentRecipe != null) {
            this.calculateMaterialCount(this.currentRecipe);
        }
        this.init();
    }

    public void addScaleButtons(int posX, int posY) {
        this.addRenderableWidget((GuiEventListener)new ScaleButton(posX + 324, posY + 90, 149, 182, b -> {
            long time = System.currentTimeMillis();
            this.scaleAnimator.update(Float.valueOf(50.0f));
            this.scaleAnimator.beginForward(time);
            this.modelPosAnimator.update(new Vec2(234.0f, 80.0f));
            this.modelPosAnimator.beginForward(time);
        }));
        this.addRenderableWidget((GuiEventListener)new ScaleButton(posX + 334, posY + 90, 159, 182, b -> {
            this.scaleAnimator.update(Float.valueOf(Math.max(this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis()) - 20.0f, 10.0f)));
            this.scaleAnimator.beginForward(System.currentTimeMillis());
        }));
        this.addRenderableWidget((GuiEventListener)new ScaleButton(posX + 344, posY + 90, 169, 182, b -> {
            this.scaleAnimator.update(Float.valueOf(Math.min(this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis()) + 20.0f, 200.0f)));
            this.scaleAnimator.beginForward(System.currentTimeMillis());
        }));
    }

    public void renderModel(RecipeHolder<VehicleAssemblingRecipe> holder, GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        RenderHelper.markGuiRenderTimestamp();
        ItemStack stack = ((VehicleAssemblingRecipe)holder.value()).getResult().getResult();
        Entity renderEntity = null;
        if (stack.is((Item)ModItems.CONTAINER.get())) {
            CompoundTag tag;
            CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            CompoundTag compoundTag = tag = data != null ? data.copyTag() : null;
            if (tag != null && tag.contains("EntityType")) {
                String key = tag.getString("EntityType");
                if (this.entityNameCache.equals(key) && this.entityCache != null) {
                    renderEntity = this.entityCache;
                } else {
                    renderEntity = EntityType.byString((String)key).map(type -> type.create((Level)level)).orElse(null);
                    if (renderEntity != null) {
                        this.entityNameCache = key;
                        this.entityCache = renderEntity;
                        this.scaleAnimator.update(Float.valueOf(50.0f));
                        this.modelPosAnimator.update(new Vec2(234.0f, 80.0f));
                    }
                }
            }
        }
        if (renderEntity == null) {
            this.renderDefaultItemModel(stack);
        } else {
            this.renderEntityModel(guiGraphics, renderEntity);
        }
    }

    private void renderDefaultItemModel(ItemStack stack) {
        float rotationPeriod = 8.0f;
        int width = 240;
        int height = 99;
        float rotPitch = 15.0f;
        Window window = Minecraft.getInstance().getWindow();
        double windowGuiScale = window.getGuiScale();
        int scissorX = (int)((double)(this.leftPos + 114) * windowGuiScale);
        int scissorY = (int)((double)window.getHeight() - (double)(this.topPos + height) * windowGuiScale);
        int scissorW = (int)((double)width * windowGuiScale);
        int scissorH = (int)((double)height * windowGuiScale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.pushMatrix();
        Vec2 oldVec = this.modelPosAnimator.oldValue();
        Vec2 newVec = this.modelPosAnimator.newValue();
        float xOffset = this.modelPosAnimator.lerp(oldVec.x, newVec.x, System.currentTimeMillis());
        float yOffset = this.modelPosAnimator.lerp(oldVec.y, newVec.y, System.currentTimeMillis());
        posestack.translate((float)this.leftPos + xOffset, (float)this.topPos + yOffset - 20.0f, 200.0f);
        posestack.translate(8.0f, 8.0f, 0.0f);
        posestack.scale(1.0f, -1.0f, 1.0f);
        float currentScale = this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis());
        posestack.scale(currentScale, currentScale, currentScale);
        float rot = (float)(System.currentTimeMillis() % (long)((int)(rotationPeriod * 1000.0f))) * (360.0f / (rotationPeriod * 1000.0f));
        posestack.rotate((Quaternionfc)Axis.XP.rotationDegrees(rotPitch));
        posestack.rotate((Quaternionfc)Axis.YP.rotationDegrees(rot));
        RenderSystem.applyModelViewMatrix();
        PoseStack tmpPose = new PoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        Lighting.setupForFlatItems();
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, tmpPose, (MultiBufferSource)bufferSource, null, 0);
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
        Lighting.setupFor3DItems();
        posestack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableScissor();
    }

    private void renderEntityModel(GuiGraphics guiGraphics, Entity renderEntity) {
        if (renderEntity == null) {
            return;
        }
        PoseStack posestack = guiGraphics.pose();
        int width = 240;
        int height = 99;
        Window window = Minecraft.getInstance().getWindow();
        double windowGuiScale = window.getGuiScale();
        int scissorX = (int)((double)(this.leftPos + 114) * windowGuiScale);
        int scissorY = (int)((double)window.getHeight() - (double)(this.topPos + height) * windowGuiScale);
        int scissorW = (int)((double)width * windowGuiScale);
        int scissorH = (int)((double)height * windowGuiScale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
        posestack.pushPose();
        Vec2 oldVec = this.modelPosAnimator.oldValue();
        Vec2 newVec = this.modelPosAnimator.newValue();
        float xOffset = this.modelPosAnimator.lerp(oldVec.x, newVec.x, System.currentTimeMillis());
        float yOffset = this.modelPosAnimator.lerp(oldVec.y, newVec.y, System.currentTimeMillis());
        posestack.translate((float)this.leftPos + xOffset, (float)this.topPos + yOffset, 50.0f);
        float currentScale = this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis());
        posestack.scale(currentScale, currentScale, -currentScale);
        float size = (float)renderEntity.getBoundingBox().getSize();
        float resizeScale = 1.0f / Math.max(size, 1.25f);
        posestack.scale(resizeScale, resizeScale, resizeScale);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        float rotationPeriod = 12.0f;
        float rotPitch = 195.0f;
        float rot = (float)(System.currentTimeMillis() % (long)((int)(rotationPeriod * 1000.0f))) * (360.0f / (rotationPeriod * 1000.0f));
        posestack.mulPose(Axis.XP.rotationDegrees(rotPitch));
        posestack.mulPose(Axis.YP.rotationDegrees(rot));
        entityrenderdispatcher.setRenderShadow(false);
        entityrenderdispatcher.render(renderEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0);
        guiGraphics.flush();
        entityrenderdispatcher.setRenderShadow(true);
        posestack.popPose();
        Lighting.setupFor3DItems();
        RenderSystem.disableScissor();
    }

    public void renderRecipeInfo(RecipeHolder<VehicleAssemblingRecipe> holder, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack stack = ((VehicleAssemblingRecipe)holder.value()).getResult().getResult();
        boolean renderItemName = true;
        if (stack.is((Item)ModItems.CONTAINER.get())) {
            String key;
            EntityType entityType;
            CompoundTag tag;
            CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            CompoundTag compoundTag = tag = data != null ? data.copyTag() : null;
            if (tag != null && tag.contains("EntityType") && (entityType = (EntityType)EntityType.byString((String)(key = tag.getString("EntityType"))).orElse(null)) != null) {
                this.renderContainerInfo(key, guiGraphics, mouseX, mouseY);
                renderItemName = false;
            }
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.scale(0.75f, 0.75f, 1.0f);
        if (renderItemName) {
            RenderHelper.renderScrollingString(guiGraphics, this.font, (Component)Component.empty().append(stack.getHoverName()).withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.YELLOW), 0.75f, (int)((float)(this.leftPos + 122) / 0.75f), (int)((float)(this.topPos + 119) / 0.75f), (int)((float)(this.leftPos + 198) / 0.75f), (int)((float)(this.topPos + 130) / 0.75f), 0xFFFFFF);
        }
        MutableComponent modName = Component.translatableWithFallback((String)("info." + holder.id().getNamespace() + ".mod_id"), (String)holder.id().getNamespace());
        MutableComponent modInfo = Component.translatable((String)"container.superbwarfare.mod_info", (Object[])new Object[]{modName.withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.AQUA)});
        RenderHelper.renderScrollingString(guiGraphics, this.font, (Component)modInfo, 0.75f, (int)((float)(this.leftPos + 122) / 0.75f), (int)((float)(this.topPos + 167) / 0.75f), (int)((float)(this.leftPos + 198) / 0.75f), (int)((float)(this.topPos + 178) / 0.75f), 0xFFFFFF);
        pose.popPose();
    }

    private void renderContainerInfo(String typeName, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack pose = guiGraphics.pose();
        String key = ContainerBlock.getEntityTranslationKey(typeName);
        if (key == null) {
            return;
        }
        if (typeName.split(":").length < 2) {
            return;
        }
        MutableComponent info = Component.translatableWithFallback((String)("info." + typeName.split(":")[0] + "." + typeName.split(":")[1]), (String)Component.translatable((String)"info.superbwarfare.no_info").getString());
        List infoComponents = this.font.split(FormattedText.of((String)info.getString()), 100);
        pose.pushPose();
        pose.scale(0.75f, 0.75f, 1.0f);
        MutableComponent hoverName = Component.translatable((String)key).withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.YELLOW);
        RenderHelper.renderScrollingString(guiGraphics, this.font, (Component)hoverName, 0.75f, (int)((float)(this.leftPos + 122) / 0.75f), (int)((float)(this.topPos + 119) / 0.75f), (int)((float)(this.leftPos + 198) / 0.75f), (int)((float)(this.topPos + 130) / 0.75f), 0xFFFFFF);
        guiGraphics.enableScissor(this.leftPos + 120, this.topPos + 129, this.leftPos + 198, this.topPos + 165);
        for (int j = 0; j < infoComponents.size(); ++j) {
            FormattedCharSequence cachedComponent = j > 3 ? Component.literal((String)"...").getVisualOrderText() : (FormattedCharSequence)infoComponents.get(j);
            guiGraphics.drawString(this.font, cachedComponent, (int)((float)(this.leftPos + 122) / 0.75f), (int)(((float)(this.topPos + 129) + (float)j * 7.5f) / 0.75f), 2896193, false);
        }
        guiGraphics.disableScissor();
        pose.popPose();
        if (mouseX >= this.leftPos + 120 && mouseX <= this.leftPos + 200 && mouseY >= this.topPos + 117 && mouseY <= this.topPos + 175) {
            guiGraphics.renderTooltip(this.font, this.font.split(FormattedText.of((String)info.getString()), 200), mouseX, mouseY);
        }
    }

    @Nullable
    public VehicleAssemblingRecipe getCurrentRecipe() {
        if (this.currentRecipe == null) {
            return null;
        }
        return (VehicleAssemblingRecipe)this.currentRecipe.value();
    }

    public List<IngredientArea> getIngredientAreas() {
        ArrayList<IngredientArea> areas = new ArrayList<IngredientArea>();
        if (this.currentRecipe != null) {
            List<VehicleAssemblingIngredient> inputs = ((VehicleAssemblingRecipe)this.currentRecipe.value()).getInputs();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int index = i * 4 + j;
                    if (index >= inputs.size()) {
                        return areas;
                    }
                    VehicleAssemblingIngredient input = inputs.get(index);
                    Ingredient ingredient = input.getIngredient();
                    ItemStack[] items = ingredient.getItems();
                    if (items.length == 0) continue;
                    int x = this.leftPos + 215 + j * 34;
                    int y = this.topPos + 118 + i * 14;
                    areas.add(new IngredientArea(ingredient, x, y, 12.8, 12.8));
                }
            }
        }
        return areas;
    }

    public record IngredientArea(Ingredient ingredient, double x, double y, double width, double height) {
        public boolean contains(double mouseX, double mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }
    }
}

