/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens.component;

import com.atsuishio.superbwarfare.client.screens.VehicleAssemblingScreen;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingRecipe;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;

public class CategoryButton
extends Button {
    public VehicleAssemblingRecipe.Category category;
    private boolean isSelected = false;

    public CategoryButton(int x, int y, VehicleAssemblingRecipe.Category category, Button.OnPress onPress) {
        super(x, y, 20, 22, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.category = category;
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.pose().pushPose();
        RenderSystem.enableDepthTest();
        if (this.isSelected) {
            pGuiGraphics.blit(VehicleAssemblingScreen.TEXTURE, this.getX(), this.getY(), 179.0f, 182.0f, 23, this.height, 356, 356);
        } else {
            pGuiGraphics.blit(VehicleAssemblingScreen.TEXTURE, this.getX(), this.getY(), 179.0f, 205.0f, 20, this.height, 356, 356);
        }
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int vOffset = switch (this.category) {
            case VehicleAssemblingRecipe.Category.LAND -> 182;
            case VehicleAssemblingRecipe.Category.DEFENSE -> 198;
            case VehicleAssemblingRecipe.Category.AIRCRAFT -> 214;
            case VehicleAssemblingRecipe.Category.WATER -> 230;
            case VehicleAssemblingRecipe.Category.CIVILIAN -> 246;
            default -> 262;
        };
        pGuiGraphics.blit(VehicleAssemblingScreen.TEXTURE, this.getX() + 3, this.getY() + 3, this.isSelected ? 203.0f : 221.0f, (float)vOffset, 16, 16, 356, 356);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pGuiGraphics.pose().popPose();
    }

    public void onPress() {
        this.isSelected = true;
        this.onPress.onPress((Button)this);
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public void renderTooltips(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        if (this.isHovered()) {
            pGuiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)("tips.superbwarfare.category." + this.category.getName())), mouseX, mouseY);
        }
    }
}

