/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.sound;

import com.atsuishio.superbwarfare.client.sound.VehicleSoundInstance;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public abstract class VehicleFireSoundInstance
extends AbstractTickableSoundInstance {
    private final Minecraft client;
    private final Entity entity;
    private double lastDistance;
    private int fade = 0;
    private boolean die = false;

    public VehicleFireSoundInstance(SoundEvent sound, Minecraft client, Entity entity) {
        super(sound, SoundSource.AMBIENT, entity.getCommandSenderWorld().getRandom());
        this.client = client;
        this.entity = entity;
        this.looping = true;
        this.delay = 0;
    }

    protected abstract boolean canPlay(Entity var1);

    protected abstract float getPitch(Entity var1);

    protected abstract float getVolume(Entity var1);

    public void tick() {
        LocalPlayer player = this.client.player;
        if (this.entity.isRemoved() || player == null) {
            this.stop();
            return;
        }
        if (!this.canPlay(this.entity)) {
            this.die = true;
        }
        if (this.die) {
            if (this.fade > 0) {
                --this.fade;
            } else if (this.fade == 0) {
                this.stop();
                return;
            }
        } else if (this.fade < 3) {
            ++this.fade;
        }
        this.volume = this.getVolume(this.entity) * (float)this.fade;
        this.x = this.entity.getX();
        this.y = this.entity.getY();
        this.z = this.entity.getZ();
        this.pitch = this.getPitch(this.entity);
    }

    public static class VehicleFireSound
    extends VehicleSoundInstance {
        public VehicleFireSound(VehicleEntity vehicle) {
            super(vehicle.getShootSoundInstance(), Minecraft.getInstance(), vehicle);
        }

        @Override
        protected boolean canPlay(VehicleEntity vehicle) {
            return vehicle.isFiring();
        }

        @Override
        protected float getPitch(VehicleEntity vehicle) {
            return vehicle.shootingPitch();
        }

        @Override
        protected float getVolume(VehicleEntity vehicle) {
            return vehicle.shootingVolume();
        }
    }
}

