/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.ClientGunImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.tools.FormatTool;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class ClientBocekImageTooltip
extends ClientGunImageTooltip {
    public ClientBocekImageTooltip(GunImageComponent tooltip) {
        super(tooltip);
    }

    @Override
    protected Component getDamageComponent() {
        boolean slug = false;
        GunData data = GunData.from(this.stack);
        Perk perk = data.perk.get(Perk.Type.AMMO);
        if (perk instanceof AmmoPerk) {
            AmmoPerk ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug) {
                slug = true;
            }
        }
        DefaultGunData computed = data.compute();
        double damage = computed.damage;
        if (slug) {
            return super.getDamageComponent();
        }
        double shotDamage = damage * 0.1;
        double explosionDamage = computed.explosionDamage * 0.1;
        return Component.translatable((String)"des.superbwarfare.guns.damage").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)(explosionDamage > 0.0 ? "(" + FormatTool.format1D(shotDamage) + " + " + FormatTool.format1D(explosionDamage) + ") * 10" : FormatTool.format1D(shotDamage, " * 10"))).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" / ").withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)FormatTool.format1D(damage)).withStyle(ChatFormatting.GREEN));
    }
}

