/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.FireModeInfo;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.FormatTool;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ClientGunImageTooltip
implements ClientTooltipComponent {
    protected final int width;
    protected final int height;
    protected final ItemStack stack;
    protected final GunData data;

    public ClientGunImageTooltip(GunImageComponent tooltip) {
        this.width = tooltip.width;
        this.height = tooltip.height;
        this.stack = tooltip.stack;
        this.data = GunData.from(this.stack);
    }

    public void renderImage(@NotNull Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        this.renderDamageAndRpmTooltip(font, guiGraphics, x, y);
        this.renderLevelAndUpgradePointTooltip(font, guiGraphics, x, y + 10);
        int yo = 20;
        if (this.shouldRenderBypassAndHeadshotTooltip()) {
            this.renderBypassAndHeadshotTooltip(font, guiGraphics, x, y + yo);
            yo += 10;
        }
        if (this.shouldRenderEnergyTooltip()) {
            this.renderEnergyTooltip(font, guiGraphics, x, y + (yo += 10));
            yo += 10;
        }
        if (this.shouldRenderEditTooltip()) {
            this.renderWeaponEditTooltip(font, guiGraphics, x, y + yo);
            yo += 20;
        }
        if (this.shouldRenderPerks()) {
            if (!Screen.hasShiftDown()) {
                this.renderPerksShortcut(font, guiGraphics, x, y + yo);
            } else {
                this.renderPerks(font, guiGraphics, x, y + yo);
            }
        }
        guiGraphics.pose().popPose();
    }

    protected boolean shouldRenderBypassAndHeadshotTooltip() {
        return this.data.compute().bypassesArmor > 0.0 || this.data.compute().headshot > 0.0;
    }

    protected boolean shouldRenderPerks() {
        return this.data.perk.get(Perk.Type.AMMO) != null || this.data.perk.get(Perk.Type.DAMAGE) != null || this.data.perk.get(Perk.Type.FUNCTIONAL) != null;
    }

    protected boolean shouldRenderEnergyTooltip() {
        IEnergyStorage cap = (IEnergyStorage)this.stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return cap != null && cap.getMaxEnergyStored() > 0;
    }

    protected boolean shouldRenderEditTooltip() {
        Item item = this.stack.getItem();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.canEditAttachments(GunData.from(this.stack));
        }
        return false;
    }

    protected void renderDamageAndRpmTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getDamageComponent(), x, y, 0xFFFFFF);
        int xo = font.width(this.getDamageComponent().getVisualOrderText());
        guiGraphics.drawString(font, this.getRpmComponent(), x + xo + 16, y, 0xFFFFFF);
    }

    protected Component getDamageComponent() {
        DefaultGunData computed = this.data.compute();
        double damage = computed.damage;
        double explosionDamage = computed.explosionDamage;
        Object dmgStr = FormatTool.format1D(damage);
        if (computed.projectileAmount > 1) {
            dmgStr = (String)dmgStr + " * " + computed.projectileAmount;
        }
        MutableComponent component = Component.translatable((String)"des.superbwarfare.guns.damage").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)dmgStr).withStyle(ChatFormatting.GREEN));
        if (explosionDamage > 0.0) {
            Object expDmgStr = FormatTool.format1D(explosionDamage);
            if (computed.projectileAmount > 1) {
                expDmgStr = (String)expDmgStr + " * " + computed.projectileAmount;
            }
            component = component.append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)(" + " + (String)expDmgStr)).withStyle(ChatFormatting.GOLD));
        }
        return component;
    }

    protected Component getRpmComponent() {
        if (!(this.stack.getItem() instanceof GunItem)) {
            return Component.empty();
        }
        GunData data = GunData.from(this.stack);
        FireModeInfo info = data.selectedFireModeInfo();
        if (info.mode == FireMode.AUTO || info.mode == FireMode.BURST) {
            return Component.translatable((String)"des.superbwarfare.guns.rpm").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)FormatTool.format0D(data.compute().rpm)).withStyle(ChatFormatting.GREEN));
        }
        return Component.empty();
    }

    protected void renderLevelAndUpgradePointTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getLevelComponent(), x, y, 0xFFFFFF);
        int xo = font.width(this.getLevelComponent().getVisualOrderText());
        guiGraphics.drawString(font, this.getUpgradePointComponent(), x + xo + 16, y, 0xFFFFFF);
    }

    protected Component getLevelComponent() {
        int level = this.data.level.get();
        double rate = this.data.exp.get() / (20.0 * Math.pow(level, 2.0) + (double)(160 * level) + 20.0);
        ChatFormatting formatting = level < 10 ? ChatFormatting.WHITE : (level < 20 ? ChatFormatting.AQUA : (level < 30 ? ChatFormatting.LIGHT_PURPLE : (level < 40 ? ChatFormatting.GOLD : ChatFormatting.RED)));
        return Component.translatable((String)"des.superbwarfare.guns.level").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)("" + level)).withStyle(formatting).withStyle(ChatFormatting.BOLD)).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)(" (" + FormatTool.DECIMAL_FORMAT_2ZZZ.format(rate * 100.0) + "%)")).withStyle(ChatFormatting.GRAY));
    }

    protected Component getUpgradePointComponent() {
        int upgradePoint = this.data.level.get();
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = this.data.perk.getInstance(type);
            if (perkInstance == null) continue;
            upgradePoint -= perkInstance.level() - 1;
        }
        upgradePoint = Math.max(upgradePoint, 0);
        return Component.translatable((String)"des.superbwarfare.guns.upgrade_point").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)String.valueOf(upgradePoint)).withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.BOLD));
    }

    protected void renderBypassAndHeadshotTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getBypassComponent(), x, y, 0xFFFFFF);
        int xo = font.width(this.getBypassComponent().getVisualOrderText());
        guiGraphics.drawString(font, this.getHeadshotComponent(), x + xo + 16, y, 0xFFFFFF);
    }

    protected Component getBypassComponent() {
        double bypassRate = Math.max(this.data.compute().bypassesArmor, 0.0);
        return Component.translatable((String)"des.superbwarfare.guns.bypass").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)FormatTool.format2D(bypassRate * 100.0, "%")).withStyle(ChatFormatting.GOLD));
    }

    protected Component getHeadshotComponent() {
        double headshot = this.data.compute().headshot;
        return Component.translatable((String)"des.superbwarfare.guns.headshot").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)FormatTool.format1D(headshot, "x")).withStyle(ChatFormatting.AQUA));
    }

    protected void renderEnergyTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getEnergyComponent(), x, y, 0xFFFFFF);
    }

    protected Component getEnergyComponent() {
        int i;
        IEnergyStorage storage = (IEnergyStorage)this.stack.getCapability(Capabilities.EnergyStorage.ITEM);
        assert (storage != null);
        int energy = storage.getEnergyStored();
        int maxEnergy = storage.getMaxEnergyStored();
        float percentage = Mth.clamp((float)((float)energy / (float)maxEnergy), (float)0.0f, (float)1.0f);
        MutableComponent component = Component.empty();
        ChatFormatting format = percentage <= 0.2f ? ChatFormatting.RED : (percentage <= 0.6f ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
        int count = (int)(percentage * 50.0f);
        for (i = 0; i < count; ++i) {
            component.append((Component)Component.literal((String)"|").withStyle(format));
        }
        component.append((Component)Component.empty().withStyle(ChatFormatting.RESET));
        for (i = 0; i < 50 - count; ++i) {
            component.append((Component)Component.literal((String)"|").withStyle(ChatFormatting.GRAY));
        }
        component.append((Component)Component.literal((String)(" " + energy + "/" + maxEnergy + " FE")).withStyle(ChatFormatting.GRAY));
        return component;
    }

    protected void renderWeaponEditTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getEditComponent(), x, y + 10, 0xFFFFFF);
    }

    protected Component getEditComponent() {
        return Component.translatable((String)"des.superbwarfare.guns.edit", (Object[])new Object[]{"[" + ModKeyMappings.EDIT_MODE.getKey().getDisplayName().getString() + "]"}).withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(ChatFormatting.ITALIC);
    }

    protected void renderPerksShortcut(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.pose().pushPose();
        int xOffset = -20;
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = this.data.perk.getInstance(type);
            if (perkInstance == null) continue;
            Item ammoItem = (Item)perkInstance.perk().getItem().get();
            ItemStack perkStack = ammoItem.getDefaultInstance();
            short level = perkInstance.level();
            perkStack.setCount((int)level);
            guiGraphics.renderItem(perkStack, x + (xOffset += 20), y + 2);
            guiGraphics.renderItemDecorations(font, perkStack, x + xOffset, y + 2);
        }
        guiGraphics.pose().popPose();
    }

    protected void renderPerks(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.pose().pushPose();
        guiGraphics.drawString(font, (Component)Component.translatable((String)"perk.superbwarfare.tips").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.UNDERLINE), x, y + 10, 0xFFFFFF);
        int yOffset = -5;
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = this.data.perk.getInstance(type);
            if (perkInstance == null) continue;
            Item ammoItem = (Item)perkInstance.perk().getItem().get();
            guiGraphics.renderItem(ammoItem.getDefaultInstance(), x, y + 4 + (yOffset += 25));
            String id = perkInstance.perk().descriptionId;
            MutableComponent component = Component.translatable((String)("item.superbwarfare." + id)).withStyle(type.getColor()).append((Component)Component.literal((String)" ").withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)(" Lvl. " + perkInstance.level())).withStyle(ChatFormatting.WHITE));
            MutableComponent descComponent = Component.translatable((String)("des.superbwarfare." + id)).withStyle(ChatFormatting.GRAY);
            guiGraphics.drawString(font, (Component)component, x + 20, y + yOffset + 2, 0xFFFFFF);
            guiGraphics.drawString(font, (Component)descComponent, x + 20, y + yOffset + 12, 0xFFFFFF);
        }
        guiGraphics.pose().popPose();
    }

    protected int getDefaultMaxWidth(Font font) {
        int width = font.width(this.getDamageComponent().getVisualOrderText()) + font.width(this.getRpmComponent().getVisualOrderText()) + 16;
        width = Math.max(width, font.width(this.getLevelComponent().getVisualOrderText()) + font.width(this.getUpgradePointComponent().getVisualOrderText()) + 16);
        if (this.shouldRenderBypassAndHeadshotTooltip()) {
            width = Math.max(width, font.width(this.getBypassComponent().getVisualOrderText()) + font.width(this.getHeadshotComponent().getVisualOrderText()) + 16);
        }
        if (this.shouldRenderEditTooltip()) {
            width = Math.max(width, font.width(this.getEditComponent().getVisualOrderText()) + 16);
        }
        return width + 4;
    }

    protected int getMaxPerkDesWidth(Font font) {
        if (!this.shouldRenderPerks()) {
            return 0;
        }
        int width = 0;
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = this.data.perk.getInstance(type);
            if (perkInstance == null) continue;
            String id = perkInstance.perk().descriptionId;
            MutableComponent ammoDesComponent = Component.translatable((String)("des.superbwarfare." + id)).withStyle(ChatFormatting.GRAY);
            width = Math.max(width, font.width((FormattedText)ammoDesComponent));
        }
        return width + 25;
    }

    public int getHeight() {
        int height = Math.max(20, this.height);
        if (this.shouldRenderBypassAndHeadshotTooltip()) {
            height += 10;
        }
        if (this.shouldRenderEnergyTooltip()) {
            height += 20;
        }
        if (this.shouldRenderEditTooltip()) {
            height += 20;
        }
        if (this.shouldRenderPerks()) {
            height += 16;
            if (Screen.hasShiftDown()) {
                for (Perk.Type type : Perk.Type.values()) {
                    if (!this.data.perk.has(type)) continue;
                    height += 25;
                }
            }
        }
        return height;
    }

    public int getWidth(@NotNull Font font) {
        int width = this.getMaxPerkDesWidth(font);
        width = Screen.hasShiftDown() ? (width == 0 ? Math.max(this.width, this.getDefaultMaxWidth(font)) : Math.max(width, this.getDefaultMaxWidth(font))) : this.getDefaultMaxWidth(font);
        if (this.shouldRenderEnergyTooltip()) {
            width = Math.max(width, font.width(this.getEnergyComponent().getVisualOrderText()) + 10);
        }
        return width;
    }
}

