/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.compat.jei;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.compat.jei.GunPerksCategory;
import com.atsuishio.superbwarfare.compat.jei.PotionMortarShellRecipeMaker;
import com.atsuishio.superbwarfare.compat.jei.VehicleAssemblingCategory;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.NBTTool;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class SbwJEIPlugin
implements IModPlugin {
    private static IJeiRuntime jeiRuntime;

    @NotNull
    public ResourceLocation getPluginUid() {
        return Mod.loc("jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        SbwJEIPlugin.jeiRuntime = jeiRuntime;
    }

    public static Optional<IJeiRuntime> getJeiRuntime() {
        return Optional.ofNullable(jeiRuntime);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new GunPerksCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new VehicleAssemblingCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.REFORGING_TABLE.get()), new RecipeType[]{GunPerksCategory.TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.VEHICLE_ASSEMBLING_TABLE.get()), new RecipeType[]{VehicleAssemblingCategory.TYPE});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        RecipeManager recipeManager = level.getRecipeManager();
        List<ItemStack> guns = BuiltInRegistries.ITEM.stream().filter(item -> item instanceof GunItem).map(Item::getDefaultInstance).toList();
        registration.addRecipes(GunPerksCategory.TYPE, guns);
        registration.addRecipes(VehicleAssemblingCategory.TYPE, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.VEHICLE_ASSEMBLING_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addItemStackInfo(new ItemStack((ItemLike)ModItems.ANCIENT_CPU.get()), new Component[]{Component.translatable((String)"jei.superbwarfare.ancient_cpu")});
        registration.addItemStackInfo(new ItemStack((ItemLike)ModItems.CHARGING_STATION.get()), new Component[]{Component.translatable((String)"jei.superbwarfare.charging_station")});
        List<RecipeHolder<CraftingRecipe>> specialCraftingRecipes = PotionMortarShellRecipeMaker.createRecipes();
        registration.addRecipes(RecipeTypes.CRAFTING, specialCraftingRecipes);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.CONTAINER.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @NotNull
            public Object getSubtypeData(ItemStack ingredient, @NotNull UidContext context) {
                CompoundTag tag;
                CustomData data = (CustomData)ingredient.get(DataComponents.BLOCK_ENTITY_DATA);
                CompoundTag compoundTag = tag = data != null ? data.copyTag() : new CompoundTag();
                if (tag.contains("EntityType")) {
                    return tag.getString("EntityType");
                }
                return "";
            }

            @ParametersAreNonnullByDefault
            @NotNull
            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                return this.getSubtypeData(ingredient, context).toString();
            }
        });
        registration.registerSubtypeInterpreter((Item)ModItems.POTION_MORTAR_SHELL.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @ParametersAreNonnullByDefault
            @Nullable
            public Object getSubtypeData(ItemStack ingredient, UidContext context) {
                PotionContents contents = (PotionContents)ingredient.get(DataComponents.POTION_CONTENTS);
                if (contents == null) {
                    return null;
                }
                return contents.potion().orElse(null);
            }

            @ParametersAreNonnullByDefault
            @NotNull
            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                if (ingredient.getComponentsPatch().isEmpty()) {
                    return "";
                }
                PotionContents contents = (PotionContents)ingredient.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
                String itemDescriptionId = ingredient.getItem().getDescriptionId();
                String potionEffectId = contents.potion().map(Holder::getRegisteredName).orElse("none");
                return itemDescriptionId + ".effect_id." + potionEffectId;
            }
        });
        registration.registerSubtypeInterpreter((Item)ModItems.C4_BOMB.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @ParametersAreNonnullByDefault
            @NotNull
            public Object getSubtypeData(ItemStack ingredient, UidContext context) {
                return NBTTool.getTag(ingredient).getBoolean("Control");
            }

            @ParametersAreNonnullByDefault
            @NotNull
            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                return this.getSubtypeData(ingredient, context).toString();
            }
        });
    }

    public static boolean showRecipes(ItemStack itemStack) {
        boolean[] result = new boolean[]{false};
        SbwJEIPlugin.getJeiRuntime().ifPresent(jeiRuntime -> jeiRuntime.getIngredientManager().getIngredientTypeChecked((Object)itemStack).ifPresent(type -> {
            jeiRuntime.getRecipesGui().show(jeiRuntime.getJeiHelpers().getFocusFactory().createFocus(RecipeIngredientRole.OUTPUT, type, (Object)itemStack));
            result[0] = true;
        }));
        return result[0];
    }
}

