/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.Mod;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModColor {
    private int color = -1;

    public ModColor() {
    }

    public ModColor(int color) {
        this.color = 0xFF000000 | color;
    }

    public int get() {
        return 0xFF000000 | this.color;
    }

    static class ModColorAdapter
    extends TypeAdapter<ModColor> {
        private static final Pattern COLOR_PATTERN = Pattern.compile("^(#|0x)?(?<color>[a-f0-9]{6,})$");

        ModColorAdapter() {
        }

        public void write(JsonWriter out, ModColor value) throws IOException {
            if (value == null) {
                value = new ModColor();
            }
            out.value((long)value.color);
        }

        public ModColor read(JsonReader in) throws IOException {
            JsonToken p = in.peek();
            ModColor obj = new ModColor();
            if (p == JsonToken.STRING) {
                String str = in.nextString().trim().toLowerCase(Locale.ROOT);
                Matcher matcher = COLOR_PATTERN.matcher(str);
                if (matcher.matches()) {
                    String colorStr = matcher.group("color");
                    obj.color = 0xFF000000 | Integer.parseInt(colorStr.substring(colorStr.length() - 6), 16);
                } else {
                    Mod.LOGGER.warn("invalid color string: {}", (Object)str);
                }
            } else if (p == JsonToken.NUMBER) {
                obj.color = 0xFF000000 | in.nextInt();
            } else if (p == JsonToken.NULL) {
                in.nextNull();
            } else {
                throw new IllegalStateException("invalid color token " + String.valueOf(p));
            }
            return obj;
        }
    }
}

