/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.annotation.ServerOnly;
import com.atsuishio.superbwarfare.data.DeserializeFromString;
import com.atsuishio.superbwarfare.data.JsonPropertyModifier;
import com.atsuishio.superbwarfare.data.StringToObject;
import com.atsuishio.superbwarfare.data.gun.Ammo;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunPropertyModifier;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmmoConsumer
implements DeserializeFromString,
GunPropertyModifier {
    @SerializedName(value="Ammo")
    public String ammo;
    @SerializedName(value="AmmoSlot")
    public String ammoSlot = "Default";
    @ServerOnly
    @SerializedName(value="Projectile")
    public StringToObject<ProjectileInfo> projectile = null;
    @SerializedName(value="Override")
    public JsonObject override = null;
    @SerializedName(value="Icon")
    public String icon = Mod.loc("textures/screens/vehicle_weapon/empty.png").toString();
    @SerializedName(value="ShouldUnload")
    public boolean shouldUnload = true;
    public transient AmmoConsumeType type = AmmoConsumeType.EMPTY;
    public transient int loadAmount = 1;
    public static final AmmoConsumer INVALID = new AmmoConsumer();
    private transient boolean initialized = false;
    private transient Ammo playerAmmoType;
    private transient ItemStack stack = ItemStack.EMPTY;
    private static final Pattern AMMO_PATTERN = Pattern.compile("^(?<count>(\\d+)?)\\s*(?<prefix>[@#]?)(?<id>\\w+(:\\w+)?)\\s*(?<data>(\\{.*})?)$");
    private final transient JsonPropertyModifier<GunData, DefaultGunData> jsonPropModifier = new JsonPropertyModifier();

    public ItemStack stack() {
        return this.stack;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public boolean isAmmoItem(ItemStack stack) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.stack);
    }

    public int consume(@NotNull GunData data, @NotNull Entity shooter, int count) {
        Player player;
        if (!this.initialized) {
            this.init();
        }
        if (count <= 0 || this.type == AmmoConsumeType.INFINITE || shooter instanceof Player && (player = (Player)shooter).isCreative()) {
            return 0;
        }
        if (this.type == AmmoConsumeType.INVALID) {
            Mod.LOGGER.warn("consume ammo failed: invalid AmmoConsumeType");
            return 0;
        }
        int consumed = 0;
        if (this.type == AmmoConsumeType.PLAYER_AMMO && shooter instanceof Player) {
            Player player2 = (Player)shooter;
            if (this.playerAmmoType != null) {
                int current = this.playerAmmoType.get((Entity)player2);
                consumed = Math.min(current, count);
                count -= consumed;
                this.playerAmmoType.add((Entity)player2, -consumed);
            } else {
                Mod.LOGGER.warn("consume player ammo failed: invalid player ammo type");
            }
        }
        if (this.type == AmmoConsumeType.ENERGY) {
            IEnergyStorage energyStorage = data.getEnergyProvider(shooter);
            if (energyStorage == null) {
                return 0;
            }
            return energyStorage.extractEnergy(count, false);
        }
        IItemHandler handler = (IItemHandler)shooter.getCapability(Capabilities.ItemHandler.ENTITY);
        if (handler != null) {
            return consumed + this.consume(data, handler, count);
        }
        Mod.LOGGER.warn("consume ammo failed: invalid item handler for entity {}", (Object)shooter);
        return consumed;
    }

    public int consume(@NotNull GunData data, @NotNull IItemHandler handler, int count) {
        if (!this.initialized) {
            this.init();
        }
        if (this.type == AmmoConsumeType.INVALID || this.type == AmmoConsumeType.INFINITE || this.type == AmmoConsumeType.EMPTY || count <= 0) {
            return 0;
        }
        if (this.type == AmmoConsumeType.PLAYER_AMMO) {
            int consumed = InventoryTool.consumeAmmoItem(handler, this.playerAmmoType, count);
            int rest = consumed - count;
            data.virtualAmmo.add(rest);
            return count;
        }
        if (this.type == AmmoConsumeType.ENERGY) {
            IEnergyStorage energyStorage = (IEnergyStorage)data.stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return 0;
            }
            return energyStorage.extractEnergy(count, false);
        }
        return InventoryTool.consumeItem(handler, this::isAmmoItem, count);
    }

    public int count(@NotNull GunData data, @Nullable Entity entity) {
        if (!this.initialized) {
            this.init();
        }
        if (this.type == AmmoConsumeType.INFINITE) {
            return Integer.MAX_VALUE;
        }
        if (entity == null || this.type == AmmoConsumeType.EMPTY) {
            return 0;
        }
        int playerAmmoCount = 0;
        if (this.type == AmmoConsumeType.PLAYER_AMMO && entity instanceof Player) {
            Player player = (Player)entity;
            playerAmmoCount = this.playerAmmoType.get((Entity)player);
        } else if (this.type == AmmoConsumeType.ENERGY) {
            IEnergyStorage energyStorage = data.getEnergyProvider(entity);
            if (energyStorage == null) {
                return 0;
            }
            return energyStorage.getEnergyStored();
        }
        return playerAmmoCount + this.count(data, (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY));
    }

    public int count(@NotNull GunData data, @Nullable IItemHandler handler) {
        if (!this.initialized) {
            this.init();
        }
        if (this.type == AmmoConsumeType.INFINITE) {
            return Integer.MAX_VALUE;
        }
        if (handler == null || this.type == AmmoConsumeType.EMPTY) {
            return 0;
        }
        if (this.type == AmmoConsumeType.ITEM) {
            return InventoryTool.countItem(handler, this::isAmmoItem);
        }
        if (this.type == AmmoConsumeType.ENERGY) {
            IEnergyStorage energyStorage = (IEnergyStorage)data.stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) {
                return 0;
            }
            return energyStorage.getEnergyStored();
        }
        return InventoryTool.countAmmoItem(handler, this.playerAmmoType);
    }

    public int withdraw(@NotNull Entity ammoSupplier, int count) {
        if (!this.initialized) {
            this.init();
        }
        if (this.type == AmmoConsumeType.INVALID || this.type == AmmoConsumeType.INFINITE || this.type == AmmoConsumeType.EMPTY || this.type == AmmoConsumeType.ENERGY || count <= 0) {
            return 0;
        }
        if (this.type == AmmoConsumeType.PLAYER_AMMO) {
            if (ammoSupplier instanceof Player) {
                Player player = (Player)ammoSupplier;
                if (this.playerAmmoType != null) {
                    this.playerAmmoType.add((Entity)player, count);
                    return count;
                }
                Mod.LOGGER.warn("withdraw player ammo failed: invalid player ammo type");
            } else {
                IItemHandler itemHandler = (IItemHandler)ammoSupplier.getCapability(Capabilities.ItemHandler.ENTITY);
                if (itemHandler != null) {
                    return this.withdraw(itemHandler, count);
                }
                Mod.LOGGER.warn("withdraw ammo failed: invalid item handler");
            }
        } else {
            if (ammoSupplier instanceof Player) {
                Player player = (Player)ammoSupplier;
                int limit = this.stack.getMaxStackSize();
                while (count > 0) {
                    int toInsert = Math.min(limit, count);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.stack.copyWithCount(toInsert));
                    count -= toInsert;
                }
                return count;
            }
            IItemHandler itemHandler = (IItemHandler)ammoSupplier.getCapability(Capabilities.ItemHandler.ENTITY);
            if (itemHandler != null) {
                return this.withdraw(itemHandler, count);
            }
            Mod.LOGGER.warn("withdraw ammo failed: invalid item handler");
        }
        return 0;
    }

    public int withdraw(@NotNull IItemHandler handler, int count) {
        if (!this.initialized) {
            this.init();
        }
        if (this.type == AmmoConsumeType.INVALID || this.type == AmmoConsumeType.INFINITE || this.type == AmmoConsumeType.EMPTY || this.type == AmmoConsumeType.ENERGY || count <= 0) {
            return 0;
        }
        ItemStack stackToInsert = this.type == AmmoConsumeType.PLAYER_AMMO ? this.getPlayerAmmoType().getItemStack() : this.stack;
        int inserted = 0;
        while (count > 0) {
            int limit = stackToInsert.getMaxStackSize();
            int toInsert = Math.min(limit, count);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stackToInsert.copyWithCount(toInsert), (boolean)false);
            count -= toInsert - result.getCount();
            inserted += toInsert - result.getCount();
            if (result.isEmpty()) continue;
            Mod.LOGGER.warn("trying to withdraw ammo {} with count {}, but only {} is inserted", (Object)stackToInsert, (Object)count, (Object)inserted);
            break;
        }
        return inserted;
    }

    @Override
    public DefaultGunData computeProperties(GunData gunData, DefaultGunData rawData) {
        if (this.projectile != null) {
            rawData.projectile = this.projectile;
        }
        if (this.override != null) {
            this.jsonPropModifier.update(this.override);
            rawData = this.jsonPropModifier.computeProperties(gunData, rawData);
        }
        return rawData;
    }

    public void init() {
        if (this.ammo == null) {
            return;
        }
        Matcher matcher = AMMO_PATTERN.matcher(this.ammo.trim());
        if (!matcher.matches()) {
            Mod.LOGGER.warn("invalid ammo value: {}", (Object)this.ammo);
            return;
        }
        String numStr = matcher.group("count").trim();
        this.loadAmount = Mth.clamp((int)(numStr.isEmpty() ? 1 : Integer.parseInt(numStr)), (int)1, (int)Integer.MAX_VALUE);
        String prefix = matcher.group("prefix");
        String id = matcher.group("id");
        String data = matcher.group("data");
        if (prefix.isBlank()) {
            switch (id.toLowerCase(Locale.ROOT)) {
                case "infinity": 
                case "infinite": {
                    AmmoConsumeType ammoConsumeType = AmmoConsumeType.INFINITE;
                    break;
                }
                case "empty": {
                    AmmoConsumeType ammoConsumeType = AmmoConsumeType.EMPTY;
                    break;
                }
                case "fe": 
                case "rf": 
                case "energy": {
                    AmmoConsumeType ammoConsumeType = AmmoConsumeType.ENERGY;
                    break;
                }
                default: {
                    AmmoConsumeType ammoConsumeType = this.type = AmmoConsumeType.INVALID;
                }
            }
            if (this.type != AmmoConsumeType.INVALID) {
                return;
            }
        }
        if ("@".equals(prefix)) {
            this.playerAmmoType = Ammo.getType(id);
            if (this.playerAmmoType == null) {
                Mod.LOGGER.warn("invalid player ammo type: {}", (Object)id);
                return;
            }
            this.type = AmmoConsumeType.PLAYER_AMMO;
            this.stack = this.playerAmmoType.getItemStack();
        } else {
            ResourceLocation location = ResourceLocation.tryParse((String)id);
            if (location == null) {
                Mod.LOGGER.warn("invalid item id: {}", (Object)id);
                return;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(location);
            if (item == Items.AIR) {
                Mod.LOGGER.warn("invalid item: {}", (Object)id);
                return;
            }
            this.stack = new ItemStack((ItemLike)item);
            if (!data.isEmpty()) {
                try {
                    CompoundTag tag = NbtUtils.snbtToStructure((String)data);
                    tag.putString("id", location.toString());
                    tag.putInt("count", 1);
                    ItemStack.parse((HolderLookup.Provider)RegistryAccess.EMPTY, (Tag)tag).ifPresent(stack -> {
                        this.stack = stack;
                    });
                }
                catch (CommandSyntaxException exception) {
                    Mod.LOGGER.warn("invalid item data {}: {}", (Object)data, (Object)exception.getMessage());
                    return;
                }
            }
            this.type = AmmoConsumeType.ITEM;
        }
        this.initialized = true;
    }

    @Override
    public void deserializeFromString(String str) {
        this.ammo = str;
        this.init();
    }

    public Ammo getPlayerAmmoType() {
        return this.playerAmmoType;
    }

    public static enum AmmoConsumeType {
        INVALID,
        EMPTY,
        INFINITE,
        PLAYER_AMMO,
        ITEM,
        ENERGY;

    }
}

