/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun.subdata;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.item.PerkItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.registries.DeferredHolder;

public final class Perks {
    private final CompoundTag perks;

    public Perks(GunData gun) {
        this.perks = gun.perk();
    }

    public boolean has(Perk perk) {
        if (!this.has(perk.type)) {
            return false;
        }
        return this.getTag(perk).getString("Name").equals(perk.name);
    }

    public boolean has(Perk.Type type) {
        return this.perks.contains(type.getName()) && !this.perks.getCompound(type.getName()).getString("Name").isEmpty();
    }

    public void set(PerkInstance instance) {
        this.set(instance.perk(), instance.level());
    }

    public CompoundTag getTag(DeferredHolder<Perk, Perk> registry) {
        return this.getTag(((Perk)registry.get()).type);
    }

    public CompoundTag getTag(Perk perk) {
        return this.getTag(perk.type);
    }

    public CompoundTag getTag(Perk.Type type) {
        return this.perks.getCompound(type.getName());
    }

    public CompoundTag getOrCreateTag(Perk perk) {
        Perk.Type type = perk.type;
        if (!this.perks.contains(type.getName())) {
            CompoundTag typeTag = new CompoundTag();
            this.perks.put(type.getName(), (Tag)typeTag);
        }
        return this.perks.getCompound(type.getName());
    }

    public void set(Perk perk, short level) {
        this.getOrCreateTag(perk).putString("Name", perk.name);
        this.getOrCreateTag(perk).putShort("Level", level);
    }

    public short getLevel(PerkItem<?> item) {
        return this.getLevel(item.getPerk());
    }

    public short getLevel(DeferredHolder<Perk, ? extends Perk> perk) {
        return this.getLevel((Perk)perk.get());
    }

    public short getLevel(Perk perk) {
        String name = perk.name;
        CompoundTag tag = this.getTag(perk);
        if (!tag.getString("Name").equals(name)) {
            return 0;
        }
        return this.getLevel(perk.type);
    }

    public short getLevel(Perk.Type type) {
        return this.getTag(type).getShort("Level");
    }

    @Nullable
    public Perk get(DeferredHolder<Perk, Perk> registry) {
        return this.get((Perk)registry.get());
    }

    @Nullable
    public Perk get(Perk perk) {
        return this.get(perk.type);
    }

    @Nullable
    public Perk get(Perk.Type type) {
        ArrayList perksRegistry = new ArrayList();
        perksRegistry.addAll(ModPerks.AMMO_PERKS.getEntries());
        perksRegistry.addAll(ModPerks.FUNC_PERKS.getEntries());
        perksRegistry.addAll(ModPerks.DAMAGE_PERKS.getEntries());
        for (DeferredHolder registry : perksRegistry) {
            String name = this.getTag(type).getString("Name");
            if (!((Perk)registry.get()).name.equals(name)) continue;
            return (Perk)registry.get();
        }
        return null;
    }

    @Nullable
    public PerkInstance getInstance(Perk perk) {
        return this.getInstance(perk.type);
    }

    @Nullable
    public PerkInstance getInstance(Perk.Type type) {
        Perk perk = this.get(type);
        if (perk == null) {
            return null;
        }
        return new PerkInstance(perk, this.getLevel(type));
    }

    public void reduceCooldown(DeferredHolder<Perk, Perk> registry, String name) {
        this.reduceCooldown((Perk)registry.get(), name);
    }

    public void reduceCooldown(Perk perk, String name) {
        this.reduceCooldown(perk.type, name);
    }

    public void reduceCooldown(Perk.Type type, String name) {
        CompoundTag tag = this.getTag(type);
        int value = tag.getInt(name);
        if (--value <= 0) {
            tag.remove(name);
        } else {
            tag.putInt(name, value);
        }
    }

    public void remove(Perk perk) {
        this.remove(perk.type);
    }

    public void remove(Perk.Type type) {
        this.perks.remove(type.getName());
    }
}

