/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.vehicle;

import com.atsuishio.superbwarfare.network.message.receive.VehiclesDataMessage;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="superbwarfare")
public class VehicleDataTool {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MinecraftServer server = player2.getServer();
            if (server != null && server.isSingleplayerOwner(player2.getGameProfile())) {
                return;
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)VehiclesDataMessage.create(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        MinecraftServer server = event.getPlayerList().getServer();
        VehiclesDataMessage message = VehiclesDataMessage.create();
        for (ServerPlayer player : event.getRelevantPlayers().toList()) {
            if (server.isSingleplayerOwner(player.getGameProfile())) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

