/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.datagen;

import com.atsuishio.superbwarfare.datagen.ModAdvancementProvider;
import com.atsuishio.superbwarfare.datagen.ModBlockStateProvider;
import com.atsuishio.superbwarfare.datagen.ModBlockTagProvider;
import com.atsuishio.superbwarfare.datagen.ModDamageTypeTagProvider;
import com.atsuishio.superbwarfare.datagen.ModEntityTypeTagProvider;
import com.atsuishio.superbwarfare.datagen.ModItemModelProvider;
import com.atsuishio.superbwarfare.datagen.ModItemTagProvider;
import com.atsuishio.superbwarfare.datagen.ModLootTableProvider;
import com.atsuishio.superbwarfare.datagen.ModRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="superbwarfare", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        ModBlockTagProvider tagProvider = (ModBlockTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, tagProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTypeTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDamageTypeTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(packOutput, lookupProvider, existingFileHelper));
    }
}

