/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.common.MedicalKitItem;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MedicalKitEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MedicalKitEntity(EntityType<MedicalKitEntity> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    public boolean isPickable() {
        return true;
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            if (!this.level().isClientSide()) {
                this.discard();
            }
            if (!player.getAbilities().instabuild) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.MEDICAL_KIT.get()));
            }
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05, 0.0));
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float f = 0.98f;
        if (this.onGround()) {
            this.setXRot(-90.0f);
            BlockPos pos = this.getBlockPosBelowThatAffectsMyMovement();
            f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        } else {
            this.updateRotation();
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        if (this.tickCount >= 10) {
            this.touchEntity();
        }
        this.refreshDimensions();
    }

    public void touchEntity() {
        block1: {
            Level level = this.level();
            if (!(level instanceof ServerLevel)) break block1;
            ServerLevel serverLevel = (ServerLevel)level;
            AABB frontBox = this.getBoundingBox().inflate(0.3);
            List entities = this.level().getEntities(EntityTypeTest.forClass(LivingEntity.class), frontBox, living -> living.getHealth() < living.getMaxHealth()).stream().toList();
            Iterator iterator = entities.iterator();
            if (iterator.hasNext()) {
                LivingEntity entity = (LivingEntity)iterator.next();
                MedicalKitItem.treat(entity);
                serverLevel.playSound(null, this.position().x, this.position().y, this.position().z, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.5f, 1.0f);
                this.discard();
            }
        }
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
    }

    protected void updateRotation() {
        if (this.getDeltaMovement().length() > 0.05) {
            Vec3 vec3 = this.getDeltaMovement();
            double d0 = vec3.horizontalDistance();
            this.setXRot(MedicalKitEntity.lerpRotation(this.xRotO, (float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875)));
            this.setYRot(MedicalKitEntity.lerpRotation(this.yRotO, (float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875)));
        }
    }

    protected static float lerpRotation(float pCurrentRotation, float pTargetRotation) {
        while (pTargetRotation - pCurrentRotation < -180.0f) {
            pCurrentRotation -= 360.0f;
        }
        while (pTargetRotation - pCurrentRotation >= 180.0f) {
            pCurrentRotation += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)pCurrentRotation, (float)pTargetRotation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

