/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.client.particle.CustomCloudOption;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrapeshotEntity
extends FastThrowableProjectile {
    public GrapeshotEntity(EntityType<? extends GrapeshotEntity> type, Level level) {
        super(type, level);
        this.noCulling = true;
    }

    public GrapeshotEntity(@Nullable Entity entity, Level level, float damage) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.GRAPESHOT.get()), entity, level);
        this.noCulling = true;
        this.damage = damage;
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.GS_5_INCHES.get();
    }

    @Override
    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (this.getOwner() != null && this.getOwner().getVehicle() != null && entity == this.getOwner().getVehicle()) {
            return;
        }
        if (this.level() instanceof ServerLevel) {
            LivingEntity living;
            if (entity == this.getOwner() || this.getOwner() != null && entity == this.getOwner().getVehicle()) {
                return;
            }
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).level().isClientSide() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            DamageHandler.doDamage(entity, ModDamageTypes.causeGrapeShotHitDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.damage);
            if (entity instanceof LivingEntity) {
                entity.invulnerableTime = 0;
            }
            this.discard();
        }
    }

    @Override
    public void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos resultPos = result.getBlockPos();
        BlockState state = this.level().getBlockState(resultPos);
        SoundEvent event = state.getBlock().getSoundType(state, (LevelReader)this.level(), resultPos, (Entity)this).getBreakSound();
        this.level().playSound(null, result.getLocation().x, result.getLocation().y, result.getLocation().z, event, SoundSource.AMBIENT, 1.0f, 1.0f);
        Vec3 hitVec = result.getLocation();
        this.hitBlock(hitVec, result);
        this.discard();
    }

    protected void hitBlock(Vec3 location, BlockHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = result.getBlockPos();
            Direction face = result.getDirection();
            BlockState state = this.level().getBlockState(pos);
            double vx = face.getStepX();
            double vy = face.getStepY();
            double vz = face.getStepZ();
            Vec3 dir = new Vec3(vx, vy, vz);
            this.summonVectorParticle(serverLevel, state, location, dir);
            this.discard();
            serverLevel.playSound(null, new BlockPos((int)location.x, (int)location.y, (int)location.z), (SoundEvent)ModSounds.LAND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void summonVectorParticle(ServerLevel serverLevel, BlockState state, Vec3 pos, Vec3 dir) {
        Vec3 vec3;
        int i;
        BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.BLOCK, state);
        for (i = 0; i < 7; ++i) {
            vec3 = this.randomVec(dir, 40.0);
            ParticleTool.sendParticle(serverLevel, particleData, pos.x + 0.05 * (double)i * dir.x, pos.y + 0.05 * (double)i * dir.y, pos.z + 0.05 * (double)i * dir.z, 0, vec3.x, vec3.y, vec3.z, 10.0, true);
        }
        for (i = 0; i < 3; ++i) {
            vec3 = this.randomVec(dir, 20.0);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.SMOKE, pos.x, pos.y, pos.z, 0, vec3.x, vec3.y, vec3.z, 0.05, true);
        }
        BlockPos blockPos = BlockPos.containing((Position)pos);
        if (state.getSoundType((LevelReader)serverLevel, blockPos, null) == SoundType.METAL || state.getSoundType((LevelReader)serverLevel, blockPos, null) == SoundType.ANVIL || state.getSoundType((LevelReader)serverLevel, blockPos, null) == SoundType.CHAIN || state.getSoundType((LevelReader)serverLevel, blockPos, null) == SoundType.COPPER || state.getSoundType((LevelReader)serverLevel, blockPos, null) == SoundType.NETHERITE_BLOCK) {
            serverLevel.playSound(null, pos.x, pos.y, pos.z, (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
            for (int i2 = 0; i2 < 3; ++i2) {
                Vec3 vec32 = this.randomVec(dir, 80.0);
                ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), pos.x, pos.y, pos.z, 0, vec32.x, vec32.y, vec32.z, 0.2 + 0.1 * Math.random(), true);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            Vec3 startVec = this.position();
            Vec3 endVec = startVec.add(this.getDeltaMovement());
            BlockHitResult fluidResult = ProjectileEntity.rayTraceBlocks(this.level(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this), state -> false);
            this.onHitWater(fluidResult.getLocation(), fluidResult);
        }
        Vec3 vec31 = this.getDeltaMovement();
        this.setDeltaMovement(vec31.multiply(0.96, 0.96, 0.96));
        if (this.tickCount > 200 || this.isInWater()) {
            this.discard();
        }
    }

    protected void onHitWater(Vec3 location, BlockHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = result.getBlockPos();
            Direction face = result.getDirection();
            BlockState state = this.level().getBlockState(pos);
            double vx = face.getStepX();
            double vy = face.getStepY();
            double vz = face.getStepZ();
            Vec3 dir = new Vec3(vx, vy, vz).add(this.getDeltaMovement().normalize().scale(-0.1));
            if (state.getBlock() == Blocks.WATER) {
                if (!this.isInWater()) {
                    CustomCloudOption particleData = new CustomCloudOption(1.0f, 1.0f, 1.0f, 80, 0.5f, 1.0f, false, false);
                    for (int i = 0; i < 10; ++i) {
                        Vec3 vec3 = this.randomVec(dir, 40.0);
                        ParticleTool.sendParticle(serverLevel, particleData, location.x + 0.12 * (double)i * dir.x, location.y + 0.12 * (double)i * dir.y, location.z + 0.12 * (double)i * dir.z, 0, vec3.x, vec3.y, vec3.z, 15.0, true);
                    }
                    ParticleTool.spawnBulletHitWaterParticles((Level)serverLevel, location);
                    serverLevel.playSound(null, new BlockPos((int)location.x, (int)location.y, (int)location.z), (SoundEvent)ModSounds.HIT_WATER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.discard();
                }
            } else if (state.getBlock() == Blocks.LAVA && !this.isInLava()) {
                BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.BLOCK, state);
                for (int i = 0; i < 7; ++i) {
                    Vec3 vec3 = this.randomVec(dir, 20.0);
                    ParticleTool.sendParticle(serverLevel, particleData, location.x + 0.1 * (double)i * dir.x, location.y + 0.1 * (double)i * dir.y, location.z + 0.1 * (double)i * dir.z, 0, vec3.x, vec3.y, vec3.z, 10.0, true);
                }
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, location.x, location.y, location.z, 4, 0.0, 0.0, 0.0, 0.6, true);
                serverLevel.playSound(null, new BlockPos((int)location.x, (int)location.y, (int)location.z), SoundEvents.LAVA_POP, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.discard();
            }
        }
    }

    public Vec3 randomVec(Vec3 vec3, double spread) {
        return vec3.normalize().add(this.random.triangle(0.0, 0.0172275 * spread), this.random.triangle(0.0, 0.0172275 * spread), this.random.triangle(0.0, 0.0172275 * spread));
    }

    @Override
    public boolean isFastMoving() {
        return false;
    }
}

