/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.MissileProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class JavelinMissileEntity
extends MissileProjectile
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> TOP = SynchedEntityData.defineId(JavelinMissileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public JavelinMissileEntity(EntityType<? extends JavelinMissileEntity> type, Level level) {
        super(type, level);
        this.noCulling = true;
    }

    public JavelinMissileEntity(Entity entity, Level level, float damage, float explosionDamage, float explosionRadius, int guideType, @Nullable Vec3 targetPos) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.JAVELIN_MISSILE.get()), entity, level);
        this.noCulling = true;
        this.damage = damage;
        this.explosionDamage = explosionDamage;
        this.explosionRadius = explosionRadius;
        this.guideType = guideType;
        this.durability = 50;
        if (targetPos != null) {
            this.targetPos = targetPos;
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.JAVELIN_MISSILE.get();
    }

    public void setAttackMode(boolean mode) {
        this.entityData.set(TOP, (Object)mode);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TOP, (Object)false);
    }

    @Override
    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (this.getOwner() != null && this.getOwner().getVehicle() != null && entity == this.getOwner().getVehicle()) {
            return;
        }
        if (this.level() instanceof ServerLevel) {
            LivingEntity living;
            if (entity == this.getOwner() || this.getOwner() != null && entity == this.getOwner().getVehicle()) {
                return;
            }
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).level().isClientSide() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            DamageHandler.doDamage(entity, ModDamageTypes.causeProjectileHitDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), ((Boolean)this.entityData.get(TOP) != false ? 1.25f : 1.0f) * this.damage);
            if (entity instanceof LivingEntity) {
                entity.invulnerableTime = 0;
            }
            this.causeExplode(result.getLocation());
            this.discard();
        }
    }

    @Override
    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (this.level() instanceof ServerLevel) {
            BlockPos resultPos = blockHitResult.getBlockPos();
            float hardness = this.level().getBlockState(resultPos).getBlock().defaultDestroyTime();
            if (hardness != -1.0f) {
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                    if (this.firstHit) {
                        this.causeExplode(blockHitResult.getLocation());
                        this.firstHit = false;
                        Mod.queueServerWork(3, () -> ((JavelinMissileEntity)this).discard());
                    }
                    if (((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
                        this.level().destroyBlock(resultPos, true);
                    }
                }
            } else {
                this.causeExplode(blockHitResult.getLocation());
                this.discard();
            }
            if (!((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                this.causeExplode(blockHitResult.getLocation());
                this.discard();
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.mediumTrail();
        Entity entity = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(TARGET_UUID));
        List<Entity> decoy = SeekTool.seekLivingEntities((Entity)this, 32.0, 90.0);
        for (Entity e : decoy) {
            if (!e.getType().is(ModTags.EntityTypes.DECOY) || this.distracted) continue;
            this.entityData.set(TARGET_UUID, (Object)e.getStringUUID());
            this.distracted = true;
            break;
        }
        if (this.guideType == 0 || !((String)this.entityData.get(TARGET_UUID)).equals("none")) {
            if (entity != null) {
                boolean dir = this.position().vectorTo(entity.position()).horizontalDistanceSqr() < 900.0;
                double dis = entity.position().vectorTo(this.position()).horizontalDistance();
                double height = dis > 30.0 ? 0.2 * (dis - 30.0) : 0.0;
                Vec3 targetPos = new Vec3(entity.getX(), entity.getY() + (double)(0.5f * entity.getBbHeight()) + (double)(entity instanceof EnderDragon ? -3 : 0) + height, entity.getZ());
                Vec3 targetVec = new Vec3(entity.getDeltaMovement().x, 0.0, entity.getDeltaMovement().z);
                Vec3 toVec = this.position().vectorTo(targetPos.add(targetVec)).normalize();
                if ((!entity.getPassengers().isEmpty() || entity instanceof VehicleEntity) && entity.tickCount % (int)Math.max(0.04 * (double)this.distanceTo(entity), 2.0) == 0) {
                    entity.level().playSound(null, entity.getOnPos(), entity instanceof Pig ? SoundEvents.PIG_HURT : (SoundEvent)ModSounds.MISSILE_WARNING.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
                }
                if (this.tickCount > 3) {
                    if (((Boolean)this.entityData.get(TOP)).booleanValue()) {
                        if (!dir) {
                            Vec3 targetTopPos = new Vec3(targetPos.x, targetPos.y + (double)Mth.clamp((int)(6 * this.tickCount), (int)0, (int)90), targetPos.z);
                            Vec3 toTopVec = this.position().vectorTo(targetTopPos).normalize();
                            this.turn(toTopVec, 6.0f);
                        } else {
                            boolean lostTarget;
                            boolean bl = lostTarget = this.getY() < entity.getY();
                            if (!lostTarget) {
                                this.turn(toVec, 90.0f);
                                this.setDeltaMovement(this.getDeltaMovement().scale(0.1).add(this.getLookAngle().scale(8.0)));
                            }
                        }
                    } else {
                        boolean lostTarget;
                        boolean bl = lostTarget = VectorTool.calculateAngle(this.getLookAngle(), toVec) > 80.0;
                        if (!lostTarget) {
                            this.turn(toVec, 6.0f);
                        }
                    }
                }
            }
        } else if (this.guideType == 1) {
            double dis = this.targetPos.vectorTo(this.position()).horizontalDistance();
            double height = dis > 30.0 ? 0.2 * (dis - 30.0) : 0.0;
            boolean dir = this.position().vectorTo(this.targetPos).horizontalDistanceSqr() < 900.0;
            Vec3 toVec = this.getEyePosition().vectorTo(this.targetPos.add(0.0, height, 0.0)).normalize();
            if (this.tickCount > 3) {
                if (((Boolean)this.entityData.get(TOP)).booleanValue()) {
                    if (!dir) {
                        Vec3 targetTopPos = new Vec3(this.targetPos.x, this.targetPos.y + (double)Mth.clamp((int)(5 * this.tickCount), (int)0, (int)90), this.targetPos.z);
                        Vec3 toTopVec = this.getEyePosition().vectorTo(targetTopPos).normalize();
                        this.turn(toTopVec, 6.0f);
                    } else {
                        boolean lostTarget;
                        boolean bl = lostTarget = this.getY() < this.targetPos.y;
                        if (!lostTarget) {
                            this.turn(toVec, 90.0f);
                            this.setDeltaMovement(this.getDeltaMovement().scale(0.1).add(this.getLookAngle().scale(8.0)));
                        }
                    }
                } else {
                    boolean lostTarget;
                    boolean bl = lostTarget = VectorTool.calculateAngle(this.getDeltaMovement(), toVec) > 80.0;
                    if (!lostTarget) {
                        this.turn(toVec, 6.0f);
                    }
                }
            }
        }
        if (this.tickCount > 3) {
            this.setDeltaMovement(this.getDeltaMovement().add(this.getLookAngle()));
        }
        if (this.tickCount > 200 || this.isInWater() || ((Float)this.entityData.get(HEALTH)).floatValue() <= 0.0f) {
            if (this.level() instanceof ServerLevel) {
                ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, ModDamageTypes.causeProjectileExplosionDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), (Entity)this, this.explosionDamage, this.explosionRadius);
            }
            this.discard();
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.8, 0.8, 0.8));
        this.destroyBlock();
    }

    private PlayState movementPredicate(AnimationState<JavelinMissileEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.jvm.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.ROCKET_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.4f;
    }
}

