/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectile;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MelonBombEntity
extends DestroyableProjectile {
    public MelonBombEntity(EntityType<? extends MelonBombEntity> type, Level level) {
        super(type, level);
        this.noCulling = true;
        this.explosionRadius = 10.0f;
        this.explosionDamage = 500.0f;
    }

    public MelonBombEntity(LivingEntity entity, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MELON_BOMB.get()), (Entity)entity, level);
        this.noCulling = true;
        this.explosionRadius = 10.0f;
        this.explosionDamage = 500.0f;
    }

    @NotNull
    protected Item getDefaultItem() {
        return Items.MELON;
    }

    @Override
    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (this.level() instanceof ServerLevel) {
            if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && ((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
                AABB aabb = new AABB(blockHitResult.getLocation(), blockHitResult.getLocation()).inflate(5.0);
                BlockPos.betweenClosedStream((AABB)aabb).forEach(pos -> {
                    float hard = this.level().getBlockState(pos).getBlock().defaultDestroyTime();
                    if (hard != -1.0f) {
                        Vec3 vec3 = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                        if (vec3.distanceTo(blockHitResult.getLocation()) < 3.0) {
                            this.level().destroyBlock(pos, true);
                        }
                    }
                });
            }
            ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.5f);
            this.discard();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount > 600 || ((Float)this.entityData.get(HEALTH)).floatValue() <= 0.0f) {
            this.discard();
            if (!this.level().isClientSide) {
                ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.5f);
            }
        }
    }

    @Override
    public float getMaxHealth() {
        return 15.0f;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.SHELL_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.7f;
    }
}

