/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SmallCannonShellEntity
extends FastThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean aa;

    public SmallCannonShellEntity(EntityType<? extends SmallCannonShellEntity> type, Level level) {
        super(type, level);
        this.noCulling = true;
        this.damage = 40.0f;
        this.explosionDamage = 80.0f;
        this.explosionRadius = 5.0f;
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.SMALL_SHELL.get();
    }

    @Override
    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (this.getOwner() != null && this.getOwner().getVehicle() != null && entity == this.getOwner().getVehicle()) {
            return;
        }
        if (this.level() instanceof ServerLevel) {
            LivingEntity living;
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).level().isClientSide() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            DamageHandler.doDamage(entity, ModDamageTypes.causeProjectileHitDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.damage);
            if (entity instanceof LivingEntity) {
                entity.invulnerableTime = 0;
            }
            if (this.tickCount > 0) {
                this.causeExplode(result.getLocation(), true);
            }
            this.discard();
        }
    }

    @Override
    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        Block block;
        float hardness;
        super.onHitBlock(blockHitResult);
        BlockPos resultPos = blockHitResult.getBlockPos();
        BlockState state = this.level().getBlockState(resultPos);
        if (this.level() instanceof ServerLevel && (hardness = this.level().getBlockState(resultPos).getBlock().defaultDestroyTime()) != -1.0f && ((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && ((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
            boolean destroy;
            boolean bl = destroy = Math.random() < Mth.clamp((double)(1.0f - hardness / 50.0f), (double)0.1, (double)1.0);
            if (destroy) {
                this.level().destroyBlock(resultPos, true);
            }
        }
        if ((block = state.getBlock()) instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            bell.attemptToRing(this.level(), resultPos, blockHitResult.getDirection());
        }
        if (this.level() instanceof ServerLevel) {
            this.causeExplode(blockHitResult.getLocation(), false);
        }
        this.discard();
    }

    private void causeExplode(Vec3 vec3, boolean hitEntity) {
        new CustomExplosion.Builder((Entity)this).attacker(this.getOwner()).damage(this.explosionDamage).radius(this.explosionRadius).position(vec3).withParticleType(ParticleTool.ParticleType.SMALL).destroyBlock(() -> hitEntity ? Explosion.BlockInteraction.KEEP : ((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP)).damageMultiplier(1.25f).explode();
    }

    @Override
    public void tick() {
        Level level;
        super.tick();
        if (!this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.SMOKE, this.xo, this.yo, this.zo, 1, 0.0, 0.0, 0.0, 0.02, true);
        }
        if (this.onGround()) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        if (this.tickCount > 200 || this.isInWater()) {
            if (this.level() instanceof ServerLevel && !this.onGround()) {
                this.causeExplode(this.position(), false);
            }
            this.discard();
        }
        if (this.aa) {
            this.crushProjectile(this.getDeltaMovement());
        }
    }

    public void crushProjectile(Vec3 velocity) {
        if (this.level() instanceof ServerLevel) {
            AABB frontBox = this.getBoundingBox().inflate(0.5).expandTowards(velocity);
            Optional<Projectile> target = this.level().getEntities(EntityTypeTest.forClass(Projectile.class), frontBox, entity -> entity != this).stream().filter(entity -> !(entity instanceof SmallCannonShellEntity) && ((double)entity.getBbWidth() >= 0.3 || (double)entity.getBbHeight() >= 0.3)).min(Comparator.comparingDouble(e -> e.position().distanceTo(this.position())));
            if (target.isPresent()) {
                this.causeExplode(target.get().position(), false);
                Projectile projectile = target.get();
                if (projectile instanceof DestroyableProjectile) {
                    LivingEntity living;
                    DestroyableProjectile destroyableProjectile = (DestroyableProjectile)projectile;
                    Entity entity2 = this.getOwner();
                    if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).level().isClientSide() && living instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)living;
                        living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    DamageHandler.doDamage((Entity)destroyableProjectile, ModDamageTypes.causeProjectileHitDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.damage);
                } else {
                    target.get().discard();
                }
                this.discard();
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void antiAir(boolean antiAir) {
        this.aa = antiAir;
    }

    @Override
    public boolean isFastMoving() {
        return false;
    }
}

