/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4d;
import org.joml.Vector4d;

public class Mi28Entity
extends GeoVehicleEntity {
    public Mi28Entity(EntityType<Mi28Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        this.mi28TerrainCompact();
    }

    public void mi28TerrainCompact() {
        if (this.onGround()) {
            double heightY;
            BlockState state;
            VoxelShape shape;
            Matrix4d transform = this.getVehicleTransform(1.0f);
            Vector4d position = this.transformPosition(transform, 0.0, 0.58, -11.1);
            Vec3 p = new Vec3(position.x, position.y, position.z);
            Level level = this.level();
            BlockHitResult res = level.clip(new ClipContext(p, p.add(0.0, -100.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            BlockPos blockPos = BlockPos.containing((Position)p);
            BlockPos blockPosUp = BlockPos.containing((Position)p.add(0.0, 1.0, 0.0));
            if (level.getBlockState(blockPosUp).canOcclude()) {
                blockPos = blockPosUp;
            }
            if (!(shape = (state = level.getBlockState(blockPos)).getCollisionShape((BlockGetter)level, blockPos)).isEmpty()) {
                heightY = p.y - (shape.max(Direction.Axis.Y) + (double)blockPos.getY());
                if (heightY < -0.4) {
                    this.addDeltaMovement(blockPos.getCenter().vectorTo(p).scale(0.02));
                }
            } else {
                heightY = res.getType() == HitResult.Type.BLOCK && level.noCollision(new AABB(p, p)) ? Mth.clamp((double)(p.y - res.getLocation().y), (double)0.0, (double)2.0) : 0.0;
            }
            this.setXRot((float)((double)this.getXRot() - 2.0 * heightY));
        }
    }

    @Override
    public double getMouseSensitivity() {
        return 0.25;
    }
}

