/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.SoundInfo;
import com.atsuishio.superbwarfare.entity.projectile.MortarShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.ArtilleryIndicator;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.item.Monitor;
import com.atsuishio.superbwarfare.item.common.ammo.MortarShell;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class MortarEntity
extends ArtilleryEntity {
    public static final EntityDataAccessor<Integer> FIRE_TIME = SynchedEntityData.defineId(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> TARGET_PITCH = SynchedEntityData.defineId(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> TARGET_YAW = SynchedEntityData.defineId(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> INTELLIGENT = SynchedEntityData.defineId(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private LivingEntity shooter = null;

    public MortarEntity(EntityType<MortarEntity> type, Level level) {
        super(type, level);
    }

    public MortarEntity(Level level, float yRot) {
        super((EntityType)ModEntities.MORTAR.get(), level);
        this.setYRot(yRot);
        this.entityData.set(TARGET_YAW, (Object)Float.valueOf(yRot));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(INTELLIGENT, (Object)false).define(TARGET_PITCH, (Object)Float.valueOf(-70.0f)).define(TARGET_YAW, (Object)Float.valueOf(this.getYRot())).define(FIRE_TIME, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("TargetPitch", ((Float)this.entityData.get(TARGET_PITCH)).floatValue());
        compound.putFloat("TargetYaw", ((Float)this.entityData.get(TARGET_YAW)).floatValue());
        compound.putBoolean("Intelligent", ((Boolean)this.entityData.get(INTELLIGENT)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("TargetPitch")) {
            this.entityData.set(TARGET_PITCH, (Object)Float.valueOf(compound.getFloat("TargetPitch")));
        }
        if (compound.contains("TargetYaw")) {
            this.entityData.set(TARGET_YAW, (Object)Float.valueOf(compound.getFloat("TargetYaw")));
        }
        if (compound.contains("Intelligent")) {
            this.entityData.set(INTELLIGENT, (Object)compound.getBoolean("Intelligent"));
        }
    }

    @Override
    public void vehicleShoot(@Nullable LivingEntity living, String weaponName) {
        Level level;
        if (!(((ItemStack)this.items.getFirst()).getItem() instanceof MortarShell)) {
            return;
        }
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return;
        }
        if ((Integer)this.entityData.get(FIRE_TIME) != 0) {
            return;
        }
        SoundInfo soundInfo = gunData.compute().soundInfo;
        this.shooter = living;
        this.entityData.set(FIRE_TIME, (Object)25);
        if (!this.level().isClientSide()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), soundInfo.vehicleReload, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SoundTool.playDistantSound(serverLevel, soundInfo.fire3P, this.position(), (float)(0.25 * gunData.compute().soundRadius), this.random.nextFloat() * 0.1f + 1.0f, null);
            SoundTool.playDistantSound(serverLevel, soundInfo.fire3PFar, this.position(), (float)gunData.compute().soundRadius, this.random.nextFloat() * 0.1f + 1.0f, null);
        }
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        InteractionResult result = super.interact(player, hand);
        if (result != InteractionResult.PASS) {
            return result;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (item instanceof ArtilleryIndicator) {
            ArtilleryIndicator indicator = (ArtilleryIndicator)item;
            if (((Boolean)this.entityData.get(INTELLIGENT)).booleanValue()) {
                return indicator.bind(mainHandItem, player, this);
            }
        }
        if (mainHandItem.getItem() instanceof Monitor && !((Boolean)this.entityData.get(INTELLIGENT)).booleanValue()) {
            this.entityData.set(INTELLIGENT, (Object)true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (!player.isCreative()) {
                mainHandItem.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (mainHandItem.is(ModTags.Items.TOOLS_CROWBAR)) {
            if (((ItemStack)this.items.getFirst()).getItem() instanceof MortarShell && (Integer)this.entityData.get(FIRE_TIME) == 0 && this.level() instanceof ServerLevel) {
                this.vehicleShoot((LivingEntity)player, "Main");
            }
            return InteractionResult.SUCCESS;
        }
        if (mainHandItem.getItem() instanceof MortarShell && !player.isShiftKeyDown() && (Integer)this.entityData.get(FIRE_TIME) == 0 && ((ItemStack)this.items.getFirst()).isEmpty()) {
            this.items.set(0, (Object)mainHandItem.copyWithCount(1));
            if (!player.isCreative()) {
                mainHandItem.shrink(1);
            }
            this.vehicleShoot((LivingEntity)player, "Main");
            return InteractionResult.SUCCESS;
        }
        if (player.getMainHandItem().getItem() == ModItems.FIRING_PARAMETERS.get()) {
            this.setTarget(player.getMainHandItem(), (Entity)player, "Main");
        }
        if (player.getOffhandItem().getItem() == ModItems.FIRING_PARAMETERS.get()) {
            this.setTarget(player.getOffhandItem(), (Entity)player, "Main");
        }
        if (player.isShiftKeyDown()) {
            this.entityData.set(TARGET_YAW, (Object)Float.valueOf(player.getYRot()));
        }
        return InteractionResult.FAIL;
    }

    @Override
    @NotNull
    public List<ItemStack> getRetrieveItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.MORTAR_DEPLOYER.get()));
        if (((Boolean)this.entityData.get(INTELLIGENT)).booleanValue()) {
            list.add(new ItemStack((ItemLike)ModItems.MONITOR.get()));
        }
        if (this.items.get(0) != ItemStack.EMPTY) {
            list.add((ItemStack)this.items.get(0));
        }
        return list;
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if ((Integer)this.entityData.get(FIRE_TIME) > 0) {
            this.entityData.set(FIRE_TIME, (Object)((Integer)this.entityData.get(FIRE_TIME) - 1));
        }
        if ((Integer)this.entityData.get(FIRE_TIME) == 5 && ((ItemStack)this.items.getFirst()).getItem() instanceof MortarShell) {
            Level level = this.level();
            GunData gunData = this.getGunData("Main");
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                if (gunData != null) {
                    MortarShellEntity entityToSpawn = MortarShell.createShell(this.shooter, level, (ItemStack)this.items.get(0), this.getProjectileGravity("Main"), (float)gunData.compute().damage, (float)gunData.compute().explosionDamage, (float)gunData.compute().explosionRadius);
                    entityToSpawn.setPos(this.getX(), this.getEyeY(), this.getZ());
                    entityToSpawn.shoot(this.getLookAngle().x, this.getLookAngle().y, this.getLookAngle().z, this.getProjectileVelocity("Main"), this.getProjectileSpread("Main"));
                    level.addFreshEntity((Entity)entityToSpawn);
                    ParticleTool.spawnMediumCannonMuzzleParticles(this.getLookAngle(), new Vec3(this.getX(), this.getEyeY(), this.getZ()).add(this.getLookAngle().scale(1.5)), server, this);
                    this.clearContent();
                    if (((Boolean)this.entityData.get(INTELLIGENT)).booleanValue()) {
                        this.resetTarget("Main");
                    }
                    gunData.shakePlayers(this);
                }
            }
        }
    }

    @Override
    public void setTarget(ItemStack stack, Entity entity, String weaponName) {
        FiringParameters.Parameters parameters = (FiringParameters.Parameters)stack.getOrDefault(ModDataComponents.FIRING_PARAMETERS, (Object)new FiringParameters.Parameters());
        double targetX = parameters.pos().getX();
        double targetY = parameters.pos().getY() - 1;
        double targetZ = parameters.pos().getZ();
        boolean canAim = true;
        this.entityData.set(TARGET_POS, (Object)new Vector3f((float)targetX, (float)targetY, (float)targetZ));
        this.entityData.set(DEPRESSED, (Object)parameters.isDepressed());
        this.entityData.set(RADIUS, (Object)parameters.radius());
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.entityData.get(TARGET_POS)), (Integer)this.entityData.get(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.getEyePosition(), randomPos, this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName), (Boolean)this.entityData.get(DEPRESSED));
        Vec3 launchVector2 = RangeTool.calculateLaunchVector(this.getEyePosition(), randomPos, this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName), (Boolean)this.entityData.get(DEPRESSED) == false);
        MutableComponent component = Component.literal((String)"");
        MutableComponent location = Component.translatable((String)"tips.superbwarfare.mortar.position", (Object[])new Object[]{this.getDisplayName()}).append((Component)Component.literal((String)(" X:" + FormatTool.format0D(this.getX()) + " Y:" + FormatTool.format0D(this.getY()) + " Z:" + FormatTool.format0D(this.getZ()) + " ")));
        float angle = this.getXRot();
        if (launchVector == null || launchVector2 == null) {
            canAim = false;
            component = Component.translatable((String)"tips.superbwarfare.mortar.out_of_range");
        } else {
            angle = (float)(-VehicleVecUtils.getXRotFromVector(launchVector));
            float angle2 = (float)(-VehicleVecUtils.getXRotFromVector(launchVector2));
            if (angle < -this.getTurretMaxPitch() || angle > -this.getTurretMinPitch()) {
                if (angle2 > -this.getTurretMaxPitch() && angle2 < -this.getTurretMinPitch()) {
                    component = Component.translatable((String)"tips.superbwarfare.ballistics.warn2");
                    canAim = false;
                } else {
                    component = Component.translatable((String)"tips.superbwarfare.mortar.warn", (Object[])new Object[]{this.getDisplayName()});
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.displayClientMessage((Component)location.copy().append((Component)component).withStyle(ChatFormatting.RED), false);
                    }
                    return;
                }
            }
            if (angle < -this.getTurretMaxPitch()) {
                component = Component.translatable((String)"tips.superbwarfare.ballistics.warn");
                canAim = false;
            }
        }
        if (canAim) {
            this.look(randomPos);
            this.entityData.set(TARGET_PITCH, (Object)Float.valueOf(angle));
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            player.displayClientMessage((Component)location.copy().append((Component)component).withStyle(ChatFormatting.RED), false);
        }
    }

    @Override
    public void resetTarget(String weaponName) {
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.entityData.get(TARGET_POS)), (Integer)this.entityData.get(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.getEyePosition(), randomPos, this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName), (Boolean)this.entityData.get(DEPRESSED));
        this.look(randomPos);
        if (launchVector == null) {
            return;
        }
        float angle = (float)(-VehicleVecUtils.getXRotFromVector(launchVector));
        if (angle > -this.getTurretMaxPitch() && angle < -this.getTurretMinPitch()) {
            this.entityData.set(TARGET_PITCH, (Object)Float.valueOf(angle));
        }
    }

    public void look(Vec3 pTarget) {
        Vec3 vec3 = EntityAnchorArgument.Anchor.EYES.apply((Entity)this);
        double d0 = (pTarget.x - vec3.x) * 0.2;
        double d2 = (pTarget.z - vec3.z) * 0.2;
        this.entityData.set(TARGET_YAW, (Object)Float.valueOf(Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f))));
    }

    @Override
    public void travel() {
        float diffY = Mth.wrapDegrees((float)(((Float)this.entityData.get(TARGET_YAW)).floatValue() - this.getYRot()));
        float diffX = Mth.wrapDegrees((float)(((Float)this.entityData.get(TARGET_PITCH)).floatValue() - this.getXRot()));
        this.setYRot(this.getYRot() + Mth.clamp((float)(0.5f * diffY), (float)-20.0f, (float)20.0f));
        this.setXRot(Mth.clamp((float)(this.getXRot() + Mth.clamp((float)(0.5f * diffX), (float)-20.0f, (float)20.0f)), (float)-89.0f, (float)-20.0f));
    }

    private PlayState movementPredicate(AnimationState<MortarEntity> event) {
        if ((Integer)this.entityData.get(FIRE_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mortar.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mortar.idle"));
    }

    @Override
    public void destroy() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            level2.explode(null, x, y, z, 0.0f, Level.ExplosionInteraction.NONE);
            ItemEntity mortar = new ItemEntity((Level)level2, x, y + 1.0, z, new ItemStack((ItemLike)ModItems.MORTAR_DEPLOYER.get()));
            mortar.setPickUpDelay(10);
            level2.addFreshEntity((Entity)mortar);
            if (((Boolean)this.entityData.get(INTELLIGENT)).booleanValue()) {
                ItemEntity monitor = new ItemEntity((Level)level2, x, y + 1.0, z, new ItemStack((ItemLike)ModItems.MONITOR.get()));
                monitor.setPickUpDelay(10);
                level2.addFreshEntity((Entity)monitor);
            }
        }
        super.destroy();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public void setChanged() {
        if (!((Boolean)this.entityData.get(INTELLIGENT)).booleanValue()) {
            this.vehicleShoot(null, "Main");
        }
    }

    @Override
    @Nullable
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)ModItems.MORTAR_DEPLOYER.get());
    }

    @Override
    public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        return super.canPlaceItem(slot, stack) && (Integer)this.entityData.get(FIRE_TIME) == 0 && stack.getItem() instanceof MortarShell;
    }
}

