/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.MediumRocketEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.common.ammo.MediumRocketItem;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4d;

public class Type63Entity
extends GeoVehicleEntity {
    public static final EntityDataAccessor<Float> TARGET_PITCH = SynchedEntityData.defineId(Type63Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> TARGET_YAW = SynchedEntityData.defineId(Type63Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> BODY_YAW = SynchedEntityData.defineId(Type63Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> SHOOT_PITCH = SynchedEntityData.defineId(Type63Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> SHOOT_YAW = SynchedEntityData.defineId(Type63Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<List<Integer>> LOADED_AMMO = SynchedEntityData.defineId(Type63Entity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.INT_LIST_SERIALIZER.get()));
    public OBB[] barrel = new OBB[12];
    public OBB pitchController;
    public OBB yawController;
    public OBB hoe1;
    public OBB hoe2;
    public OBB wheel1 = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.125, 0.390625, 0.390625), new Quaterniond(), OBB.Part.WHEEL_LEFT);
    public OBB wheel2 = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.125, 0.390625, 0.390625), new Quaterniond(), OBB.Part.WHEEL_RIGHT);
    public OBB body1 = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.4765625, 0.3515625, 0.7578125), new Quaterniond(), OBB.Part.BODY);
    public OBB body2 = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d((double)0.771875f, 0.109375, 0.296875), new Quaterniond(), OBB.Part.BODY);
    public double interactionTick;
    public int cooldown;

    public Type63Entity(EntityType<Type63Entity> type, Level world) {
        super(type, world);
        this.barrel[0] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[1] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[2] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[3] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[4] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[5] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[6] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[7] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[8] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[9] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[10] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.barrel[11] = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.09375, 0.09375, 0.0625), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.pitchController = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.15625, 0.21875, 0.21875), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.yawController = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.125, 0.125, 0.125), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.hoe1 = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.125, 0.125, 0.875), new Quaterniond(), OBB.Part.INTERACTIVE);
        this.hoe2 = new OBB(OBB.vec3ToVector3d(this.position()), new Vector3d(0.125, 0.125, 0.875), new Quaterniond(), OBB.Part.INTERACTIVE);
    }

    @Override
    public boolean canBeCollidedWith() {
        return true;
    }

    public void playerTouch(Player pPlayer) {
        if (this.position().distanceTo(pPlayer.position()) > 1.4 || pPlayer == this.getFirstPassenger() || pPlayer.position().y > this.position().y || !pPlayer.isShiftKeyDown()) {
            return;
        }
        if (!this.level().isClientSide && pPlayer.getY() < this.getY() + (double)this.getBbHeight() && pPlayer.getY() + (double)pPlayer.getBbHeight() > this.getY()) {
            double entitySize = pPlayer.getBbWidth() * pPlayer.getBbHeight();
            double thisSize = this.getBbWidth() * this.getBbHeight();
            double f = Math.min((double)(entitySize / thisSize), (double)2.0);
            this.setDeltaMovement(this.getDeltaMovement().add(new Vec3(pPlayer.position().vectorTo(this.position()).toVector3f()).scale(0.5 * f * pPlayer.getDeltaMovement().length())));
            this.setYRot(pPlayer.getYHeadRot());
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            list.add(-1);
        }
        builder.define(TARGET_PITCH, (Object)Float.valueOf(0.0f)).define(TARGET_YAW, (Object)Float.valueOf(0.0f)).define(BODY_YAW, (Object)Float.valueOf(0.0f)).define(SHOOT_PITCH, (Object)Float.valueOf(0.0f)).define(SHOOT_YAW, (Object)Float.valueOf(0.0f)).define(LOADED_AMMO, list);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("Pitch", ((Float)this.entityData.get(TARGET_PITCH)).floatValue());
        compound.putFloat("Yaw", ((Float)this.entityData.get(TARGET_YAW)).floatValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(TARGET_PITCH, (Object)Float.valueOf(compound.getFloat("Pitch")));
        this.entityData.set(TARGET_YAW, (Object)Float.valueOf(compound.getFloat("Yaw")));
        this.setChanged();
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        return 1;
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        Level vec3;
        InteractionResult result = super.interact(player, hand);
        if (result != InteractionResult.PASS) {
            return result;
        }
        ItemStack stack = player.getMainHandItem();
        OBB lookingObb = OBB.getLookingObb(player, player.entityInteractionRange());
        if (stack.isEmpty()) {
            if (player.isShiftKeyDown()) {
                Level vec32;
                if (lookingObb == this.hoe1) {
                    Level level = player.level();
                    if (level instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level;
                        this.entityData.set(BODY_YAW, (Object)Float.valueOf(((Float)this.entityData.get(BODY_YAW)).floatValue() + 0.2f * (float)this.interactionTick));
                        this.interactionTick += 1.0;
                        if (this.cooldown == 0) {
                            this.cooldown = 6;
                            vec32 = OBB.vector3dToVec3(this.hoe1.center());
                            serverLevel.playSound(null, vec32.x, vec32.y, vec32.z, (SoundEvent)ModSounds.WHEEL_VEHICLE_STEP.get(), SoundSource.PLAYERS, 0.5f, this.random.nextFloat() * 0.05f + 0.975f);
                        }
                    }
                    player.swing(InteractionHand.MAIN_HAND);
                }
                if (lookingObb == this.hoe2) {
                    vec32 = player.level();
                    if (vec32 instanceof ServerLevel) {
                        serverLevel = (ServerLevel)vec32;
                        this.entityData.set(BODY_YAW, (Object)Float.valueOf(((Float)this.entityData.get(BODY_YAW)).floatValue() - 0.2f * (float)this.interactionTick));
                        this.interactionTick += 1.0;
                        if (this.cooldown == 0) {
                            this.cooldown = 6;
                            vec32 = OBB.vector3dToVec3(this.hoe1.center());
                            serverLevel.playSound(null, vec32.x, vec32.y, vec32.z, (SoundEvent)ModSounds.WHEEL_VEHICLE_STEP.get(), SoundSource.PLAYERS, 0.5f, this.random.nextFloat() * 0.05f + 0.975f);
                        }
                    }
                    player.swing(InteractionHand.MAIN_HAND);
                }
            } else {
                player.swing(InteractionHand.MAIN_HAND);
                Level vec33 = this.level();
                if (vec33 instanceof ServerLevel) {
                    serverLevel = (ServerLevel)vec33;
                    if (this.cooldown == 0) {
                        for (int i = 0; i < this.barrel.length; ++i) {
                            if (lookingObb != this.barrel[i] || ((ItemStack)this.items.get(i)).isEmpty()) continue;
                            player.addItem(((ItemStack)this.items.get(i)).copyWithCount(1));
                            vec3 = OBB.vector3dToVec3(this.barrel[i].center());
                            serverLevel.playSound(null, vec3.x, vec3.y, vec3.z, (SoundEvent)ModSounds.TYPE_63_RELOAD.get(), SoundSource.PLAYERS, 1.0f, this.random.nextFloat() * 0.1f + 0.9f);
                            this.cooldown = 5;
                            this.items.set(i, (Object)ItemStack.EMPTY);
                            this.setChanged();
                        }
                    }
                }
            }
            if (lookingObb == this.yawController) {
                this.interactEvent(OBB.vector3dToVec3(this.yawController.center()));
                this.entityData.set(TARGET_YAW, (Object)Float.valueOf(Mth.clamp((float)(((Float)this.entityData.get(TARGET_YAW)).floatValue() + (player.isShiftKeyDown() ? -0.02f : 0.02f) * (float)this.interactionTick), (float)(-this.getTurretMaxYaw()), (float)(-this.getTurretMinYaw()))));
                player.swing(InteractionHand.MAIN_HAND);
            }
            if (lookingObb == this.pitchController) {
                this.interactEvent(OBB.vector3dToVec3(this.pitchController.center()));
                this.entityData.set(TARGET_PITCH, (Object)Float.valueOf(Mth.clamp((float)(((Float)this.entityData.get(TARGET_PITCH)).floatValue() + (player.isShiftKeyDown() ? 0.02f : -0.02f) * (float)this.interactionTick), (float)(-this.getTurretMaxPitch()), (float)(-this.getTurretMinPitch()))));
                player.swing(InteractionHand.MAIN_HAND);
            }
        }
        if (stack.getItem() instanceof MediumRocketItem) {
            for (int i = 0; i < this.barrel.length; ++i) {
                if (lookingObb == this.barrel[i] && ((ItemStack)this.items.get(i)).isEmpty() && (vec3 = this.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)vec3;
                    if (this.cooldown == 0) {
                        this.setItem(i, stack.copyWithCount(1));
                        if (!player.isCreative()) {
                            stack.shrink(1);
                        }
                        vec3 = OBB.vector3dToVec3(this.barrel[i].center());
                        serverLevel.playSound(null, vec3.x, vec3.y, vec3.z, (SoundEvent)ModSounds.TYPE_63_RELOAD.get(), SoundSource.PLAYERS, 1.0f, this.random.nextFloat() * 0.1f + 0.9f);
                        this.cooldown = 5;
                        this.setChanged();
                    }
                }
                player.swing(InteractionHand.MAIN_HAND);
            }
        }
        if (this.cooldown == 0 && (stack.is(ModTags.Items.TOOLS_CROWBAR) || stack.is(Items.FLINT_AND_STEEL))) {
            if (this.lookingAtBarrel(player)) {
                for (int i = 0; i < this.barrel.length; ++i) {
                    if (lookingObb != this.barrel[i] || !(((ItemStack)this.items.get(i)).getItem() instanceof MediumRocketItem)) continue;
                    this.shoot(player, i);
                    this.items.set(i, (Object)ItemStack.EMPTY);
                    this.setChanged();
                }
                player.swing(InteractionHand.MAIN_HAND);
            } else {
                for (int i = 0; i < 12; ++i) {
                    if (!(((ItemStack)this.items.get(i)).getItem() instanceof MediumRocketItem)) continue;
                    this.shoot(player, i);
                    this.items.set(i, (Object)ItemStack.EMPTY);
                    this.setChanged();
                    player.swing(InteractionHand.MAIN_HAND);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean lookingAtBarrel(Player player) {
        OBB lookingObb = OBB.getLookingObb(player, player.entityInteractionRange());
        for (int i = 0; i < 12; ++i) {
            if (lookingObb != this.barrel[i]) continue;
            return true;
        }
        return false;
    }

    public void interactEvent(Vec3 vec3) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.interactionTick += 1.0;
            if (this.cooldown <= 0) {
                this.cooldown = 6;
                serverLevel.playSound(null, vec3.x, vec3.y, vec3.z, (SoundEvent)ModSounds.HAND_WHEEL_ROT.get(), SoundSource.PLAYERS, 1.0f, this.random.nextFloat() * 0.05f + 0.975f);
            }
        }
    }

    public void shoot(Player player, int i) {
        ItemStack stack = (ItemStack)this.items.get(i);
        Item item = stack.getItem();
        if (!(item instanceof MediumRocketItem)) {
            return;
        }
        MediumRocketItem rocketItem = (MediumRocketItem)item;
        GunData gunData = this.getGunData(rocketItem.type.toString());
        if (gunData == null) {
            return;
        }
        float shootVelocity = this.getProjectileVelocity(gunData);
        float shootSpread = this.getProjectileSpread(gunData);
        float shootGravity = this.getProjectileGravity(gunData);
        OBB obb = this.barrel[i];
        Vec3 shootPos = OBB.vector3dToVec3(obb.center());
        DefaultGunData computed = gunData.compute();
        MediumRocketEntity entityToSpawn = new MediumRocketEntity((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MEDIUM_ROCKET.get()), shootPos.x, shootPos.y, shootPos.z, this.level(), (float)computed.damage, (float)computed.explosionRadius, (float)computed.explosionDamage, 0.0f, 0, rocketItem.type, computed.sparedAmount, computed.sparedAngle);
        entityToSpawn.setGravity(shootGravity);
        entityToSpawn.setOwner((Entity)player);
        Vec3 barrelVector = this.getBarrelVector(1.0f);
        entityToSpawn.shoot(barrelVector.x, barrelVector.y, barrelVector.z, shootVelocity, shootSpread);
        this.level().addFreshEntity((Entity)entityToSpawn);
        this.level().playSound(null, shootPos.x, shootPos.y, shootPos.z, computed.soundInfo.fire3P, SoundSource.PLAYERS, (float)computed.soundRadius, this.random.nextFloat() * 0.1f + 0.95f);
        AABB ab = new AABB(this.getBoundingBox().getCenter(), this.getBoundingBox().getCenter()).inflate(0.75).move(barrelVector.scale(-2.0)).expandTowards(barrelVector.scale(-5.0));
        for (Entity entity : this.level().getEntities(EntityTypeTest.forClass(Entity.class), ab, target -> target != this && target != this.getFirstPassenger() && target.getVehicle() == null)) {
            entity.hurt(ModDamageTypes.causeBurnDamage(entity.level().registryAccess(), (Entity)player), 30.0f - 2.0f * entity.distanceTo((Entity)this));
            double force = 4.0 - 0.7 * (double)entity.distanceTo((Entity)this);
            entity.push(-force * barrelVector.x, -force * barrelVector.y, -force * barrelVector.z);
        }
        this.cooldown = 10;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.spawnMediumCannonMuzzleParticles(barrelVector.scale(-1.0), shootPos.add(barrelVector.scale(-0.5)), serverLevel, this);
            ParticleTool.spawnMediumCannonMuzzleParticles(barrelVector.scale(-1.0), shootPos.add(barrelVector.scale(-1.5)), serverLevel, this);
            ParticleTool.spawnMediumCannonMuzzleParticles(barrelVector, shootPos.add(barrelVector.scale(1.5)), serverLevel, this);
        }
        gunData.shakePlayers(this);
    }

    @Override
    public void baseTick() {
        this.turretYRotO = this.getTurretYRot();
        this.turretXRotO = this.getTurretXRot();
        this.leftWheelRotO = this.getLeftWheelRot();
        this.rightWheelRotO = this.getRightWheelRot();
        super.baseTick();
        double fluidFloat = 0.052 * VehicleVecUtils.getSubmergedHeight(this);
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, fluidFloat, 0.0));
        if (this.onGround()) {
            float f0 = 0.35f + 0.5f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f;
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).normalize().scale(0.05 * this.getDeltaMovement().dot(this.getViewVector(1.0f)))));
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f0, 0.99, (double)f0));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.99, 0.99, 0.99));
        }
        if (this.isInWater()) {
            float f1 = (float)((double)0.7f - (double)0.04f * Math.min((double)VehicleVecUtils.getSubmergedHeight(this), (double)this.getBbHeight()) + (double)(0.08f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f));
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).normalize().scale(0.04 * this.getDeltaMovement().dot(this.getViewVector(1.0f)))));
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f1, 0.85, (double)f1));
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        this.interactionTick *= 0.94;
        if (this.level() instanceof ServerLevel) {
            this.entityData.set(SHOOT_PITCH, (Object)Float.valueOf((float)VehicleVecUtils.getXRotFromVector(this.getBarrelVector(1.0f))));
            this.entityData.set(SHOOT_YAW, (Object)Float.valueOf((float)(-VehicleVecUtils.getYRotFromVector(this.getBarrelVector(1.0f)))));
        }
        this.entityData.set(BODY_YAW, (Object)Float.valueOf(((Float)this.entityData.get(BODY_YAW)).floatValue() * 0.8f));
        this.setYRot(this.getYRot() + ((Float)this.entityData.get(BODY_YAW)).floatValue());
        this.refreshDimensions();
    }

    @Override
    public void travel() {
        float diffY = ((Float)this.entityData.get(TARGET_YAW)).floatValue() - this.getTurretYRot();
        this.setTurretYRot(Mth.clamp((float)(this.getTurretYRot() + 0.1f * diffY), (float)(-this.getTurretMaxYaw()), (float)(-this.getTurretMinYaw())));
        float diffX = ((Float)this.entityData.get(TARGET_PITCH)).floatValue() - this.getTurretXRot();
        this.setTurretXRot(Mth.clamp((float)(this.getTurretXRot() + 0.1f * diffX), (float)(-this.getTurretMaxPitch()), (float)(-this.getTurretMinPitch())));
        double s0 = this.getDeltaMovement().dot(this.getViewVector(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - 1.167 * s0));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - 1.167 * s0));
    }

    public Vec3 getShootPos(float pPartialTicks) {
        Matrix4d transform = this.getBarrelTransform(pPartialTicks);
        Vector4d rootPosition = this.transformPosition(transform, 0.0, 6.25E-4, -0.44625);
        return new Vec3(rootPosition.x, rootPosition.y, rootPosition.z);
    }

    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        return false;
    }

    @Override
    public boolean canTakeItem(@NotNull Container target, int slot, @NotNull ItemStack stack) {
        return false;
    }

    @Override
    public List<OBB> getOBBs() {
        return List.of(this.barrel[0], this.barrel[1], this.barrel[2], this.barrel[3], this.barrel[4], this.barrel[5], this.barrel[6], this.barrel[7], this.barrel[8], this.barrel[9], this.barrel[10], this.barrel[11], this.hoe1, this.hoe2, this.yawController, this.pitchController, this.wheel1, this.wheel2, this.body1, this.body2);
    }

    @Override
    public void updateOBB() {
        Matrix4d transform = this.getVehicleTransform(1.0f);
        Vector4d worldPosition = this.transformPosition(transform, 0.875, 0.1875, -1.625);
        this.hoe1.center().set((Vector3fc)new Vector3f((float)worldPosition.x, (float)worldPosition.y, (float)worldPosition.z));
        this.hoe1.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4d worldPosition2 = this.transformPosition(transform, -0.875, 0.1875, -1.625);
        this.hoe2.center().set((Vector3fc)new Vector3f((float)worldPosition2.x, (float)worldPosition2.y, (float)worldPosition2.z));
        this.hoe2.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4d worldPositionW = this.transformPosition(transform, 0.90625, 0.390625, 0.1071875);
        this.wheel1.center().set((Vector3fc)new Vector3f((float)worldPositionW.x, (float)worldPositionW.y, (float)worldPositionW.z));
        this.wheel1.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4d worldPositionW2 = this.transformPosition(transform, -0.90625, 0.390625, 0.1071875);
        this.wheel2.center().set((Vector3fc)new Vector3f((float)worldPositionW2.x, (float)worldPositionW2.y, (float)worldPositionW2.z));
        this.wheel2.setRotation(VectorTool.combineRotations(1.0f, this));
        Vector4d worldPositionBody2 = this.transformPosition(transform, 0.0, 0.42546875, -0.090625);
        this.body2.center().set((Vector3fc)new Vector3f((float)worldPositionBody2.x, (float)worldPositionBody2.y, (float)worldPositionBody2.z));
        this.body2.setRotation(VectorTool.combineRotationsBarrel(1.0f, this));
        Matrix4d transformT = this.getTurretTransform(1.0f);
        Vector4d worldPositionYaw = this.transformPosition(transformT, 0.62625, 0.0396875, -0.5);
        this.yawController.center().set((Vector3fc)new Vector3f((float)worldPositionYaw.x, (float)worldPositionYaw.y, (float)worldPositionYaw.z));
        this.yawController.setRotation(VectorTool.combineRotationsTurret(1.0f, this));
        Vector4d worldPositionPitch = this.transformPosition(transformT, 0.7825, 0.5771875, -0.024375);
        this.pitchController.center().set((Vector3fc)new Vector3f((float)worldPositionPitch.x, (float)worldPositionPitch.y, (float)worldPositionPitch.z));
        this.pitchController.setRotation(VectorTool.combineRotationsTurret(1.0f, this));
        Matrix4d transformB = this.getBarrelTransform(1.0f);
        double i = 0.24375f;
        this.setBarrelOBB(0, -0.3659375, 0.244375);
        this.setBarrelOBB(1, -0.3659375 + i, 0.244375);
        this.setBarrelOBB(2, -0.3659375 + 2.0 * i, 0.244375);
        this.setBarrelOBB(3, -0.3659375 + 3.0 * i, 0.244375);
        this.setBarrelOBB(4, -0.3659375, 0.244375 - i);
        this.setBarrelOBB(5, -0.3659375 + i, 0.244375 - i);
        this.setBarrelOBB(6, -0.3659375 + 2.0 * i, 0.244375 - i);
        this.setBarrelOBB(7, -0.3659375 + 3.0 * i, 0.244375 - i);
        this.setBarrelOBB(8, -0.3659375, 0.244375 - 2.0 * i);
        this.setBarrelOBB(9, -0.3659375 + i, 0.244375 - 2.0 * i);
        this.setBarrelOBB(10, -0.3659375 + 2.0 * i, 0.244375 - 2.0 * i);
        this.setBarrelOBB(11, -0.3659375 + 3.0 * i, 0.244375 - 2.0 * i);
        Vector4d worldPositionBody1 = this.transformPosition(transformB, 0.0, 0.0, 0.3740625);
        this.body1.center().set((Vector3fc)new Vector3f((float)worldPositionBody1.x, (float)worldPositionBody1.y, (float)worldPositionBody1.z));
        this.body1.setRotation(VectorTool.combineRotationsBarrel(1.0f, this));
    }

    private void setBarrelOBB(int index, double x, double y) {
        Vector4d vec = this.transformPosition(this.getBarrelTransform(1.0f), x, y, -0.44625);
        this.barrel[index].center().set((Vector3fc)new Vector3f((float)vec.x, (float)vec.y, (float)vec.z));
        this.barrel[index].setRotation(VectorTool.combineRotationsBarrel(1.0f, this));
    }

    @Override
    public void setChanged() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (ItemStack item : this.items) {
            Item item2 = item.getItem();
            if (item2 instanceof MediumRocketItem) {
                MediumRocketItem mediumRocketItem = (MediumRocketItem)item2;
                list.add(mediumRocketItem.type.ordinal());
                continue;
            }
            list.add(-1);
        }
        this.entityData.set(LOADED_AMMO, list);
    }
}

