/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.SeekInfo;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectile;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.world.TDMSavedData;
import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class AutoAimableEntity
extends GeoVehicleEntity
implements OwnableEntity {
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(AutoAimableEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(AutoAimableEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.defineId(AutoAimableEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public int changeTargetTimer;

    public AutoAimableEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (player.isCrouching()) {
            if (stack.is(ModTags.Items.TOOLS_CROWBAR) && (this.getOwner() == null || player == this.getOwner())) {
                ItemStack container = ContainerBlockItem.createInstance(this);
                if (!player.addItem(container)) {
                    player.drop(container, false);
                }
                this.remove(Entity.RemovalReason.DISCARDED);
                this.discard();
                return InteractionResult.SUCCESS;
            }
            if (this.getOwnerUUID() == null) {
                this.setOwnerUUID(player.getUUID());
            }
            if (this.getOwner() == player) {
                this.entityData.set(ACTIVE, (Object)((Boolean)this.entityData.get(ACTIVE) == false ? 1 : 0));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            return InteractionResult.PASS;
        }
        this.entityData.set(TARGET_UUID, (Object)"none");
        return super.interact(player, hand);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TARGET_UUID, (Object)"none").define(OWNER_UUID, Optional.empty()).define(ACTIVE, (Object)false);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Active", ((Boolean)this.entityData.get(ACTIVE)).booleanValue());
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        UUID uuid;
        super.readAdditionalSaveData(compound);
        this.entityData.set(ACTIVE, (Object)compound.getBoolean("Active"));
        if (compound.hasUUID("Owner")) {
            uuid = compound.getUUID("Owner");
        } else {
            String s = compound.getString("Owner");
            try {
                uuid = this.getServer() == null ? UUID.fromString(s) : OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void baseTick() {
        super.baseTick();
        this.autoAim();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void autoAim() {
        int changeTargetTime;
        block16: {
            block15: {
                block17: {
                    LivingEntity living;
                    LivingEntity livingEntity;
                    Entity target;
                    Entity nearestEntity;
                    if (this.getFirstPassenger() != null || !((Boolean)this.entityData.get(ACTIVE)).booleanValue()) {
                        return;
                    }
                    String weaponName = "Main";
                    GunData data = this.getGunData(weaponName);
                    if (data == null) {
                        return;
                    }
                    SeekInfo seekInfo = this.data().compute().seekInfo;
                    if (seekInfo == null) {
                        return;
                    }
                    double maxSeekRange = seekInfo.maxSeekRange;
                    double minSeekRange = seekInfo.minSeekRange;
                    changeTargetTime = seekInfo.changeTargetTime;
                    int seekIterative = Math.max((int)1, (int)seekInfo.seekIterative);
                    double minTargetSize = seekInfo.minTargetSize;
                    if (this.getEnergy() < seekInfo.seekEnergyCost) {
                        return;
                    }
                    ProjectileInfo projectileInfo = data.compute().projectile();
                    String projectileType = projectileInfo.type;
                    String projectileTypeStr = projectileType.trim().toLowerCase(Locale.ROOT);
                    int rpm = (int)Math.ceil((float)(20.0f / ((float)this.vehicleWeaponRpm(weaponName) / 60.0f)));
                    if (projectileTypeStr.equals("ray") && ((Float)this.entityData.get(CHARGE_PROGRESS)).floatValue() < 1.0f && this.getEnergy() > data.compute().ammoCostPerShoot) {
                        float chargeSpeed = 1.0f / (float)rpm;
                        this.entityData.set(CHARGE_PROGRESS, (Object)Float.valueOf(Mth.clamp((float)(((Float)this.entityData.get(CHARGE_PROGRESS)).floatValue() + chargeSpeed), (float)0.0f, (float)1.0f)));
                    }
                    Vec3 barrelRootPos = this.getShootPos(weaponName, 1.0f);
                    if (((String)this.entityData.get(TARGET_UUID)).equals("none") && this.tickCount % seekIterative == 0 && (nearestEntity = this.seekNearLivingEntity(barrelRootPos, this.getTurretMinPitch(), this.getTurretMaxPitch(), minSeekRange, maxSeekRange, minTargetSize)) != null) {
                        this.entityData.set(TARGET_UUID, (Object)nearestEntity.getStringUUID());
                        this.consumeEnergy(seekInfo.seekEnergyCost);
                    }
                    if ((target = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(TARGET_UUID))) == null || !((livingEntity = this.getOwner()) instanceof Player)) break block15;
                    Player player = (Player)livingEntity;
                    if (!SeekTool.NOT_IN_SMOKE.test(target)) break block15;
                    if (SeekTool.IS_INVULNERABLE.test(target) || VehicleVecUtils.getSubmergedHeight(target) >= (double)target.getBbHeight() || (double)target.distanceTo((Entity)this) > maxSeekRange || (double)target.distanceTo((Entity)this) < minSeekRange || target instanceof LivingEntity && (living = (LivingEntity)target).getHealth() <= 0.0f || target == this || target instanceof TargetEntity || target.isInWater() || target instanceof Projectile && (target.onGround() || target.getDeltaMovement().lengthSqr() < 0.001)) {
                        this.entityData.set(TARGET_UUID, (Object)"none");
                        return;
                    }
                    if (target.getVehicle() != null) {
                        this.entityData.set(TARGET_UUID, (Object)target.getVehicle().getStringUUID());
                    }
                    if (!target.isAlive()) {
                        this.entityData.set(TARGET_UUID, (Object)"none");
                    }
                    Vec3 targetPos = target.getBoundingBox().getCenter();
                    Vec3 targetVel = target.getDeltaMovement();
                    Vec3 targetVec = projectileTypeStr.equals("ray") ? barrelRootPos.vectorTo(targetPos).normalize() : RangeTool.calculateFiringSolution(barrelRootPos, targetPos, targetVel.scale(1.1 + (double)(this.random.nextFloat() * 0.2f)), this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName));
                    if (((Float)this.entityData.get(LASER_SCALE)).floatValue() != 0.0f) break block16;
                    this.turretAutoAimFromVector(targetVec);
                    if (!(VectorTool.calculateAngle(this.getShootVec(weaponName, 1.0f), targetVec) < 1.0)) break block16;
                    if (!this.checkNoClip(target, barrelRootPos) || data.overHeat.get()) break block17;
                    if (projectileTypeStr.equals("ray") && ((Float)this.getEntityData().get(CHARGE_PROGRESS)).floatValue() == 1.0f) {
                        if (player.level() instanceof ServerLevel) {
                            this.rayShoot((LivingEntity)player, target, data);
                        }
                        this.changeTargetTimer = 0;
                        break block16;
                    } else if (this.getAmmoCount(weaponName) > 0 && this.tickCount % rpm == 0) {
                        if (player.level() instanceof ServerLevel) {
                            this.vehicleShoot((LivingEntity)player, "Main");
                        }
                        this.changeTargetTimer = 0;
                    }
                    break block16;
                }
                ++this.changeTargetTimer;
                break block16;
            }
            this.entityData.set(TARGET_UUID, (Object)"none");
        }
        if (this.changeTargetTimer > changeTargetTime) {
            this.entityData.set(TARGET_UUID, (Object)"none");
            this.changeTargetTimer = 0;
        }
    }

    public boolean basicEnemyFilter(Entity pEntity) {
        if (pEntity instanceof Projectile) {
            return false;
        }
        if (this.getOwner() == null) {
            return false;
        }
        if (pEntity.getTeam() == null) {
            return false;
        }
        return !pEntity.isAlliedTo((Entity)this.getOwner()) || pEntity.getTeam() != null && TDMSavedData.enabledTDM(pEntity);
    }

    public boolean basicEnemyProjectileFilter(Projectile projectile) {
        if (this.getOwner() == null) {
            return false;
        }
        if (projectile.getOwner() != null && projectile.getOwner() == this.getOwner()) {
            return false;
        }
        return projectile.getOwner() != null && !projectile.getOwner().isAlliedTo((Entity)this.getOwner()) || projectile.getOwner() != null && projectile.getOwner().getTeam() != null && TDMSavedData.enabledTDM(projectile.getOwner()) || projectile.getOwner() == null;
    }

    public Entity seekNearLivingEntity(Vec3 pos, double minAngle, double maxAngle, double minRange, double seekRange, double size) {
        for (Entity target : this.level().getEntitiesOfClass(Entity.class, new AABB(pos, pos).inflate(seekRange), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(pos))).toList()) {
            LivingEntity living;
            Player player;
            boolean condition = target.distanceToSqr((Entity)this) > minRange * minRange && target.distanceToSqr((Entity)this) <= seekRange * seekRange && AutoAimableEntity.canAim(pos, target, minAngle, maxAngle) && VehicleVecUtils.getSubmergedHeight(target) <= (double)target.getBbHeight() && this.checkNoClip(target, pos) && (!(target instanceof Player) || !(player = (Player)target).isSpectator() && !player.isCreative()) && (target instanceof LivingEntity && (living = (LivingEntity)target) instanceof Enemy && living.getHealth() > 0.0f || this.isThreateningEntity(target, size, pos) || this.basicEnemyFilter(target)) && SeekTool.NOT_IN_SMOKE.test(target) && !SeekTool.IN_BLACKLIST.test(target);
            if (!condition) continue;
            return target;
        }
        return null;
    }

    public boolean isThreateningEntity(Entity target, double size, Vec3 pos) {
        if (target instanceof SmallCannonShellEntity) {
            return false;
        }
        if (!target.onGround() && target instanceof Projectile) {
            Projectile projectile = (Projectile)target;
            if ((double)target.getBbWidth() >= size || (double)target.getBbHeight() >= size) {
                return this.checkNoClip(target, pos) && this.basicEnemyProjectileFilter(projectile);
            }
        }
        return false;
    }

    public boolean checkNoClip(Entity target, Vec3 pos) {
        return this.level().clip(new ClipContext(pos, target.getBoundingBox().getCenter(), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this)).getType() != HitResult.Type.BLOCK;
    }

    public static boolean canAim(Vec3 pos, Entity target, double minAngle, double maxAngle) {
        Vec3 targetPos = target.getBoundingBox().getCenter();
        Vec3 toVec = pos.vectorTo(targetPos).normalize();
        double targetAngle = VehicleVecUtils.getXRotFromVector(toVec);
        return minAngle < targetAngle && targetAngle < maxAngle;
    }

    public void rayShoot(LivingEntity living, Entity target, GunData gunData) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, target.getX(), target.getEyeY(), target.getZ(), 12, 0.0, 0.0, 0.0, 0.05, true);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, target.getX(), target.getEyeY(), target.getZ(), 4, 0.0, 0.0, 0.0, 0.15, true);
        }
        Vec3 pos = target.getBoundingBox().getCenter();
        this.entityData.set(LASER_LENGTH, (Object)Float.valueOf((float)this.getShootPos("Main", 1.0f).distanceTo(pos)));
        DamageHandler.doDamage(target, ModDamageTypes.causeLaserStaticDamage(this.level().registryAccess(), this, (Entity)living), (float)gunData.compute().damage);
        target.invulnerableTime = 0;
        if (gunData.compute().explosionRadius > 0.0) {
            this.causeLaserExplode(pos, gunData, (Entity)living);
        }
        if (Math.random() < 0.25 && target instanceof LivingEntity) {
            LivingEntity pLiving = (LivingEntity)target;
            pLiving.setRemainingFireTicks(40);
        }
        if (target instanceof Projectile && !(target instanceof DestroyableProjectile)) {
            this.causeAirExplode(pos);
            target.discard();
        }
        if (!target.isAlive()) {
            this.entityData.set(TARGET_UUID, (Object)"none");
        }
        this.entityData.set(LASER_SCALE, (Object)Float.valueOf(gunData.compute().shootAnimationTime));
        this.entityData.set(CHARGE_PROGRESS, (Object)Float.valueOf(0.0f));
        this.playShootSound3p(living, "Main");
        this.consumeEnergy(gunData.compute().ammoCostPerShoot);
    }

    private void causeLaserExplode(Vec3 vec3, GunData gunData, Entity living) {
        float radius = (float)gunData.compute().explosionRadius;
        ParticleTool.ParticleType particleType = radius <= 4.0f ? ParticleTool.ParticleType.SMALL : (radius > 4.0f && radius < 10.0f ? ParticleTool.ParticleType.MEDIUM : (radius >= 10.0f && radius < 20.0f ? ParticleTool.ParticleType.HUGE : ParticleTool.ParticleType.GIANT));
        this.createCustomExplosion().damage((float)gunData.compute().explosionDamage).radius(radius).attacker(living).position(vec3).withParticleType(particleType).explode();
    }

    private void causeAirExplode(Vec3 vec3) {
        this.createCustomExplosion().damage(5.0f).radius(1.0f).keepBlock().attacker((Entity)this.getOwner()).position(vec3).withParticleType(ParticleTool.ParticleType.MEDIUM).explode();
    }
}

