/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.damage;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.DeserializeFromString;
import com.google.gson.annotations.SerializedName;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class DamageModify
implements DeserializeFromString {
    private static final Pattern MODIFY_PATTERN = Pattern.compile("^(?<prefix>(@#|#|@)?)(?<id>\\w+(:\\w+)?)\\s*(?<operator>[-*]?)\\s*(?<value>([+-]?\\d+(\\.\\d*)?)?)$");
    @SerializedName(value="Value")
    public float value = 0.0f;
    @SerializedName(value="Type")
    public ModifyType type = ModifyType.IMMUNITY;
    @SerializedName(value="Source")
    public String source = "All";
    public transient String entityId = "";
    public transient SourceType sourceType = null;
    public transient TagKey<DamageType> sourceTagKey = null;
    public transient ResourceKey<DamageType> sourceKey = null;
    public transient TagKey<EntityType<?>> entityTag = null;
    public transient Function<DamageSource, Boolean> condition = null;

    @Override
    public void deserializeFromString(String str) {
        Matcher matcher = MODIFY_PATTERN.matcher(str.trim());
        if (!matcher.matches()) {
            Mod.LOGGER.warn("invalid damage modify: {}", (Object)str);
            return;
        }
        String prefix = matcher.group("prefix").trim();
        String id = matcher.group("id").trim();
        String operator = matcher.group("operator").trim();
        String value = matcher.group("value").trim();
        this.source = prefix + id;
        this.generateSourceType();
        switch (operator) {
            case "-": {
                ModifyType modifyType = ModifyType.REDUCE;
                break;
            }
            case "*": {
                ModifyType modifyType = ModifyType.MULTIPLY;
                break;
            }
            default: {
                ModifyType modifyType = this.type = value.equals("0") ? ModifyType.IMMUNITY : ModifyType.INVALID;
            }
        }
        if (this.type == ModifyType.INVALID) {
            Mod.LOGGER.warn("invalid damage modify: {}", (Object)str);
            return;
        }
        this.value = value.isEmpty() ? 0.0f : Float.parseFloat(value);
    }

    public DamageModify() {
    }

    public DamageModify(ModifyType type, float value) {
        this.type = type;
        this.value = value;
        this.sourceType = SourceType.ALL;
    }

    public DamageModify(ModifyType type, float value, TagKey<DamageType> sourceTagKey) {
        this.type = type;
        this.value = value;
        this.sourceTagKey = sourceTagKey;
        this.sourceType = SourceType.TAG_KEY;
    }

    public DamageModify(ModifyType type, float value, ResourceKey<DamageType> sourceKey) {
        this.type = type;
        this.value = value;
        this.sourceKey = sourceKey;
        this.sourceType = SourceType.RESOURCE_KEY;
    }

    public DamageModify(ModifyType type, float value, Function<DamageSource, Boolean> condition) {
        this.type = type;
        this.value = value;
        this.condition = condition;
        this.sourceType = SourceType.FUNCTION;
    }

    public DamageModify(ModifyType type, float value, String entityId) {
        this.type = type;
        this.value = value;
        this.entityId = entityId;
        this.sourceType = SourceType.ENTITY_ID;
    }

    private void generateSourceType() {
        if (this.source.startsWith("#")) {
            this.sourceType = SourceType.TAG_KEY;
            this.sourceTagKey = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)this.source.substring(1)));
        } else if (this.source.startsWith("@#")) {
            this.sourceType = SourceType.ENTITY_TAG;
            this.entityTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)this.source.substring(2)));
        } else if (this.source.startsWith("@")) {
            this.sourceType = SourceType.ENTITY_ID;
            this.entityId = this.source.substring(1);
        } else if (!this.source.equals("All")) {
            this.sourceType = SourceType.RESOURCE_KEY;
            this.sourceKey = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)this.source));
        } else {
            this.sourceType = SourceType.ALL;
        }
    }

    public boolean match(DamageSource source) {
        if (source == null) {
            return false;
        }
        if (this.sourceType == null) {
            this.generateSourceType();
        }
        return switch (this.sourceType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this.sourceTagKey == null) {
                    yield false;
                }
                yield source.is(this.sourceTagKey);
            }
            case 1 -> {
                if (this.sourceKey == null) {
                    yield false;
                }
                yield source.is(this.sourceKey);
            }
            case 2 -> this.condition.apply(source);
            case 3 -> {
                Entity directEntity = source.getDirectEntity();
                Entity entity = source.getEntity();
                if (directEntity != null) {
                    yield EntityType.getKey((EntityType)directEntity.getType()).toString().equals(this.entityId);
                }
                if (entity != null) {
                    yield EntityType.getKey((EntityType)entity.getType()).toString().equals(this.entityId);
                }
                yield false;
            }
            case 4 -> {
                Entity directEntity = source.getDirectEntity();
                if (directEntity == null) {
                    yield false;
                }
                if (this.entityTag == null) {
                    yield false;
                }
                yield directEntity.getType().is(this.entityTag);
            }
            case 5 -> true;
        };
    }

    public float compute(float damage) {
        if (this.type == null) {
            return 0.0f;
        }
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0.0f;
            case 1 -> Math.max(damage - this.value, 0.0f);
            case 2 -> damage * this.value;
            case 3 -> damage;
        };
    }

    public static enum ModifyType {
        IMMUNITY,
        REDUCE,
        MULTIPLY,
        INVALID;

    }

    public static enum SourceType {
        TAG_KEY,
        RESOURCE_KEY,
        FUNCTION,
        ENTITY_ID,
        ENTITY_TAG,
        ALL;

    }
}

