/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.utils;

import com.atsuishio.superbwarfare.data.StringOrVec3;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.vehicle.subdata.CameraPos;
import com.atsuishio.superbwarfare.data.vehicle.subdata.SeatInfo;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4d;

public final class VehicleVecUtils {
    public static double bombHitPosX;
    public static double bombHitPosY;
    public static double bombHitPosZ;

    public static Vector4d transformPosition(Matrix4d transform, double x, double y, double z) {
        return transform.transform(new Vector4d(x, y, z, 1.0));
    }

    public static double getYRotFromVector(Vec3 vec3) {
        return Mth.atan2((double)vec3.x, (double)vec3.z) * 57.29577951308232;
    }

    public static double getXRotFromVector(Vec3 vec3) {
        double d0 = vec3.horizontalDistance();
        return Mth.atan2((double)vec3.y, (double)d0) * 57.29577951308232;
    }

    public static double getSubmergedHeight(Entity entity) {
        return entity.getFluidTypeHeight(entity.level().getFluidState(entity.blockPosition()).getFluidType());
    }

    public static Quaternionf eulerToQuaternion(float yaw, float pitch, float roll) {
        double cy = Math.cos((double)((double)yaw * 0.5 * 0.01745329238474369));
        double sy = Math.sin((double)((double)yaw * 0.5 * 0.01745329238474369));
        double cp = Math.cos((double)((double)pitch * 0.5 * 0.01745329238474369));
        double sp = Math.sin((double)((double)pitch * 0.5 * 0.01745329238474369));
        double cr = Math.cos((double)((double)roll * 0.5 * 0.01745329238474369));
        double sr = Math.sin((double)((double)roll * 0.5 * 0.01745329238474369));
        Quaternionf q = new Quaternionf();
        q.w = (float)(cy * cp * cr + sy * sp * sr);
        q.x = (float)(cy * cp * sr - sy * sp * cr);
        q.y = (float)(sy * cp * sr + cy * sp * cr);
        q.z = (float)(sy * cp * cr - cy * sp * sr);
        return q;
    }

    public static double calculateAngle(Vec3 move, Vec3 view) {
        move = move.multiply(1.0, 0.0, 1.0).normalize();
        view = view.multiply(1.0, 0.0, 1.0).normalize();
        return VectorTool.calculateAngle(move, view);
    }

    public static Vec3 entityEyePos(Entity entity, float partialTicks) {
        return new Vec3(Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX()), Mth.lerp((double)partialTicks, (double)(entity.yo + (double)entity.getEyeHeight()), (double)entity.getEyeY()), Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ()));
    }

    public static Vec3 simulate3P(Entity entity, float partialTicks, double distance, double height) {
        return new Vec3(Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX()) - distance * entity.getViewVector((float)partialTicks).x, Mth.lerp((double)partialTicks, (double)(entity.yo + (double)entity.getEyeHeight() + height), (double)(entity.getEyeY() + height)) - distance * entity.getViewVector((float)partialTicks).y, Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ()) - distance * entity.getViewVector((float)partialTicks).z);
    }

    public static void setDriverAngle(VehicleEntity vehicle, Player player) {
        if (vehicle.hasTurret()) {
            Vec3 barrelVector = vehicle.getBarrelVector(1.0f);
            double xRot = VehicleVecUtils.getXRotFromVector(barrelVector);
            double yRot = VehicleVecUtils.getYRotFromVector(barrelVector);
            player.xRotO = (float)(-xRot);
            player.setXRot((float)(-xRot));
            player.yRotO = (float)(-yRot);
            player.setYRot((float)(-yRot));
            player.setYHeadRot((float)(-yRot));
        } else {
            player.xRotO = vehicle.getXRot();
            player.setXRot(vehicle.getXRot());
            player.yRotO = vehicle.getYRot();
            player.setYRot(vehicle.getYRot());
        }
    }

    public static float getDamageSourceAngle(VehicleEntity vehicle, DamageSource source, float multiplier) {
        Entity attacker = source.getDirectEntity();
        if (attacker == null) {
            attacker = source.getEntity();
        }
        if (attacker != null) {
            Vec3 toVec = new Vec3(vehicle.getX(), vehicle.getY() + (double)(vehicle.getBbHeight() / 2.0f), vehicle.getZ()).vectorTo(attacker.position()).normalize();
            return (float)Math.max((double)(1.0 - (double)multiplier * toVec.dot(vehicle.getViewVector(1.0f))), (double)0.5);
        }
        return 1.0f;
    }

    public static void setPassengerPitch(VehicleEntity vehicle, Entity entity, float minPitch, float maxPitch, float passengerRot) {
        if (passengerRot == 180.0f) {
            float min = minPitch + vehicle.getXRot();
            float max = maxPitch + vehicle.getXRot();
            float f = Mth.wrapDegrees((float)entity.getXRot());
            float f1 = Mth.clamp((float)f, (float)min, (float)max);
            entity.xRotO += f1 - f;
            entity.setXRot(entity.getXRot() + f1 - f);
        } else {
            float a = -passengerRot;
            float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -maxPitch - r * vehicle.getXRot() - r2 * vehicle.getRoll();
            float max = -minPitch - r * vehicle.getXRot() - r2 * vehicle.getRoll();
            float f = Mth.wrapDegrees((float)entity.getXRot());
            float f1 = Mth.clamp((float)f, (float)min, (float)max);
            entity.xRotO += f1 - f;
            entity.setXRot(entity.getXRot() + f1 - f);
        }
    }

    public static void setPassengerYaw(VehicleEntity vehicle, Entity entity, float minYaw, float maxYaw, float passengerRot) {
        if (passengerRot == 180.0f) {
            float f2 = Mth.wrapDegrees((float)(entity.getYRot() - vehicle.getYRot() + passengerRot));
            float f3 = Mth.clamp((float)f2, (float)minYaw, (float)maxYaw);
            entity.yRotO += f3 - f2;
            entity.setYRot(entity.getYRot() + f3 - f2);
        } else {
            float f2 = Mth.wrapDegrees((float)(entity.getYRot() - vehicle.getYRot()));
            float f3 = Mth.clamp((float)f2, (float)(passengerRot + minYaw), (float)(passengerRot + maxYaw));
            entity.yRotO += f3 - f2;
            entity.setYRot(entity.getYRot() + f3 - f2);
        }
        entity.setYBodyRot(vehicle.getYRot() + passengerRot);
    }

    public static void setPassengerPitchOnTurret(VehicleEntity vehicle, Entity entity, float turretMinPitch, float turretMaxPitch) {
        float a = vehicle.getTurretYaw(1.0f);
        float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float min = -turretMaxPitch - r * vehicle.getXRot() - r2 * vehicle.getRoll();
        float max = -turretMinPitch - r * vehicle.getXRot() - r2 * vehicle.getRoll();
        float f = Mth.wrapDegrees((float)entity.getXRot());
        float f1 = Mth.clamp((float)f, (float)min, (float)max);
        entity.xRotO += f1 - f;
        entity.setXRot(entity.getXRot() + f1 - f);
    }

    public static void setPassengerYawOnTurret(VehicleEntity vehicle, Entity entity, float minYaw, float maxYaw, float passengerRot, boolean rotateWithTurret) {
        if (passengerRot != 180.0f) {
            float f2 = Mth.wrapDegrees((float)(entity.getYRot() - vehicle.getYRot()));
            float f3 = Mth.clamp((float)f2, (float)(passengerRot + minYaw), (float)(passengerRot + maxYaw));
            entity.yRotO += f3 - f2;
            entity.setYRot(entity.getYRot() + f3 - f2);
        } else {
            float f2 = Mth.wrapDegrees((float)(entity.getYRot() - vehicle.getYRot() + 180.0f));
            float f3 = Mth.clamp((float)f2, (float)minYaw, (float)maxYaw);
            entity.yRotO += f3 - f2;
            entity.setYRot(entity.getYRot() + f3 - f2);
        }
        if (rotateWithTurret) {
            entity.setYBodyRot(vehicle.getBarrelYRot(1.0f) + passengerRot);
        }
        VehicleVecUtils.clampZoomYaw(vehicle, entity);
    }

    public static void clampZoomYaw(VehicleEntity vehicle, Entity entity) {
        if (!entity.level().isClientSide) {
            return;
        }
        if (Minecraft.getInstance().options.getCameraType() != CameraType.FIRST_PERSON) {
            return;
        }
        if (vehicle.getTurretControllerIndex() == vehicle.getSeatIndex(entity)) {
            float f2 = Mth.wrapDegrees((float)(entity.getYRot() - vehicle.getBarrelYRot(1.0f)));
            float f3 = Mth.clamp((float)f2, (float)-20.0f, (float)20.0f);
            entity.yRotO += f3 - f2;
            entity.setYRot(entity.getYRot() + f3 - f2);
        }
    }

    public static Vec3 getViewVec(VehicleEntity vehicle, Entity entity, float partialTicks) {
        GunData data = vehicle.getGunData(vehicle.getSeatIndex(entity));
        if (data == null) {
            return vehicle.getViewVector(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.compute().shootPos.viewDirection;
        if (stringOrVec3 == null) {
            return vehicle.getShootVec(entity, partialTicks);
        }
        if (stringOrVec3.isString()) {
            if (stringOrVec3.string.equals("Bomb")) {
                bombHitPosX = Mth.lerp((double)(0.1 * (double)partialTicks), (double)bombHitPosX, (double)vehicle.bombHitPos((Entity)entity).x);
                bombHitPosY = Mth.lerp((double)(0.1 * (double)partialTicks), (double)bombHitPosY, (double)vehicle.bombHitPos((Entity)entity).y);
                bombHitPosZ = Mth.lerp((double)(0.1 * (double)partialTicks), (double)bombHitPosZ, (double)vehicle.bombHitPos((Entity)entity).z);
                return VehicleVecUtils.getViewPos(vehicle, entity, partialTicks).vectorTo(new Vec3(bombHitPosX, bombHitPosY, bombHitPosZ));
            }
            return vehicle.getVectorFromString(stringOrVec3.string, partialTicks, vehicle.getSeatIndex(entity));
        }
        Vec3 vec3 = stringOrVec3.vec3;
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.x + stringOrVec3.vec3.x, vec3.y + stringOrVec3.vec3.y, vec3.z + stringOrVec3.vec3.z);
        Vector4d worldPositionO = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.x, vec3.y, vec3.z);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.vectorTo(endPos).normalize();
    }

    public static Vec3 getViewPos(VehicleEntity vehicle, Entity entity, float partialTicks) {
        GunData data = vehicle.getGunData(vehicle.getSeatIndex(entity));
        if (data == null) {
            return VehicleVecUtils.entityEyePos(entity, partialTicks);
        }
        Vec3 vec3 = data.compute().shootPos.viewPosition;
        if (vec3 == null) {
            return vehicle.getCameraPos(entity, partialTicks);
        }
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.x, vec3.y, vec3.z);
        return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
    }

    public static Vec3 getSeekVec(VehicleEntity vehicle, Entity entity, float partialTicks) {
        GunData data = vehicle.getGunData(vehicle.getSeatIndex(entity));
        if (data == null) {
            return vehicle.getViewVector(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.compute().seekWeaponInfo.seekDirection;
        if (stringOrVec3 == null) {
            return vehicle.getShootVec(entity, partialTicks);
        }
        if (stringOrVec3.isString()) {
            return vehicle.getVectorFromString(stringOrVec3.string, partialTicks, vehicle.getSeatIndex(entity));
        }
        Vec3 vec3 = stringOrVec3.vec3;
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.x + stringOrVec3.vec3.x, vec3.y + stringOrVec3.vec3.y, vec3.z + stringOrVec3.vec3.z);
        Vector4d worldPositionO = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.x, vec3.y, vec3.z);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.vectorTo(endPos).normalize();
    }

    public static Vec3 getShootVec(VehicleEntity vehicle, Entity entity, float partialTicks) {
        GunData data = vehicle.getGunData(vehicle.getSeatIndex(entity));
        if (data == null) {
            return vehicle.getViewVector(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.fireDirection();
        if (stringOrVec3.isString()) {
            return vehicle.getVectorFromString(stringOrVec3.string, partialTicks, vehicle.getSeatIndex(entity));
        }
        Vec3 vec3 = data.firePosition();
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.x + stringOrVec3.vec3.x, vec3.y + stringOrVec3.vec3.y, vec3.z + stringOrVec3.vec3.z);
        Vector4d worldPositionO = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.x, vec3.y, vec3.z);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.vectorTo(endPos).normalize();
    }

    public static Vec3 getShootVec(VehicleEntity vehicle, String weaponName, float partialTicks) {
        GunData data = vehicle.getGunData(weaponName);
        if (data == null) {
            return vehicle.getViewVector(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.fireDirection();
        if (stringOrVec3.isString()) {
            return vehicle.getVectorFromString(stringOrVec3.string, partialTicks);
        }
        Vec3 vec3 = data.firePosition();
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.x + stringOrVec3.vec3.x, vec3.y + stringOrVec3.vec3.y, vec3.z + stringOrVec3.vec3.z);
        Vector4d worldPositionO = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.x, vec3.y, vec3.z);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.vectorTo(endPos).normalize();
    }

    public static Vec3 getCameraPos(VehicleEntity vehicle, Entity entity, float partialTicks) {
        int index = vehicle.getSeatIndex(entity);
        SeatInfo seat = vehicle.computed().seats().get(index);
        if (seat == null) {
            return VehicleVecUtils.entityEyePos(entity, partialTicks);
        }
        CameraPos data = seat.cameraPos;
        if (data == null) {
            return VehicleVecUtils.entityEyePos(entity, partialTicks);
        }
        if (data.useSimulate3P.booleanValue()) {
            Vec2 simulate3PPos = data.simulate3PPos;
            return VehicleVecUtils.simulate3P(entity, partialTicks, simulate3PPos.x, simulate3PPos.y);
        }
        if (data.useFixedCameraPos.booleanValue()) {
            Vec3 vec3 = data.position;
            Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.transform, partialTicks), vec3.x, vec3.y, vec3.z);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return VehicleVecUtils.entityEyePos(entity, partialTicks);
    }

    public static Vec3 getCameraDirection(VehicleEntity vehicle, Entity entity, float partialTicks) {
        int index = vehicle.getSeatIndex(entity);
        SeatInfo seat = vehicle.computed().seats().get(index);
        if (seat == null) {
            return entity.getViewVector(partialTicks);
        }
        CameraPos data = seat.cameraPos;
        if (data == null) {
            return entity.getViewVector(partialTicks);
        }
        if (data.useSimulate3P.booleanValue()) {
            return entity.getViewVector(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.direction;
        if (stringOrVec3.isString()) {
            if (stringOrVec3.string.equals("Default")) {
                if (VehicleVecUtils.getZoomDirection(vehicle, entity, partialTicks) != null && ClientEventHandler.zoomVehicle) {
                    return vehicle.getZoomDirection(entity, partialTicks);
                }
                return entity.getViewVector(partialTicks);
            }
            return vehicle.getVectorFromString(stringOrVec3.string, partialTicks, vehicle.getSeatIndex(entity));
        }
        Vec3 vec3 = data.position;
        Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.transform, partialTicks), vec3.x + stringOrVec3.vec3.x, vec3.y + stringOrVec3.vec3.y, vec3.z + stringOrVec3.vec3.z);
        Vec3 startPos = VehicleVecUtils.getCameraPos(vehicle, entity, partialTicks);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.vectorTo(endPos).normalize();
    }

    public static Vec3 getZoomPos(VehicleEntity vehicle, Entity entity, float partialTicks) {
        int index = vehicle.getSeatIndex(entity);
        SeatInfo seat = vehicle.computed().seats().get(index);
        if (seat == null) {
            return VehicleVecUtils.entityEyePos(entity, partialTicks);
        }
        CameraPos data = seat.cameraPos;
        if (data == null) {
            return VehicleVecUtils.entityEyePos(entity, partialTicks);
        }
        Vec3 vec3 = data.zoomPosition;
        if (vec3 != null) {
            Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.transform, partialTicks), vec3.x, vec3.y, vec3.z);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return VehicleVecUtils.getCameraPos(vehicle, entity, partialTicks);
    }

    public static Vec3 getZoomDirection(VehicleEntity vehicle, Entity entity, float partialTicks) {
        int index = vehicle.getSeatIndex(entity);
        SeatInfo seat = vehicle.computed().seats().get(index);
        if (seat == null) {
            return entity.getViewVector(partialTicks);
        }
        CameraPos data = seat.cameraPos;
        if (data == null) {
            return entity.getViewVector(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.zoomDirection;
        if (stringOrVec3 != null) {
            if (stringOrVec3.isString()) {
                return vehicle.getVectorFromString(stringOrVec3.string, partialTicks, vehicle.getSeatIndex(entity));
            }
            Vec3 vec3 = data.zoomPosition;
            Vector4d worldPosition = VehicleVecUtils.transformPosition(vehicle.getTransformFromString(data.transform, partialTicks), vec3.x + stringOrVec3.vec3.x, vec3.y + stringOrVec3.vec3.y, vec3.z + stringOrVec3.vec3.z);
            Vec3 startPos = vehicle.getShootPos(entity, partialTicks);
            Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
            return startPos.vectorTo(endPos).normalize();
        }
        return null;
    }

    public static Matrix4d getVehicleYOffsetTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = new Matrix4d();
        transform.translate(Mth.lerp((double)partialTicks, (double)vehicle.xo, (double)vehicle.getX()), Mth.lerp((double)partialTicks, (double)(vehicle.yo + vehicle.getRotateOffsetHeight()), (double)(vehicle.getY() + vehicle.getRotateOffsetHeight())), Mth.lerp((double)partialTicks, (double)vehicle.zo, (double)vehicle.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.lerp((float)partialTicks, (float)vehicle.yRotO, (float)vehicle.getYRot())));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)vehicle.xRotO, (float)vehicle.getXRot())));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)vehicle.prevRoll, (float)vehicle.getRoll())));
        return transform;
    }

    public static Matrix4d getVehicleFlatTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = new Matrix4d();
        transform.translate(Mth.lerp((double)partialTicks, (double)vehicle.xo, (double)vehicle.getX()), Mth.lerp((double)partialTicks, (double)vehicle.yo, (double)vehicle.getY()), Mth.lerp((double)partialTicks, (double)vehicle.zo, (double)vehicle.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.lerp((float)partialTicks, (float)vehicle.yRotO, (float)vehicle.getYRot())));
        return transform;
    }

    public static Matrix4d getClientVehicleTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = new Matrix4d();
        transform.translate(Mth.lerp((double)partialTicks, (double)vehicle.xo, (double)vehicle.getX()), Mth.lerp((double)partialTicks, (double)(vehicle.yo + vehicle.getRotateOffsetHeight()), (double)(vehicle.getY() + vehicle.getRotateOffsetHeight())), Mth.lerp((double)partialTicks, (double)vehicle.zo, (double)vehicle.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees((float)((double)(-Mth.lerp((float)partialTicks, (float)vehicle.yRotO, (float)vehicle.getYRot())) + ClientMouseHandler.freeCameraYaw)));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees((float)((double)Mth.lerp((float)partialTicks, (float)vehicle.xRotO, (float)vehicle.getXRot()) + ClientMouseHandler.freeCameraPitch)));
        return transform;
    }

    public static Matrix4d getTurretTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transformV = vehicle.getVehicleTransform(partialTicks);
        Matrix4d transform = new Matrix4d();
        Vec3 pos = vehicle.getTurretPos();
        if (pos == null) {
            return transformV;
        }
        Vector4d worldPosition = VehicleVecUtils.transformPosition(transform, pos.x, pos.y, pos.z);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)vehicle.turretYRotO, (float)vehicle.getTurretYRot())));
        return transformV;
    }

    public static Vec3 getTurretVector(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = VehicleVecUtils.getTurretTransform(vehicle, partialTicks);
        Vector4d rootPosition = VehicleVecUtils.transformPosition(transform, 0.0, 0.0, 0.0);
        Vector4d targetPosition = VehicleVecUtils.transformPosition(transform, 0.0, 0.0, 1.0);
        return new Vec3(rootPosition.x, rootPosition.y, rootPosition.z).vectorTo(new Vec3(targetPosition.x, targetPosition.y, targetPosition.z));
    }

    public static Matrix4d getBarrelTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transformT = VehicleVecUtils.getTurretTransform(vehicle, partialTicks);
        Matrix4d transform = new Matrix4d();
        Vec3 pos = vehicle.getBarrelPosition();
        Vector4d worldPosition = VehicleVecUtils.transformPosition(transform, pos.x, pos.y, pos.z);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = vehicle.getTurretYaw(partialTicks);
        float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.lerp((float)partialTicks, (float)vehicle.turretXRotO, (float)vehicle.getTurretXRot());
        float xV = Mth.lerp((float)partialTicks, (float)vehicle.xRotO, (float)vehicle.getXRot());
        float z = Mth.lerp((float)partialTicks, (float)vehicle.prevRoll, (float)vehicle.getRoll());
        transformT.rotate((Quaternionfc)Axis.XP.rotationDegrees(x + r * xV + r2 * z));
        return transformT;
    }

    public static Matrix4d getGunTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transformT = VehicleVecUtils.getTurretTransform(vehicle, partialTicks);
        Matrix4d transform = new Matrix4d();
        Vec3 pos = vehicle.getPassengerWeaponStationPosition();
        Vector4d worldPosition = VehicleVecUtils.transformPosition(transform, pos.x, pos.y, pos.z);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformT.rotate((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)vehicle.gunYRotO, (float)vehicle.getGunYRot()) - Mth.lerp((float)partialTicks, (float)vehicle.turretYRotO, (float)vehicle.getTurretYRot())));
        return transformT;
    }

    public static Matrix4d getPassengerWeaponStationBarrelTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transformG = VehicleVecUtils.getGunTransform(vehicle, partialTicks);
        Matrix4d transform = new Matrix4d();
        Vec3 pos = vehicle.getPassengerWeaponStationBarrelPosition();
        Vector4d worldPosition = VehicleVecUtils.transformPosition(transform, pos.x, pos.y, pos.z);
        transformG.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = vehicle.getTurretYaw(partialTicks);
        float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.lerp((float)partialTicks, (float)vehicle.gunXRotO, (float)vehicle.getGunXRot());
        float xV = Mth.lerp((float)partialTicks, (float)vehicle.xRotO, (float)vehicle.getXRot());
        float z = Mth.lerp((float)partialTicks, (float)vehicle.prevRoll, (float)vehicle.getRoll());
        transformG.rotate((Quaternionfc)Axis.XP.rotationDegrees(x + r * xV + r2 * z));
        return transformG;
    }

    public static Vec3 getPassengerWeaponStationVector(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = VehicleVecUtils.getPassengerWeaponStationBarrelTransform(vehicle, partialTicks);
        Vector4d rootPosition = VehicleVecUtils.transformPosition(transform, 0.0, 0.0, 0.0);
        Vector4d targetPosition = VehicleVecUtils.transformPosition(transform, 0.0, 0.0, 1.0);
        return new Vec3(rootPosition.x, rootPosition.y, rootPosition.z).vectorTo(new Vec3(targetPosition.x, targetPosition.y, targetPosition.z));
    }
}

