/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.utils;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.projectile.FlareDecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmokeDecoyEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.RangeTool;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4d;
import org.joml.Vector4d;

public final class VehicleWeaponUtils {
    public static void adjustTurretAngle(VehicleEntity vehicle) {
        float ySpeed = vehicle.getTurretTurnYSpeed();
        float xSpeed = vehicle.getTurretTurnXSpeed();
        Entity driver = vehicle.getNthEntity(vehicle.getTurretControllerIndex());
        if (driver == null) {
            vehicle.turretYRotLock = 0.0f;
        } else {
            float turretAngle = -Mth.wrapDegrees((float)(driver.getYHeadRot() - vehicle.getYRot()));
            float diffY = Mth.wrapDegrees((float)(turretAngle - vehicle.getTurretYRot()));
            float diffX = Mth.wrapDegrees((float)(driver.getXRot() - vehicle.getTurretXRot()));
            vehicle.turretTurnSound(diffX, diffY, 0.95f);
            if (((Boolean)vehicle.getEntityData().get(VehicleEntity.TURRET_DAMAGED)).booleanValue()) {
                ySpeed *= 0.2f;
                xSpeed *= 0.2f;
            }
            float min = -ySpeed;
            float max = ySpeed;
            vehicle.setTurretXRot(Mth.clamp((float)(vehicle.getTurretXRot() + Mth.clamp((float)(0.95f * diffX), (float)(-xSpeed), (float)xSpeed)), (float)-89.5f, (float)89.5f));
            vehicle.setTurretYRot(vehicle.getTurretYRot() + Mth.clamp((float)(0.9f * diffY), (float)min, (float)max));
            vehicle.turretYRotLock = Mth.clamp((float)(0.9f * diffY), (float)min, (float)max);
        }
    }

    public static void turretAutoAimFromVector(VehicleEntity vehicle, Vec3 shootVec) {
        float ySpeed = vehicle.getTurretTurnYSpeed();
        float xSpeed = vehicle.getTurretTurnXSpeed();
        Vec3 barrelVector = vehicle.getBarrelVector(1.0f);
        float diffY = (float)Mth.wrapDegrees((double)(-VehicleVecUtils.getYRotFromVector(shootVec) + VehicleVecUtils.getYRotFromVector(barrelVector)));
        float diffX = (float)Mth.wrapDegrees((double)(-VehicleVecUtils.getXRotFromVector(shootVec) + VehicleVecUtils.getXRotFromVector(barrelVector)));
        vehicle.turretTurnSound(diffX, diffY, 0.95f);
        if (((Boolean)vehicle.getEntityData().get(VehicleEntity.TURRET_DAMAGED)).booleanValue()) {
            ySpeed *= 0.2f;
            xSpeed *= 0.2f;
        }
        float min = -ySpeed;
        float max = ySpeed;
        vehicle.setTurretXRot(Mth.clamp((float)(vehicle.getTurretXRot() + Mth.clamp((float)(0.99f * diffX), (float)(-xSpeed), (float)xSpeed)), (float)(-vehicle.getTurretMaxPitch()), (float)(-vehicle.getTurretMinPitch())));
        vehicle.setTurretYRot(Mth.clamp((float)(vehicle.getTurretYRot() - Mth.clamp((float)(0.99f * diffY), (float)min, (float)max)), (float)(-vehicle.getTurretMaxYaw()), (float)(-vehicle.getTurretMinYaw())));
        vehicle.turretYRotLock = Mth.clamp((float)(0.9f * diffY), (float)min, (float)max);
    }

    public static void turretAutoAimFromUuid(VehicleEntity vehicle, String uuid, LivingEntity pLiving) {
        Entity target = EntityFindUtil.findEntity(vehicle.level(), uuid);
        if (target == null) {
            return;
        }
        if (target.getVehicle() != null) {
            target = target.getVehicle();
        }
        Vec3 targetPos = target.getBoundingBox().getCenter();
        Vec3 targetVel = target.getDeltaMovement();
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            double gravity = living.getAttributeValue(Attributes.GRAVITY);
            targetVel = targetVel.add(0.0, gravity, 0.0);
        }
        if (target instanceof Player) {
            targetVel = targetVel.multiply(2.0, 1.0, 2.0);
        }
        Vec3 targetVec = RangeTool.calculateFiringSolution(vehicle.getShootPos((Entity)pLiving, 1.0f).subtract(vehicle.getShootVec((Entity)pLiving, 1.0f).scale(vehicle.getShootPos((Entity)pLiving, 1.0f).distanceTo(pLiving.position()))), targetPos, targetVel, vehicle.getProjectileVelocity((Entity)pLiving), vehicle.getProjectileGravity((Entity)pLiving));
        vehicle.turretAutoAimFromVector(targetVec);
    }

    public static void releaseSmokeDecoy(VehicleEntity vehicle, Vec3 vec3) {
        if (vehicle.decoyInputDown()) {
            if (((Boolean)vehicle.getEntityData().get(VehicleEntity.DECOY_READY)).booleanValue() && vehicle.level() instanceof ServerLevel) {
                for (int i = 0; i < 8; ++i) {
                    SmokeDecoyEntity smokeDecoyEntity = new SmokeDecoyEntity(vehicle.level());
                    smokeDecoyEntity.setPos(vehicle.getX(), vehicle.getY() + (double)vehicle.getBbHeight(), vehicle.getZ());
                    smokeDecoyEntity.decoyShoot(vehicle, vec3.yRot((-78.75f + 22.5f * (float)i) * ((float)Math.PI / 180)), 4.0f, 8.0f);
                    vehicle.level().addFreshEntity((Entity)smokeDecoyEntity);
                }
                vehicle.level().playSound(null, (Entity)vehicle, (SoundEvent)ModSounds.DECOY_RELEASE.get(), vehicle.getSoundSource(), 1.0f, 1.0f);
                vehicle.decoyReloadCoolDown = 500;
                vehicle.getEntityData().set(VehicleEntity.DECOY_READY, (Object)false);
            }
            vehicle.setDecoyInputDown(false);
        }
        if (!((Boolean)vehicle.getEntityData().get(VehicleEntity.DECOY_READY)).booleanValue() && vehicle.decoyReloadCoolDown == 0 && vehicle.level() instanceof ServerLevel) {
            vehicle.getEntityData().set(VehicleEntity.DECOY_READY, (Object)true);
            vehicle.level().playSound(null, (Entity)vehicle, (SoundEvent)ModSounds.DECOY_RELOAD.get(), vehicle.getSoundSource(), 1.0f, 1.0f);
            vehicle.decoyReloadCoolDown = 500;
        }
    }

    public static void releaseDecoy(VehicleEntity vehicle) {
        if (vehicle.decoyInputDown()) {
            if (((Boolean)vehicle.getEntityData().get(VehicleEntity.DECOY_READY)).booleanValue() && vehicle.level() instanceof ServerLevel) {
                for (int i = 0; i < 54; i += 6) {
                    int finalI = i;
                    Mod.queueServerWork(i, () -> {
                        Matrix4d transform = vehicle.getVehicleTransform(1.0f);
                        Vector4d worldPositionO = VehicleVecUtils.transformPosition(transform, 0.0, 0.0, 0.0);
                        Vector4d worldPosition = VehicleVecUtils.transformPosition(transform, 1.0, -0.2, 0.6);
                        Vector4d worldPosition2 = VehicleVecUtils.transformPosition(transform, -1.0, -0.2, 0.6);
                        Vec3 shootVecO = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
                        Vec3 shootVec1 = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
                        Vec3 shootVec2 = new Vec3(worldPosition2.x, worldPosition2.y, worldPosition2.z);
                        VehicleWeaponUtils.shootDecoy(vehicle, shootVecO.vectorTo(shootVec1).normalize(), finalI == 6);
                        VehicleWeaponUtils.shootDecoy(vehicle, shootVecO.vectorTo(shootVec2).normalize(), finalI == 6);
                    });
                }
                vehicle.decoyReloadCoolDown = 400;
                vehicle.getEntityData().set(VehicleEntity.DECOY_READY, (Object)false);
            }
            vehicle.setDecoyInputDown(false);
        }
        if (!((Boolean)vehicle.getEntityData().get(VehicleEntity.DECOY_READY)).booleanValue() && vehicle.decoyReloadCoolDown == 0 && vehicle.level() instanceof ServerLevel) {
            vehicle.getEntityData().set(VehicleEntity.DECOY_READY, (Object)true);
            vehicle.level().playSound(null, (Entity)vehicle, (SoundEvent)ModSounds.DECOY_RELOAD.get(), vehicle.getSoundSource(), 1.0f, 1.0f);
            vehicle.decoyReloadCoolDown = 400;
        }
    }

    public static void shootDecoy(VehicleEntity vehicle, Vec3 shootVec, boolean first) {
        FlareDecoyEntity flareDecoyEntity = new FlareDecoyEntity(vehicle.level());
        flareDecoyEntity.setPos(vehicle.getX() + vehicle.getDeltaMovement().x, vehicle.getY() + 0.5 + vehicle.getDeltaMovement().y, vehicle.getZ() + vehicle.getDeltaMovement().z);
        flareDecoyEntity.decoyShoot(vehicle, shootVec, (float)(vehicle.getDeltaMovement().length() * (double)0.3f + 0.7), 8.0f);
        vehicle.level().addFreshEntity((Entity)flareDecoyEntity);
        vehicle.level().playSound(null, (Entity)vehicle, first ? (SoundEvent)ModSounds.DECOY_RELEASE_FIRST.get() : (SoundEvent)ModSounds.DECOY_RELEASE.get(), vehicle.getSoundSource(), 2.0f, 1.0f);
    }
}

