/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.api.event.ProjectileHitEvent;
import com.atsuishio.superbwarfare.api.event.ReloadEvent;
import com.atsuishio.superbwarfare.config.server.ProjectileConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.GrapeshotEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public class CustomEventHandler {
    @SubscribeEvent
    public static void onPreReload(ReloadEvent.Pre event) {
        Entity shooter = event.shooter;
        ItemStack stack = event.stack;
        if (shooter == null || !(stack.getItem() instanceof GunItem) || shooter.level().isClientSide) {
            return;
        }
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().preReload(data, instance, shooter);
        }
    }

    @SubscribeEvent
    public static void onPostReload(ReloadEvent.Post event) {
        Entity shooter = event.shooter;
        ItemStack stack = event.stack;
        if (shooter == null || !(stack.getItem() instanceof GunItem) || shooter.level().isClientSide) {
            return;
        }
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().postReload(data, instance, shooter);
        }
    }

    @SubscribeEvent
    public static void onProjectileHitEntity(ProjectileHitEvent.HitEntity event) {
        Entity entity = event.getOwner();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        ItemStack stack = attacker.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        Projectile projectile = event.getProjectile();
        GunData data = GunData.from(stack);
        ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)projectile.getType());
        if (!data.compute().projectile().type.equals(key.toString())) {
            return;
        }
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().onHit(attacker, data, instance, event.getTarget());
        }
    }

    @SubscribeEvent
    public static void onProjectileHitBlock(ProjectileHitEvent.HitBlock event) {
        Projectile projectile = event.getProjectile();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        Block block = state.getBlock();
        if (block instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            if (projectile instanceof ProjectileEntity || projectile instanceof GrapeshotEntity) {
                bell.attemptToRing(projectile.level(), pos, face);
            }
        }
        if (projectile instanceof ProjectileEntity) {
            ProjectileEntity p = (ProjectileEntity)projectile;
            if (((Boolean)ProjectileConfig.ALLOW_PROJECTILE_DESTROY_BLOCKS.get()).booleanValue() && state.is(ModTags.Blocks.BULLET_CAN_DESTROY)) {
                p.level().destroyBlock(pos, false, p.getShooter());
            }
            if (state.getBlock() instanceof TargetBlock) {
                p.recordHitScore(face, event.getHitVec());
            }
        }
        if (projectile instanceof GrapeshotEntity) {
            GrapeshotEntity grapeshotEntity = (GrapeshotEntity)projectile;
            if (((Boolean)ProjectileConfig.ALLOW_PROJECTILE_DESTROY_BLOCKS.get()).booleanValue() && state.is(ModTags.Blocks.CANNON_SHOT_CAN_DESTROY)) {
                grapeshotEntity.level().destroyBlock(pos, false, grapeshotEntity.getOwner());
            }
        }
    }
}

