/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.init;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.block.entity.ChargingStationBlockEntity;
import com.atsuishio.superbwarfare.block.entity.CreativeChargingStationBlockEntity;
import com.atsuishio.superbwarfare.block.entity.FuMO25BlockEntity;
import com.atsuishio.superbwarfare.capability.energy.ItemEnergyStorage;
import com.atsuishio.superbwarfare.capability.laser.LaserCapability;
import com.atsuishio.superbwarfare.capability.laser.LaserCapabilityProvider;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.CreativeChargingStationBlockItem;
import com.atsuishio.superbwarfare.item.EnergyStorageItem;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

@EventBusSubscriber(modid="superbwarfare", bus=EventBusSubscriber.Bus.MOD)
public class ModCapabilities {
    public static final EntityCapability<LaserCapability, Void> LASER_CAPABILITY = EntityCapability.createVoid((ResourceLocation)Mod.loc("laser_capability"), LaserCapability.class);

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(LASER_CAPABILITY, EntityType.PLAYER, (ICapabilityProvider)new LaserCapabilityProvider());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntities.CHARGING_STATION.value(), ChargingStationBlockEntity::getEnergyStorage);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.CHARGING_STATION.value(), (object, context) -> {
            if (context == null || object.isRemoved()) {
                return null;
            }
            IItemHandler[] itemHandlers = new IItemHandler[]{new SidedInvWrapper((WorldlyContainer)object, Direction.UP), new SidedInvWrapper((WorldlyContainer)object, Direction.DOWN), new SidedInvWrapper((WorldlyContainer)object, Direction.NORTH)};
            return switch (context) {
                case Direction.UP -> itemHandlers[0];
                case Direction.DOWN -> itemHandlers[1];
                default -> itemHandlers[2];
            };
        });
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntities.CREATIVE_CHARGING_STATION.value(), CreativeChargingStationBlockEntity::getEnergyStorage);
        event.registerItem(Capabilities.EnergyStorage.ITEM, (obj, ctx) -> ((CreativeChargingStationBlockItem)obj.getItem()).getEnergyStorage(), new ItemLike[]{(ItemLike)ModItems.CREATIVE_CHARGING_STATION.value()});
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntities.FUMO_25.value(), FuMO25BlockEntity::getEnergyStorage);
        for (Item item : BuiltInRegistries.ITEM) {
            if (!(item instanceof EnergyStorageItem)) continue;
            event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, ctx) -> new ItemEnergyStorage((ItemStack)stack, s -> ((EnergyStorageItem)item).getMaxEnergy((ItemStack)s), s -> ((EnergyStorageItem)item).getMaxReceiveEnergy((ItemStack)s), s -> ((EnergyStorageItem)item).getMaxExtractEnergy((ItemStack)s)), new ItemLike[]{item});
        }
        for (EntityType entity : BuiltInRegistries.ENTITY_TYPE) {
            event.registerEntity(Capabilities.EnergyStorage.ENTITY, entity, (obj, ctx) -> {
                VehicleEntity vehicle;
                return obj instanceof VehicleEntity && (vehicle = (VehicleEntity)obj).hasEnergyStorage() ? vehicle.getEnergyStorage() : null;
            });
            event.registerEntity(Capabilities.ItemHandler.ENTITY, entity, (obj, ctx) -> {
                VehicleEntity vehicle;
                return obj instanceof VehicleEntity && (vehicle = (VehicleEntity)obj).hasContainer() ? new InvWrapper((Container)vehicle) : null;
            });
        }
        event.registerEntity(Capabilities.EnergyStorage.ENTITY, (EntityType)ModEntities.DPS_GENERATOR.get(), (obj, ctx) -> obj.getEnergyStorage());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.SUPERB_ITEM_INTERFACE.get(), (object, context) -> new InvWrapper((Container)object));
    }
}

