/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.client.screens.ArtilleryIndicatorScreen;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.item.ItemScreenProvider;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtilleryIndicator
extends Item
implements ItemScreenProvider {
    public static final String TAG_CANNON = "Cannons";
    public static final String TAG_TYPE = "Type";

    public ArtilleryIndicator() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        TooltipTool.addScreenProviderText(tooltipComponents);
        if (NBTTool.getTag(stack).contains(TAG_TYPE)) {
            tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.artillery_indicator.type", (Object[])new Object[]{Component.translatable((String)NBTTool.getTag(stack).getString(TAG_TYPE))}).withStyle(ChatFormatting.WHITE));
        }
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.artillery_indicator_1").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.artillery_indicator_2").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.artillery_indicator_3").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.artillery_indicator_4").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.literal((String)" ").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.artillery_indicator_5").withStyle(ChatFormatting.GRAY));
    }

    @ParametersAreNonnullByDefault
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (pHand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.fail((Object)pPlayer.getItemInHand(pHand));
        }
        pPlayer.playSound(SoundEvents.SPYGLASS_USE, 1.0f, 1.0f);
        pPlayer.startUsingItem(pHand);
        return InteractionResultHolder.consume((Object)pPlayer.getItemInHand(pHand));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        pLivingEntity.playSound(SoundEvents.SPYGLASS_STOP_USING, 1.0f, 1.0f);
        return pStack;
    }

    @ParametersAreNonnullByDefault
    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        pLivingEntity.playSound(SoundEvents.SPYGLASS_STOP_USING, 1.0f, 1.0f);
    }

    public boolean checkFull(ItemStack stack) {
        ListTag tags = NBTTool.getTag(stack).getList(TAG_CANNON, 10);
        return tags.size() >= (Integer)MiscConfig.ARTILLERY_INDICATOR_LIST_SIZE.get();
    }

    public boolean addCannon(ItemStack stack, Entity entity) {
        String uuid = entity.getStringUUID();
        CompoundTag tag = NBTTool.getTag(stack);
        ListTag tags = tag.getList(TAG_CANNON, 10);
        if (tags.isEmpty()) {
            tag.putString(TAG_TYPE, entity.getType().getDescriptionId());
        } else if (!tag.getString(TAG_TYPE).equals(entity.getType().getDescriptionId())) {
            return false;
        }
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>();
        for (int i = 0; i < tags.size(); ++i) {
            list.add(tags.getCompound(i));
        }
        for (CompoundTag t : list) {
            if (!t.getString("UUID").equals(uuid)) continue;
            return false;
        }
        CompoundTag uuidTag = new CompoundTag();
        uuidTag.putString("UUID", uuid);
        list.add(uuidTag);
        ListTag listTag = new ListTag();
        listTag.addAll(list);
        tag.put(TAG_CANNON, (Tag)listTag);
        NBTTool.saveTag(stack, tag);
        return true;
    }

    public boolean removeCannon(ItemStack stack, String uuid) {
        CompoundTag tag = NBTTool.getTag(stack);
        ListTag tags = tag.getList(TAG_CANNON, 10);
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>();
        boolean flag = false;
        for (int i = 0; i < tags.size(); ++i) {
            CompoundTag t = tags.getCompound(i);
            if (t.getString("UUID").equals(uuid)) {
                flag = true;
                continue;
            }
            list.add(tags.getCompound(i));
        }
        if (flag) {
            ListTag listTag = new ListTag();
            listTag.addAll(list);
            tag.put(TAG_CANNON, (Tag)listTag);
            tag.put(TAG_CANNON, (Tag)listTag);
            if (listTag.isEmpty()) {
                tag.remove(TAG_TYPE);
            }
            NBTTool.saveTag(stack, tag);
        }
        return flag;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen getItemScreen(ItemStack stack, Player player, InteractionHand hand) {
        return new ArtilleryIndicatorScreen(stack, hand);
    }

    public void setTarget(ItemStack stack, Player player) {
        CompoundTag mainTag = NBTTool.getTag(stack);
        ListTag tags = mainTag.getList(TAG_CANNON, 10);
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>();
        for (int i = 0; i < tags.size(); ++i) {
            CompoundTag tag = tags.getCompound(i);
            Entity entity = EntityFindUtil.findEntity(player.level(), tag.getString("UUID"));
            if (!(entity instanceof ArtilleryEntity)) continue;
            ArtilleryEntity artilleryEntity = (ArtilleryEntity)entity;
            list.add(tag);
            artilleryEntity.setTarget(stack, (Entity)player, "Main");
        }
        if (list.size() != tags.size()) {
            ListTag listTag = new ListTag();
            listTag.addAll(list);
            mainTag.put(TAG_CANNON, (Tag)listTag);
            if (listTag.isEmpty()) {
                mainTag.remove(TAG_TYPE);
            }
            NBTTool.saveTag(stack, mainTag);
        }
    }

    public InteractionResult bind(ItemStack stack, Player player, Entity entity) {
        if (this.checkFull(stack)) {
            player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.artillery_indicator.full").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (this.addCannon(stack, entity)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.artillery_indicator.add", (Object[])new Object[]{entity.getDisplayName()}).withStyle(ChatFormatting.GREEN), true);
            return InteractionResult.SUCCESS;
        }
        if (this.removeCannon(stack, entity.getStringUUID())) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.artillery_indicator.remove", (Object[])new Object[]{entity.getDisplayName()}).withStyle(ChatFormatting.RED), true);
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.artillery_indicator.fail", (Object[])new Object[]{entity.getDisplayName()}).withStyle(ChatFormatting.RED), true);
        return InteractionResult.FAIL;
    }
}

