/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.CustomDamageProperty;
import com.atsuishio.superbwarfare.tiers.ModItemTier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

@EventBusSubscriber(modid="superbwarfare", bus=EventBusSubscriber.Bus.MOD)
public class SteelPipe
extends SwordItem {
    public SteelPipe() {
        super((Tier)ModItemTier.STEEL, new CustomDamageProperty(810).attributes(SwordItem.createAttributes((Tier)ModItemTier.STEEL, (int)4, (float)-3.0f)));
    }

    public boolean hurtEnemy(@NotNull ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pAttacker.level().playSound(null, pTarget.getOnPos(), (SoundEvent)ModSounds.STEEL_PIPE_HIT.get(), SoundSource.PLAYERS, 1.0f, (float)((2.0 * Math.random() - 1.0) * (double)0.1f + 1.0));
        return super.hurtEnemy(pStack, pTarget, pAttacker);
    }

    @ParametersAreNonnullByDefault
    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        if (stack.isEmpty()) {
            attacker.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Holder.direct((Object)Items.STICK), 1, stack.getComponentsPatch()));
        }
    }

    @SubscribeEvent
    private static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public boolean shouldBobAsEntity(@NotNull ItemStack stack) {
                return false;
            }
        }, new Holder[]{ModItems.STEEL_PIPE});
    }
}

