/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.common.ammo;

import com.atsuishio.superbwarfare.entity.projectile.MortarShellEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MortarShell
extends Item
implements ProjectileItem {
    public MortarShell() {
        super(new Item.Properties());
    }

    public static MortarShellEntity createShell(@Nullable LivingEntity entity, Level level, ItemStack stack, float gravity, float damage, float explosionDamage, float explosionRadius) {
        MortarShellEntity shellEntity = new MortarShellEntity(entity, level, damage, explosionDamage, explosionRadius);
        shellEntity.setGravity(gravity);
        shellEntity.setEffectsFromItem(stack);
        return shellEntity;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        MortarShellEntity shell = new MortarShellEntity((EntityType<? extends MortarShellEntity>)((EntityType)ModEntities.MORTAR_SHELL.get()), pos.x(), pos.y(), pos.z(), level, 0.13f);
        shell.setEffectsFromItem(stack);
        return shell;
    }

    @NotNull
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().power(0.5f).build();
    }

    public static class MortarShellDispenseBehavior
    extends ProjectileDispenseBehavior {
        public MortarShellDispenseBehavior(Item item) {
            super(item);
        }

        protected void playSound(BlockSource blockSource) {
            blockSource.level().playSound(null, blockSource.pos(), (SoundEvent)ModSounds.MORTAR_FIRE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

