/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.curio;

import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.client.screens.DogTagEditorScreen;
import com.atsuishio.superbwarfare.client.tooltip.component.DogTagImageComponent;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.item.ItemScreenProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class DogTagItem
extends Item
implements ICurioItem,
ItemScreenProvider {
    public DogTagItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        TooltipTool.addScreenProviderText(tooltipComponents);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity()).flatMap(c -> c.findFirstCurio((Item)this)).isEmpty();
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        return Optional.of(new DogTagImageComponent(pStack));
    }

    public static short[][] getColors(ItemStack stack) {
        short[][] colors;
        for (short[] el : colors = new short[16][16]) {
            Arrays.fill(el, (short)-1);
        }
        List data = (List)stack.get(ModDataComponents.DOG_TAG_IMAGE);
        if (data == null) {
            return colors;
        }
        int index = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                colors[i][j] = (Short)data.get(index);
                ++index;
            }
        }
        return colors;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen getItemScreen(ItemStack stack, Player player, InteractionHand hand) {
        return new DogTagEditorScreen(stack, hand);
    }
}

